/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.audio;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioRecordingConfiguration;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import video.pano.rtc.audio.AudioDeviceCompatibility;
import video.pano.rtc.audio.AudioDeviceUtils;
import video.pano.rtc.audio.BluetoothManager;
import video.pano.rtc.audio.CallProximityManager;
import video.pano.rtc.base.thread.ThreadUtils;
import video.pano.rtc.base.util.ArrayUtils;
import video.pano.rtc.base.util.Checker;
import video.pano.rtc.base.util.Compatibility;
import video.pano.rtc.base.util.LooperUtils;
import video.pano.rtc.impl.PLogger;

public final class AudioDeviceManager {
    private static final String TAG = "[AudioDevice]";
    private int mSavedAudioMode = -2;
    private boolean mSavedIsSpeakerPhoneOn = false;
    private boolean mSavedIsMicrophoneMute = false;
    private boolean mHasWiredHeadset = false;
    private final AudioManager mAudioManager;
    private final BluetoothManager mBluetoothManager;
    private final WiredHeadsetReceiver mWiredHeadsetReceiver;
    private final Context mContext;
    private AudioManagerState mAudioManagerState;
    private int mDefaultAudioDevice = -1;
    private int mSelectedAudioDevice = -1;
    private int mUserSelectedAudioDevice = -1;
    private AudioManagerEvents mAudioManagerEvents;
    private CallProximityManager mCallProximityManager;
    private boolean mProximityActivated = true;
    private boolean mEnableAutoSelection = true;
    private Set<Integer> mAudioDevices = new HashSet<Integer>();
    private Handler mHandler;
    private AudioManager.OnAudioFocusChangeListener mAudioFocusChangeListener;
    private Object mAudioPlaybackCallback;
    private Object mAudioRecordingCallback;
    private Object mAudioDeviceCallback;
    private final VolumeLogger mVolumeLogger;
    private static final int VOLUME_LOGGER_INTERVAL_MS = 5000;

    public static AudioDeviceManager create(Context context) {
        return new AudioDeviceManager(context);
    }

    private AudioDeviceManager(Context context) {
        ThreadUtils.checkIsOnUiThread();
        this.mContext = context;
        this.mAudioManager = Build.VERSION.SDK_INT > 22 ? (AudioManager)context.getSystemService(AudioManager.class) : (AudioManager)context.getSystemService("audio");
        this.mBluetoothManager = BluetoothManager.create(context, this);
        this.mWiredHeadsetReceiver = new WiredHeadsetReceiver();
        this.mAudioManagerState = AudioManagerState.UNINITIALIZED;
        this.mVolumeLogger = new VolumeLogger(this.mAudioManager);
        PLogger.nd(TAG, "defaultAudioDevice: " + this.mDefaultAudioDevice);
    }

    public void start(int defaultAudioDevice, int audioMode, boolean enableCallProximity, AudioManagerEvents audioManagerEvents) {
        List configs;
        Checker.checkNotNull(defaultAudioDevice, "AudioDeviceManager start error, default audio device is null");
        Checker.checkNotNull(audioManagerEvents, "AudioDeviceManager start error, event callback is null");
        PLogger.ni(TAG, "start");
        ThreadUtils.checkIsOnUiThread();
        if (this.mAudioManagerState == AudioManagerState.RUNNING) {
            PLogger.e(TAG, "AudioManager is already active");
            return;
        }
        if (Compatibility.runningOnOreoOrHigher()) {
            configs = this.mAudioManager.getActivePlaybackConfigurations();
            for (AudioPlaybackConfiguration apc : configs) {
                PLogger.ni(TAG, "Active Playback: " + AudioDeviceUtils.audioPlaybackConfigurationToString(apc));
            }
        }
        if (Compatibility.runningOnNougatOrHigher()) {
            configs = this.mAudioManager.getActiveRecordingConfigurations();
            for (AudioRecordingConfiguration arc : configs) {
                PLogger.ni(TAG, "Active Recording: " + AudioDeviceUtils.audioRecordingConfigurationToString(arc));
            }
        }
        PLogger.nd(TAG, "AudioManager starts...");
        this.mAudioManagerEvents = audioManagerEvents;
        this.mAudioManagerState = AudioManagerState.RUNNING;
        if (this.mHandler != null) {
            LooperUtils.quitSafely(this.mHandler);
            this.mHandler = null;
        }
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
        this.saveAudioStatus();
        this.mHasWiredHeadset = this.hasWiredHeadset();
        int streamType = AudioDeviceCompatibility.streamType;
        int audioSource = AudioDeviceCompatibility.audioSource;
        this.registerAudioFocusRequest(true, streamType);
        this.registerAudioPlaybackCallback(true);
        this.registerAudioRecordingCallback(true);
        this.setAudioMode(audioMode);
        this.mVolumeLogger.start();
        this.setMicrophoneMute(false);
        this.mSelectedAudioDevice = -1;
        if (this.mDefaultAudioDevice == -1) {
            this.mDefaultAudioDevice = defaultAudioDevice;
        }
        this.mAudioDevices.clear();
        this.mBluetoothManager.start();
        this.updateAudioDeviceState();
        this.mContext.registerReceiver((BroadcastReceiver)this.mWiredHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        if (enableCallProximity) {
            if (this.mCallProximityManager == null) {
                this.mCallProximityManager = new CallProximityManager(this.mContext, new CallProximityManager.ProximityDirector(){

                    @Override
                    public boolean shouldActivateProximity() {
                        return AudioDeviceManager.this.proximityActivated();
                    }

                    @Override
                    public void onProximityTrackingChanged(boolean acquired) {
                        AudioDeviceManager.this.onProximitySensorChangedState(acquired);
                    }
                });
            }
            this.mCallProximityManager.startTracking();
        }
        PLogger.nd(TAG, "AudioManager started");
        this.logAudioProfile(audioMode, streamType, audioSource);
        AudioDeviceUtils.logAudioState(TAG);
    }

    private void registerAudioFocusRequest(boolean register, int streamType) {
        if (register) {
            if (this.mAudioFocusChangeListener == null) {
                this.mAudioFocusChangeListener = focusChange -> {
                    String typeOfChange = AudioDeviceUtils.audioFocusChangeToString(focusChange);
                    PLogger.ni(TAG, "onAudioFocusChange: " + typeOfChange);
                    if (focusChange == 1 || focusChange == 2) {
                        Handler handler = new Handler(Looper.getMainLooper());
                        handler.postDelayed(this::recoverSelectedAudioDevice, 1000L);
                    }
                };
                int result = this.mAudioManager.requestAudioFocus(this.mAudioFocusChangeListener, streamType, 2);
                if (result == 1) {
                    PLogger.ni(TAG, "Audio focus request granted for " + AudioDeviceUtils.streamTypeToString(streamType));
                } else {
                    PLogger.e(TAG, "Audio focus request failed");
                }
            }
        } else if (this.mAudioFocusChangeListener != null) {
            this.mAudioManager.abandonAudioFocus(this.mAudioFocusChangeListener);
            this.mAudioFocusChangeListener = null;
            PLogger.ni(TAG, "Abandoned audio focus for VOICE_CALL streams");
        }
    }

    @SuppressLint(value={"NewApi"})
    private void registerAudioRecordingCallback(boolean register) {
        if (Compatibility.runningOnNougatOrHigher()) {
            if (register) {
                if (this.mAudioRecordingCallback == null) {
                    this.mAudioRecordingCallback = new AudioManager.AudioRecordingCallback(){

                        public void onRecordingConfigChanged(List<AudioRecordingConfiguration> configs) {
                            PLogger.ni(AudioDeviceManager.TAG, "Recording Config Changed: ");
                            for (AudioRecordingConfiguration arc : configs) {
                                PLogger.ni(AudioDeviceManager.TAG, "  " + AudioDeviceUtils.audioRecordingConfigurationToString(arc));
                            }
                        }
                    };
                    AudioManager.AudioRecordingCallback cb = (AudioManager.AudioRecordingCallback)this.mAudioRecordingCallback;
                    this.mAudioManager.registerAudioRecordingCallback(cb, this.mHandler);
                }
            } else if (this.mAudioRecordingCallback != null) {
                AudioManager.AudioRecordingCallback cb = (AudioManager.AudioRecordingCallback)this.mAudioRecordingCallback;
                this.mAudioManager.unregisterAudioRecordingCallback(cb);
                this.mAudioRecordingCallback = null;
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void registerAudioPlaybackCallback(boolean register) {
        if (Compatibility.runningOnOreoOrHigher()) {
            if (register) {
                if (this.mAudioPlaybackCallback == null) {
                    this.mAudioPlaybackCallback = new AudioManager.AudioPlaybackCallback(){

                        public void onPlaybackConfigChanged(List<AudioPlaybackConfiguration> configs) {
                            PLogger.ni(AudioDeviceManager.TAG, "Playback Config Changed: ");
                            for (AudioPlaybackConfiguration apc : configs) {
                                PLogger.ni(AudioDeviceManager.TAG, "  " + AudioDeviceUtils.audioPlaybackConfigurationToString(apc));
                            }
                        }
                    };
                    AudioManager.AudioPlaybackCallback cb = (AudioManager.AudioPlaybackCallback)this.mAudioPlaybackCallback;
                    this.mAudioManager.registerAudioPlaybackCallback(cb, this.mHandler);
                }
            } else if (this.mAudioPlaybackCallback != null) {
                AudioManager.AudioPlaybackCallback cb = (AudioManager.AudioPlaybackCallback)this.mAudioPlaybackCallback;
                this.mAudioManager.unregisterAudioPlaybackCallback(cb);
                this.mAudioPlaybackCallback = null;
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void registerAudioDeviceCallback(boolean register) {
        if (Compatibility.runningOnMarshmallowOrHigher()) {
            if (register) {
                if (this.mAudioDeviceCallback == null) {
                    this.mAudioDeviceCallback = new AudioDeviceCallback(){

                        public void onAudioDevicesAdded(AudioDeviceInfo[] addedDevices) {
                            PLogger.ni(AudioDeviceManager.TAG, "Audio Devices Added: ");
                            if (addedDevices == null || addedDevices.length == 0) {
                                PLogger.ni(AudioDeviceManager.TAG, "    Devices info is null!!");
                            } else {
                                for (AudioDeviceInfo info : addedDevices) {
                                    PLogger.ni(AudioDeviceManager.TAG, "  " + AudioDeviceUtils.audioDeviceInfoToString(info));
                                }
                            }
                        }

                        public void onAudioDevicesRemoved(AudioDeviceInfo[] removedDevices) {
                            PLogger.ni(AudioDeviceManager.TAG, "Audio Devices Removed: ");
                            if (removedDevices == null || removedDevices.length == 0) {
                                PLogger.ni(AudioDeviceManager.TAG, "    Devices info is null!!");
                            } else {
                                for (AudioDeviceInfo info : removedDevices) {
                                    PLogger.ni(AudioDeviceManager.TAG, "    " + AudioDeviceUtils.audioDeviceInfoToString(info));
                                }
                            }
                        }
                    };
                    AudioDeviceCallback cb = (AudioDeviceCallback)this.mAudioDeviceCallback;
                    this.mAudioManager.registerAudioDeviceCallback(cb, this.mHandler);
                }
            } else if (this.mAudioDeviceCallback != null) {
                AudioDeviceCallback cb = (AudioDeviceCallback)this.mAudioDeviceCallback;
                this.mAudioManager.unregisterAudioDeviceCallback(cb);
                this.mAudioDeviceCallback = null;
            }
        }
    }

    private void logAudioProfile(int audioMode, int streamType, int audioSource) {
        String str = "Audio compat Profile: profile:audio mode:" + AudioDeviceUtils.audioModeToString(audioMode) + ", stream type:" + AudioDeviceUtils.streamTypeToString(streamType) + ", audio source:" + AudioDeviceUtils.audioSourceToString(audioSource);
        PLogger.ni(TAG, str);
    }

    public void stop() {
        PLogger.ni(TAG, "stop");
        ThreadUtils.checkIsOnUiThread();
        if (this.mAudioManagerState != AudioManagerState.RUNNING) {
            PLogger.ni(TAG, "Trying to stop AudioManager in incorrect state: " + (Object)((Object)this.mAudioManagerState));
            return;
        }
        this.mAudioManagerState = AudioManagerState.UNINITIALIZED;
        this.mVolumeLogger.stop();
        PLogger.ni(TAG, "stop volume logger done");
        try {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mWiredHeadsetReceiver);
        }
        catch (Exception e) {
            PLogger.w(TAG, e.getMessage());
        }
        PLogger.ni(TAG, "stop unregister receiver done");
        this.mBluetoothManager.stop();
        PLogger.ni(TAG, "stop bluetooth done");
        this.registerAudioFocusRequest(false, 0);
        this.registerAudioDeviceCallback(false);
        this.registerAudioPlaybackCallback(false);
        this.registerAudioRecordingCallback(false);
        if (this.mCallProximityManager != null) {
            this.mCallProximityManager.stopTracking();
        }
        PLogger.ni(TAG, "stop call proximity done");
        if (this.mHandler != null) {
            LooperUtils.quitSafely(this.mHandler);
            this.mHandler = null;
        }
        this.restoreAudioStatus();
        this.mAudioManagerEvents = null;
        PLogger.ni(TAG, "AudioManager stopped");
    }

    private void setAudioDeviceInternal(int device) {
        PLogger.ni(TAG, "setAudioDeviceInternal(device=" + AudioDeviceUtils.audioDeviceToString(device) + ")");
        switch (device) {
            case 0: {
                this.setSpeakerphoneOn(true);
                break;
            }
            case 2: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case 1: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case 3: {
                this.setSpeakerphoneOn(false);
                break;
            }
            default: {
                PLogger.e(TAG, "Invalid audio device selection");
            }
        }
        if (device != this.mSelectedAudioDevice) {
            this.mSelectedAudioDevice = device;
            if (this.mAudioManagerEvents != null) {
                this.mAudioManagerEvents.onAudioSelectedDeviceChanged(this.mSelectedAudioDevice);
            }
        }
    }

    public void setDefaultAudioDevice(int defaultDevice) {
        ThreadUtils.checkIsOnUiThread();
        switch (defaultDevice) {
            case 0: {
                this.mDefaultAudioDevice = defaultDevice;
                break;
            }
            case 2: {
                if (this.hasEarpiece()) {
                    this.mDefaultAudioDevice = defaultDevice;
                    break;
                }
                this.mDefaultAudioDevice = 0;
                break;
            }
            default: {
                PLogger.e(TAG, "Invalid default audio device selection");
            }
        }
        PLogger.ni(TAG, "setDefaultAudioDevice(device=" + AudioDeviceUtils.audioDeviceToString(this.mDefaultAudioDevice) + ")");
        this.updateAudioDeviceState();
    }

    public void selectAudioDevice(int device) {
        ThreadUtils.checkIsOnUiThread();
        PLogger.ni(TAG, "select audio device:" + AudioDeviceUtils.audioDeviceToString(device));
        if (this.mAudioManagerState == AudioManagerState.RUNNING && device != -1 && !this.mAudioDevices.contains(device)) {
            PLogger.w(TAG, "The selected device " + AudioDeviceUtils.audioDeviceToString(device) + " is not in list " + AudioDeviceUtils.audioDeviceToString(ArrayUtils.toPrimitive(this.mAudioDevices.toArray(new Integer[0]))));
        }
        this.mUserSelectedAudioDevice = device;
        this.updateAudioDeviceState();
    }

    public void enableAudioDeviceSelection(boolean enabled) {
        PLogger.ni(TAG, "enableAudioDeviceSelection: " + enabled);
        this.mEnableAutoSelection = enabled;
        if (this.mAudioManagerState == AudioManagerState.RUNNING && this.mEnableAutoSelection) {
            this.updateAudioDeviceState();
        }
    }

    public void recoverSelectedAudioDevice() {
        PLogger.ni(TAG, "+++++ recoverSelectedAudioDevice, default=" + this.mDefaultAudioDevice + ", selected=" + this.mSelectedAudioDevice + ", userSelected=" + this.mUserSelectedAudioDevice);
        int dev = this.mDefaultAudioDevice;
        if (this.mSelectedAudioDevice != -1) {
            dev = this.mSelectedAudioDevice;
        }
        this.setAudioDeviceInternal(dev);
    }

    public Set<Integer> getAudioDevices() {
        ThreadUtils.checkIsOnUiThread();
        return Collections.unmodifiableSet(new HashSet<Integer>(this.mAudioDevices));
    }

    public int getSelectedAudioDevice() {
        return this.mSelectedAudioDevice;
    }

    public void activateProximity(boolean enable) {
        PLogger.ni(TAG, "activate proximity :" + enable);
        this.mProximityActivated = enable;
    }

    private boolean proximityActivated() {
        return this.mProximityActivated;
    }

    private boolean hasWiredHeadset() {
        return this.mAudioManager.isWiredHeadsetOn();
    }

    private boolean hasEarpiece() {
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private void onProximitySensorChangedState(boolean nearState) {
        if (this.mAudioDevices.size() == 2 && this.mAudioDevices.contains(2) && this.mAudioDevices.contains(0)) {
            PLogger.ni(TAG, "onProximitySensorChangedState -> near: " + nearState);
            if (nearState) {
                if (this.mSelectedAudioDevice != 2) {
                    this.setAudioDeviceInternal(2);
                }
            } else {
                int newAudioDevice = this.mUserSelectedAudioDevice;
                if (newAudioDevice == -1) {
                    newAudioDevice = this.mDefaultAudioDevice;
                }
                if (newAudioDevice != this.mSelectedAudioDevice) {
                    this.setAudioDeviceInternal(newAudioDevice);
                }
            }
        } else {
            PLogger.ni(TAG, "onProximitySensorChangedState -> ignore");
        }
    }

    private void saveAudioStatus() {
        this.mSavedAudioMode = this.mAudioManager.getMode();
        this.mSavedIsSpeakerPhoneOn = this.mAudioManager.isSpeakerphoneOn();
        this.mSavedIsMicrophoneMute = this.mAudioManager.isMicrophoneMute();
        PLogger.ni(TAG, "save system audio state[audio mode:" + AudioDeviceUtils.audioModeToString(this.mSavedAudioMode) + ", microphone mute:" + this.mSavedIsMicrophoneMute + ", speakerphone on:" + this.mSavedIsSpeakerPhoneOn + "]");
    }

    private void restoreAudioStatus() {
        PLogger.ni(TAG, "restore audio status");
        this.setMicrophoneMute(this.mSavedIsMicrophoneMute);
        PLogger.ni(TAG, "restore setMicrophoneMute done");
        this.setSpeakerphoneOn(this.mSavedIsSpeakerPhoneOn);
        PLogger.ni(TAG, "restore setSpeakerphoneOn done");
        this.mAudioManager.setMode(this.mSavedAudioMode);
        PLogger.ni(TAG, "restore system audio state[audio mode:" + AudioDeviceUtils.audioModeToString(this.mSavedAudioMode) + ", microphone mute:" + this.mSavedIsMicrophoneMute + ", speakerphone on:" + this.mSavedIsSpeakerPhoneOn + "]");
    }

    private void setSpeakerphoneOn(boolean on) {
        boolean wasOn = this.mAudioManager.isSpeakerphoneOn();
        if (wasOn == on) {
            PLogger.ni(TAG, "setSpeakerphoneOn, Speaker is already " + on);
            return;
        }
        this.mAudioManager.setSpeakerphoneOn(on);
        PLogger.ni(TAG, "setSpeakerphoneOn " + on + " ,result -> " + this.mAudioManager.isSpeakerphoneOn());
    }

    private void setMicrophoneMute(boolean on) {
        boolean wasMuted = this.mAudioManager.isMicrophoneMute();
        if (wasMuted == on) {
            return;
        }
        this.mAudioManager.setMicrophoneMute(on);
    }

    public void setAudioMode(int audioMode) {
        PLogger.ni(TAG, "set audio mode: " + AudioDeviceUtils.audioModeToString(audioMode));
        this.mAudioManager.setMode(audioMode);
    }

    void updateAudioDeviceState() {
        int newAudioDevice;
        boolean needBluetoothAudioStop;
        ThreadUtils.checkIsOnUiThread();
        if (!this.mEnableAutoSelection) {
            return;
        }
        PLogger.ni(TAG, "updateAudioDeviceState: wired headset=" + this.mHasWiredHeadset + ", BT state=" + (Object)((Object)this.mBluetoothManager.getState()));
        PLogger.ni(TAG, "Current device status: available=" + AudioDeviceUtils.audioDeviceToString(ArrayUtils.toPrimitive(this.mAudioDevices.toArray(new Integer[0]))) + ", selected=" + AudioDeviceUtils.audioDeviceToString(this.mSelectedAudioDevice) + ", user selected=" + AudioDeviceUtils.audioDeviceToString(this.mUserSelectedAudioDevice));
        if (this.mBluetoothManager.getState() == BluetoothManager.State.HEADSET_AVAILABLE || this.mBluetoothManager.getState() == BluetoothManager.State.HEADSET_UNAVAILABLE || this.mBluetoothManager.getState() == BluetoothManager.State.SCO_DISCONNECTING) {
            this.mBluetoothManager.updateDevice();
        }
        HashSet<Integer> newAudioDevices = new HashSet<Integer>();
        if (this.mBluetoothManager.getState() == BluetoothManager.State.SCO_CONNECTED || this.mBluetoothManager.getState() == BluetoothManager.State.SCO_CONNECTING || this.mBluetoothManager.getState() == BluetoothManager.State.HEADSET_AVAILABLE) {
            newAudioDevices.add(3);
        }
        if (this.mHasWiredHeadset) {
            newAudioDevices.add(1);
        } else {
            newAudioDevices.add(0);
            if (this.hasEarpiece()) {
                newAudioDevices.add(2);
            }
        }
        boolean audioDeviceSetUpdated = !this.mAudioDevices.equals(newAudioDevices);
        this.mAudioDevices = newAudioDevices;
        int newUserSelectedAudioDevice = this.mUserSelectedAudioDevice;
        if (this.mBluetoothManager.getState() == BluetoothManager.State.HEADSET_UNAVAILABLE && this.mUserSelectedAudioDevice == 3) {
            newUserSelectedAudioDevice = -1;
        }
        if (!this.mHasWiredHeadset && this.mUserSelectedAudioDevice == 1) {
            newUserSelectedAudioDevice = -1;
        }
        boolean needBluetoothAudioStart = this.mBluetoothManager.getState() == BluetoothManager.State.HEADSET_AVAILABLE && (newUserSelectedAudioDevice == -1 || newUserSelectedAudioDevice == 3);
        boolean bl = needBluetoothAudioStop = (this.mBluetoothManager.getState() == BluetoothManager.State.SCO_CONNECTED || this.mBluetoothManager.getState() == BluetoothManager.State.SCO_CONNECTING) && newUserSelectedAudioDevice != -1 && newUserSelectedAudioDevice != 3;
        if (this.mBluetoothManager.getState() == BluetoothManager.State.HEADSET_AVAILABLE || this.mBluetoothManager.getState() == BluetoothManager.State.SCO_CONNECTING || this.mBluetoothManager.getState() == BluetoothManager.State.SCO_CONNECTED) {
            PLogger.ni(TAG, "Need BT audio: start=" + needBluetoothAudioStart + ", stop=" + needBluetoothAudioStop + ", BT state=" + (Object)((Object)this.mBluetoothManager.getState()));
        }
        if (needBluetoothAudioStop) {
            this.mBluetoothManager.stopScoAudio();
            this.mBluetoothManager.updateDevice();
        }
        if (needBluetoothAudioStart && !this.mBluetoothManager.startScoAudio()) {
            this.mAudioDevices.remove(3);
            if (newUserSelectedAudioDevice == 3) {
                newUserSelectedAudioDevice = -1;
            }
            audioDeviceSetUpdated = true;
        }
        if ((newAudioDevice = newUserSelectedAudioDevice != -1 ? newUserSelectedAudioDevice : (this.mBluetoothManager.getState() == BluetoothManager.State.SCO_CONNECTED ? 3 : (this.mHasWiredHeadset ? 1 : this.mDefaultAudioDevice))) != this.mSelectedAudioDevice || audioDeviceSetUpdated) {
            this.setAudioDeviceInternal(newAudioDevice);
            PLogger.ni(TAG, "New device status: available=" + AudioDeviceUtils.audioDeviceToString(ArrayUtils.toPrimitive(this.mAudioDevices.toArray(new Integer[0]))) + ", selected=" + AudioDeviceUtils.audioDeviceToString(newAudioDevice));
        }
        PLogger.ni(TAG, "updateAudioDeviceState done");
    }

    private static class VolumeLogger {
        private static final String THREAD_NAME = "VolumeLogger";
        private final AudioManager audioManager;
        private Timer timer;

        VolumeLogger(AudioManager audioManager) {
            this.audioManager = audioManager;
        }

        public void start() {
            this.timer = new Timer(THREAD_NAME);
            this.timer.schedule((TimerTask)new LogVolumeTask(this.audioManager.getStreamMaxVolume(2), this.audioManager.getStreamMaxVolume(0), this.audioManager.getStreamMaxVolume(3)), 5000L, 5000L);
        }

        private void stop() {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }

        private class LogVolumeTask
        extends TimerTask {
            private final int maxRingVolume;
            private final int maxVoiceCallVolume;
            private final int maxMusicVolume;
            private int currentRingVolume;
            private int currentVoiceCallVolume;
            private int currentMusicVolume;
            private int currentMode;

            LogVolumeTask(int maxRingVolume, int maxVoiceCallVolume, int maxMusicVolume) {
                this.maxRingVolume = maxRingVolume;
                this.maxVoiceCallVolume = maxVoiceCallVolume;
                this.maxMusicVolume = maxMusicVolume;
            }

            @Override
            public void run() {
                int mode = VolumeLogger.this.audioManager.getMode();
                int ringVolume = VolumeLogger.this.audioManager.getStreamVolume(2);
                int voiceCallVolume = VolumeLogger.this.audioManager.getStreamVolume(0);
                int musicVolume = VolumeLogger.this.audioManager.getStreamVolume(3);
                if (mode != this.currentMode) {
                    PLogger.ni(AudioDeviceManager.TAG, "audio mode: " + AudioDeviceUtils.audioModeToString(mode));
                    this.currentMode = mode;
                }
                if (ringVolume != this.currentRingVolume) {
                    PLogger.ni(AudioDeviceManager.TAG, "STREAM_RING stream volume: " + ringVolume + " (max=" + this.maxRingVolume + ")");
                    this.currentRingVolume = ringVolume;
                }
                if (voiceCallVolume != this.currentVoiceCallVolume) {
                    PLogger.ni(AudioDeviceManager.TAG, "VOICE_CALL stream volume: " + voiceCallVolume + " (max=" + this.maxVoiceCallVolume + ")");
                    this.currentVoiceCallVolume = voiceCallVolume;
                }
                if (musicVolume != this.currentMusicVolume) {
                    PLogger.ni(AudioDeviceManager.TAG, "STREAM_MUSIC stream volume: " + musicVolume + " (max=" + this.maxMusicVolume + ")");
                    this.currentMusicVolume = musicVolume;
                }
            }
        }
    }

    private class WiredHeadsetReceiver
    extends BroadcastReceiver {
        private static final int STATE_UNPLUGGED = 0;
        private static final int STATE_PLUGGED = 1;
        private static final int HAS_NO_MIC = 0;
        private static final int HAS_MIC = 1;

        private WiredHeadsetReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("state", 0);
            int microphone = intent.getIntExtra("microphone", 0);
            String name = intent.getStringExtra("name");
            PLogger.ni(AudioDeviceManager.TAG, "WiredHeadsetReceiver.onReceive: a=" + intent.getAction() + ", s=" + (state == 0 ? "unplugged" : "plugged") + ", m=" + (microphone == 1 ? "mic" : "no mic") + ", n=" + name + ", sb=" + this.isInitialStickyBroadcast());
            AudioDeviceManager.this.mHasWiredHeadset = state == 1;
            if (AudioDeviceManager.this.mHasWiredHeadset) {
                // empty if block
            }
            AudioDeviceManager.this.updateAudioDeviceState();
        }
    }

    public static interface AudioManagerEvents {
        default public void onAudioDeviceChanged(int selectedAudioDevice, Set<Integer> availableAudioDevices) {
        }

        default public void onAudioSelectedDeviceChanged(int device) {
        }
    }

    private static enum AudioManagerState {
        UNINITIALIZED,
        RUNNING;

    }

    public static interface AudioDevice {
        public static final int SPEAKER_PHONE = 0;
        public static final int WIRED_HEADSET = 1;
        public static final int EARPIECE = 2;
        public static final int BLUETOOTH = 3;
        public static final int NONE = -1;
    }
}

