/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.view.Surface;
import android.view.ViewParent;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.PanoCoursePageView;
import com.pano.rtc.api.RtcWbView;
import com.pano.rtc.api.RtcWhiteboard;
import com.pano.rtc.api.WBDocContents;
import com.pano.rtc.api.WBDocConvertConfig;
import com.pano.rtc.api.WBDocInfo;
import com.pano.rtc.api.WBStamp;
import com.pano.rtc.api.WBVisionConfig;
import com.pano.rtc.impl.RtcWbCallbackImpl;
import com.pano.rtc.impl.RtcWbDrawer;
import com.pano.rtc.impl.WBDocContentsImpl;
import com.pano.rtc.impl.WBDocConvertConfigImpl;
import com.pano.rtc.impl.WBDocInfoImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import video.pano.rtc.impl.GlobalRef;

public class RtcWhiteboardImpl
implements RtcWhiteboard,
RtcWbCallbackImpl {
    private static final String TAG = "[pano]";
    private long mNativeHandle;
    private final String mWhiteboardId;
    private String mOldWhiteboardId;
    private RtcWbView mWbView;
    private RtcWbView.Callback mViewCallback;
    private RtcWhiteboard.Callback mWbCallback;
    private final RtcWbDrawer mWbDrawer;
    private boolean mEnableDrawer;
    private final Map<String, WBDocInfo> mDocInfoMap;
    private int mBgColor;

    RtcWhiteboardImpl(long nativeHandle, String wbId) {
        this.mNativeHandle = nativeHandle;
        this.mWhiteboardId = wbId;
        this.mWbDrawer = new RtcWbDrawer(this.mNativeHandle, this.mWhiteboardId, new RtcWbDrawer.Callback(){

            @Override
            public void onActionBegin() {
                RtcWhiteboardImpl.this.mOldWhiteboardId = RtcWhiteboardImpl.this.WBGetCurrentWhiteboardId(RtcWhiteboardImpl.this.getNativeHandle());
                RtcWhiteboardImpl.this.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), RtcWhiteboardImpl.this.mWhiteboardId);
            }

            @Override
            public void onActionEnd() {
                RtcWhiteboardImpl.this.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), RtcWhiteboardImpl.this.mOldWhiteboardId);
            }
        });
        this.mEnableDrawer = true;
        this.mDocInfoMap = new HashMap<String, WBDocInfo>();
        this.mBgColor = -1;
    }

    @Override
    public Constants.QResult setCallback(RtcWhiteboard.Callback callback) {
        this.mWbCallback = callback;
        this.WBSetCallback(this.mNativeHandle, this);
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setRoleType(Constants.WBRoleType role) {
        int ret = this.WBSetRoleType(this.mNativeHandle, role.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult open(final RtcWbView view) {
        this.mViewCallback = new RtcWbView.Callback(){

            @Override
            public void onViewReady(int w, int h) {
                String wbId = RtcWhiteboardImpl.this.WBGetCurrentWhiteboardId(RtcWhiteboardImpl.this.getNativeHandle());
                RtcWhiteboardImpl.this.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), RtcWhiteboardImpl.this.mWhiteboardId);
                RtcWhiteboardImpl.this.WBOpen(RtcWhiteboardImpl.this.getNativeHandle(), view.getHolder().getSurface());
                RtcWhiteboardImpl.this.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), wbId);
            }

            @Override
            public void onViewSizeChanged(int w, int h) {
                String wbId = RtcWhiteboardImpl.this.WBGetCurrentWhiteboardId(RtcWhiteboardImpl.this.getNativeHandle());
                RtcWhiteboardImpl.this.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), RtcWhiteboardImpl.this.mWhiteboardId);
                RtcWhiteboardImpl.this.WBUpdateViewSize(RtcWhiteboardImpl.this.getNativeHandle(), w, h);
                RtcWhiteboardImpl.this.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), wbId);
            }

            @Override
            public void onViewDestroyed() {
                String wbId = RtcWhiteboardImpl.this.WBGetCurrentWhiteboardId(RtcWhiteboardImpl.this.getNativeHandle());
                RtcWhiteboardImpl.this.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), RtcWhiteboardImpl.this.mWhiteboardId);
                RtcWhiteboardImpl.this.WBClose(RtcWhiteboardImpl.this.getNativeHandle());
                RtcWhiteboardImpl.this.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), wbId);
            }
        };
        view.addCallback(this.mViewCallback);
        this.mWbView = view;
        ViewParent parent = this.mWbView.getParent();
        if (parent instanceof PanoCoursePageView) {
            ((PanoCoursePageView)parent).setBackgroundColor(this.mBgColor);
            this.WBSetBackgroundColor(this.mNativeHandle, 0.0f, 0.0f, 0.0f, 0.0f);
            this.mWbView.setTransparent(true);
        }
        if (this.mEnableDrawer) {
            this.mWbDrawer.start(GlobalRef.applicationContext, view);
        }
        if (view.isViewReady()) {
            int ret = this.WBOpen(this.mNativeHandle, view.getHolder().getSurface());
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult close() {
        if (this.mEnableDrawer) {
            this.mWbDrawer.stop();
        }
        if (this.mWbView != null) {
            this.mWbView.removeCallback(this.mViewCallback);
            this.mViewCallback = null;
            this.mWbView = null;
        }
        if (this.mNativeHandle != 0L) {
            int ret = this.WBClose(this.mNativeHandle);
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult leave() {
        this.close();
        if (this.mNativeHandle != 0L) {
            int ret = this.WBLeave(this.mNativeHandle);
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult stop() {
        this.close();
        if (this.mNativeHandle != 0L) {
            int ret = this.WBStop(this.mNativeHandle);
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    long getNativeHandle() {
        return this.mNativeHandle;
    }

    void destroy() {
        this.close();
        this.mDocInfoMap.clear();
        this.mNativeHandle = 0L;
    }

    @Override
    public String getCurrentWhiteboardId() {
        return this.WBGetCurrentWhiteboardId(this.mNativeHandle);
    }

    @Override
    public Constants.QResult setCurrentScaleFactor(float scale) {
        int ret = this.WBSetCurrentScaleFactor(this.mNativeHandle, scale);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public int getCurrentPageNumber() {
        return this.WBGetCurrentPageNumber(this.mNativeHandle);
    }

    @Override
    public int getTotalNumberOfPages() {
        return this.WBGetTotalNumberOfPages(this.mNativeHandle);
    }

    @Override
    public float getCurrentScaleFactor() {
        return this.WBGetCurrentScaleFactor(this.mNativeHandle);
    }

    @Override
    public Constants.QResult setBackgroundImage(String imageUrl) {
        int ret = this.WBSetBackgroundImage(this.mNativeHandle, imageUrl, this.getCurrentPageNumber());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setBackgroundImage(String imageUrl, int pageNo) {
        int ret = this.WBSetBackgroundImage(this.mNativeHandle, imageUrl, pageNo);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setToolType(Constants.WBToolType type) {
        if (this.mWbView != null) {
            this.mWbView.setPassThrough(type == Constants.WBToolType.None);
        }
        int ret = this.WBSetToolType(this.mNativeHandle, type.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.WBToolType getToolType() {
        int type = this.WBGetToolType(this.mNativeHandle);
        return Constants.WBToolType.valueOf(type);
    }

    @Override
    public RtcWbView getAttachedRtcWbView() {
        return this.mWbView;
    }

    @Override
    public Constants.QResult setLineWidth(int size) {
        int ret = this.WBSetLineWidth(this.mNativeHandle, size);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFillType(Constants.WBFillType type) {
        int ret = this.WBSetFillType(this.mNativeHandle, type.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFillColor(int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >>> 24) / 255.0f;
        return this.setFillColor(r, g, b, a);
    }

    @Override
    public Constants.QResult setFillColor(float r, float g, float b, float a) {
        int ret = this.WBSetFillColor(this.mNativeHandle, r, g, b, a);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setForegroundColor(int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >>> 24) / 255.0f;
        return this.setForegroundColor(r, g, b, a);
    }

    @Override
    public Constants.QResult setForegroundColor(float r, float g, float b, float a) {
        int ret = this.WBSetForegroundColor(this.mNativeHandle, r, g, b, a);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setBackgroundColor(int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >>> 24) / 255.0f;
        return this.setBackgroundColor(r, g, b, a);
    }

    @Override
    public Constants.QResult setBackgroundColor(float r, float g, float b, float a) {
        ViewParent parent;
        int alpha = (int)(a * 255.0f) & 0xFF;
        int red = (int)(r * 255.0f) & 0xFF;
        int green = (int)(g * 255.0f) & 0xFF;
        int blue = (int)(b * 255.0f) & 0xFF;
        this.mBgColor = alpha << 24 | red << 16 | green << 8 | blue;
        if (this.mWbView != null && (parent = this.mWbView.getParent()) != null && parent instanceof PanoCoursePageView) {
            ((PanoCoursePageView)parent).setBackgroundColor(this.mBgColor);
            int ret = this.WBSetBackgroundColor(this.mNativeHandle, 0.0f, 0.0f, 0.0f, 0.0f);
            return Constants.QResult.valueOf(ret);
        }
        int ret = this.WBSetBackgroundColor(this.mNativeHandle, r, g, b, a);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setBackgroundImageScalingMode(Constants.WBImageScalingMode mode) {
        int ret = this.WBSetBackgroundImageScalingMode(this.mNativeHandle, mode.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFontStyle(Constants.WBFontStyle style) {
        int ret = this.WBSetFontStyle(this.mNativeHandle, style.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFontSize(int size) {
        int ret = this.WBSetFontSize(this.mNativeHandle, size);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult addStamp(WBStamp stamp) {
        int ret = this.WBAddStamp(this.mNativeHandle, stamp.stampId, stamp.path, stamp.resizable);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setStamp(String stampId) {
        int ret = this.WBSetStamp(this.mNativeHandle, stampId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult undo() {
        int ret = this.WBUndo(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult redo() {
        int ret = this.WBRedo(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult addPage(boolean autoSwitch) {
        int ret = this.WBAddPage(this.mNativeHandle, autoSwitch);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult insertPage(int pageNo, boolean autoSwitch) {
        int ret = this.WBInsertPage(this.mNativeHandle, pageNo, autoSwitch);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult removePage(int pageNo) {
        int ret = this.WBRemovePage(this.mNativeHandle, pageNo, false);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult removePage(int pageNo, boolean switchNext) {
        int ret = this.WBRemovePage(this.mNativeHandle, pageNo, switchNext);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult gotoPage(int pageNo) {
        int ret = this.WBGotoPage(this.mNativeHandle, pageNo);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult prevPage() {
        int ret = this.WBPrevPage(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult nextPage() {
        int ret = this.WBNextPage(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult prevStep() {
        int ret = this.WBPrevStep(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult nextStep() {
        int ret = this.WBNextStep(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult addImageFile(String imageUrl) {
        int ret = this.WBAddImage(this.mNativeHandle, imageUrl);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult addAudioFile(String mediaUrl) {
        int ret = this.WBAddAudio(this.mNativeHandle, mediaUrl);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult addVideoFile(String mediaUrl) {
        int ret = this.WBAddVideo(this.mNativeHandle, mediaUrl);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public String addBackgroundImages(List<String> urls) {
        return this.WBAddBackgroundImages(this.mNativeHandle, urls);
    }

    @Override
    public String addH5File(String url, String downloadUrl) {
        return this.WBAddH5File(this.mNativeHandle, url, downloadUrl);
    }

    @Override
    public String addDoc(WBDocContents contents) {
        WBDocContentsImpl jcontent = new WBDocContentsImpl();
        jcontent.setName(contents.name);
        jcontent.setUrls(contents.urls);
        return this.WBAddDoc(this.mNativeHandle, jcontent);
    }

    @Override
    public String createDoc(List<String> imageUrls) {
        return this.WBCreateDocWithImages(this.mNativeHandle, imageUrls);
    }

    @Override
    public String createDoc(String filePath) {
        return this.WBCreateDocWithFilePath(this.mNativeHandle, filePath);
    }

    @Override
    public String createDoc(String filePath, WBDocConvertConfig config) {
        WBDocConvertConfigImpl jConfig = new WBDocConvertConfigImpl();
        jConfig.setType(config.type.getValue());
        jConfig.setNeedThumb(config.needThumb);
        return this.WBCreateDocWithConfig(this.mNativeHandle, filePath, jConfig);
    }

    @Override
    public Constants.QResult deleteDoc(String fileId) {
        int ret = this.WBDeleteDoc(this.mNativeHandle, fileId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult switchDoc(String fileId) {
        int ret = this.WBSwitchDoc(this.mNativeHandle, fileId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult saveDocToImages(String fileId, String outputDir) {
        int ret = this.WBSaveDocToImages(this.mNativeHandle, fileId, outputDir);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public List<String> enumerateFiles() {
        String[] array = this.WBEnumFiles(this.mNativeHandle);
        if (null == array) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(array));
    }

    @Override
    public String getCurrentFileId() {
        return this.WBGetCurrentFileId(this.mNativeHandle);
    }

    @Override
    public WBDocInfo getFileInfo(String fileId) {
        if (null == this.mDocInfoMap.get(fileId)) {
            WBDocInfoImpl docInfo = new WBDocInfoImpl();
            this.WBGetFileInfo(this.mNativeHandle, fileId, docInfo);
            WBDocInfo info = new WBDocInfo();
            info.fileId = docInfo.getFileID();
            info.name = docInfo.getName();
            info.creator = docInfo.getCreator();
            info.type = docInfo.getType();
            this.mDocInfoMap.put(fileId, info);
        }
        return this.mDocInfoMap.get(fileId);
    }

    @Override
    public Constants.QResult clearContents(boolean curPage, Constants.WBClearType type) {
        int ret = this.WBClearContents(this.mNativeHandle, curPage, type.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult clearUserContents(long userId, boolean curPage, Constants.WBClearType type) {
        int ret = this.WBClearUserContents(this.mNativeHandle, userId, curPage, type.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult snapshot(Constants.WBSnapshotMode mode, String outputDir) {
        int ret = this.WBSnapshot(this.mNativeHandle, mode.getValue(), outputDir);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult startShareVision() {
        int ret = this.WBStartShareVision(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult initVision(WBVisionConfig config) {
        int ret = this.WBInitVision(this.mNativeHandle, config.width, config.height, config.limited);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult stopShareVision() {
        int ret = this.WBStopShareVision(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult startFollowVision() {
        int ret = this.WBStartFollowVision(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult stopFollowVision() {
        int ret = this.WBStopFollowVision(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult syncVision() {
        int ret = this.WBSyncVision(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult sendMessage(long userId, byte[] msg) {
        int ret = this.WBSendMessage(this.mNativeHandle, userId, msg);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult broadcastMessage(byte[] msg) {
        int ret = this.WBBroadcastMessage(this.mNativeHandle, msg);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFileCachePath(String path) {
        int ret = this.WBSetFileCachePath(this.mNativeHandle, path);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult enableUIResponse(boolean enable) {
        if (enable && !this.mEnableDrawer) {
            if (this.mWbView != null) {
                this.mWbDrawer.start(GlobalRef.applicationContext, this.mWbView);
            }
        } else if (!enable && this.mEnableDrawer && this.mWbView != null) {
            this.mWbDrawer.stop();
        }
        this.mEnableDrawer = enable;
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult enableShowDraws(boolean enable) {
        int ret = this.WBEnableShowDraws(this.mNativeHandle, enable);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult enableScaleMove(boolean enable) {
        int ret = this.WBEnableScaleMove(this.mNativeHandle, enable);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult enableAutoSelected(boolean enable) {
        int ret = this.WBEnableAutoSelected(this.mNativeHandle, enable);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public void onStatusSynced() {
        if (this.mWbCallback != null) {
            this.mWbCallback.onStatusSynced();
        }
    }

    @Override
    public void onPageNumberChanged(int curPage, int totalPages) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onPageNumberChanged(curPage, totalPages);
        }
    }

    @Override
    public void onImageStateChanged(String url, int state) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onImageStateChanged(url, this.ToWBImageState(state));
        }
    }

    @Override
    public void onViewScaleChanged(float scale) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onViewScaleChanged(scale);
        }
    }

    @Override
    public void onRoleTypeChanged(int newRole) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onRoleTypeChanged(this.ToWBRoleType(newRole));
        }
    }

    @Override
    public void onContentUpdated() {
        if (this.mWbCallback != null) {
            this.mWbCallback.onContentUpdated();
        }
    }

    @Override
    public void onSnapshotComplete(int result, String filename) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onSnapshotComplete(qr, filename);
        }
    }

    @Override
    public void onMessage(long userId, byte[] msg) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onMessage(userId, msg);
        }
    }

    @Override
    public void onAddBackgroundImages(int result, String fileId) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onAddBackgroundImages(qr, fileId);
        }
    }

    @Override
    public void onAddH5File(int result, String fileId) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onAddH5File(qr, fileId);
        }
    }

    @Override
    public void onDocTranscodeStatus(int result, String fileId, int progress, int totalPages) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onDocTranscodeStatus(qr, fileId, progress, totalPages);
        }
    }

    @Override
    public void onCreateDoc(int result, String fileId) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onCreateDoc(qr, fileId);
        }
    }

    @Override
    public void onDeleteDoc(int result, String fileId) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onDeleteDoc(qr, fileId);
        }
    }

    @Override
    public void onSwitchDoc(int result, String fileId) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onSwitchDoc(qr, fileId);
        }
    }

    @Override
    public void onSaveDoc(int result, String fileId, String outputDir) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onSaveDoc(qr, fileId, outputDir);
        }
    }

    @Override
    public void onDocThumbnailReady(String fileId, List<String> urls) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onDocThumbnailReady(fileId, urls);
        }
    }

    @Override
    public void onVisionShareStarted(long userId) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onVisionShareStarted(userId);
        }
    }

    @Override
    public void onVisionShareStopped(long userId) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onVisionShareStopped(userId);
        }
    }

    @Override
    public void onUserJoined(long userId, String userName) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onUserJoined(userId, userName);
        }
    }

    @Override
    public void onUserLeft(long userId) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onUserLeft(userId);
        }
    }

    private Constants.WBImageState ToWBImageState(int state) {
        Constants.WBImageState result = Constants.WBImageState.LoadFail;
        for (Constants.WBImageState val : Constants.WBImageState.values()) {
            if (val.getValue() != state) continue;
            result = val;
            break;
        }
        return result;
    }

    private Constants.WBRoleType ToWBRoleType(int type) {
        Constants.WBRoleType result = Constants.WBRoleType.Attendee;
        for (Constants.WBRoleType val : Constants.WBRoleType.values()) {
            if (val.getValue() != type) continue;
            result = val;
            break;
        }
        return result;
    }

    private native int WBSwitch(long var1, String var3);

    private native String WBGetCurrentWhiteboardId(long var1);

    private native int WBSetRoleType(long var1, int var3);

    private native int WBOpen(long var1, Surface var3);

    private native int WBUpdateViewSize(long var1, int var3, int var4);

    private native int WBClose(long var1);

    private native int WBLeave(long var1);

    private native int WBStop(long var1);

    private native int WBSetBackgroundImage(long var1, String var3, int var4);

    private native int WBSetBackgroundImageScalingMode(long var1, int var3);

    private native int WBSetToolType(long var1, int var3);

    private native int WBGetToolType(long var1);

    private native int WBSetLineWidth(long var1, int var3);

    private native int WBSetFillType(long var1, int var3);

    private native int WBSetFillColor(long var1, float var3, float var4, float var5, float var6);

    private native int WBSetForegroundColor(long var1, float var3, float var4, float var5, float var6);

    private native int WBSetBackgroundColor(long var1, float var3, float var4, float var5, float var6);

    private native int WBSetFontStyle(long var1, int var3);

    private native int WBSetFontSize(long var1, int var3);

    private native int WBAddStamp(long var1, String var3, String var4, boolean var5);

    private native int WBSetStamp(long var1, String var3);

    private native int WBUndo(long var1);

    private native int WBRedo(long var1);

    private native int WBAddPage(long var1, boolean var3);

    private native int WBInsertPage(long var1, int var3, boolean var4);

    private native int WBRemovePage(long var1, int var3, boolean var4);

    private native int WBGotoPage(long var1, int var3);

    private native int WBPrevPage(long var1);

    private native int WBNextPage(long var1);

    private native int WBPrevStep(long var1);

    private native int WBNextStep(long var1);

    private native int WBAddImage(long var1, String var3);

    private native int WBAddAudio(long var1, String var3);

    private native int WBAddVideo(long var1, String var3);

    private native String WBAddBackgroundImages(long var1, List<String> var3);

    private native String WBAddH5File(long var1, String var3, String var4);

    private native String WBAddDoc(long var1, WBDocContentsImpl var3);

    private native String WBCreateDocWithImages(long var1, List<String> var3);

    private native String WBCreateDocWithFilePath(long var1, String var3);

    private native String WBCreateDocWithConfig(long var1, String var3, WBDocConvertConfigImpl var4);

    private native int WBDeleteDoc(long var1, String var3);

    private native int WBSwitchDoc(long var1, String var3);

    private native int WBSaveDocToImages(long var1, String var3, String var4);

    private native String[] WBEnumFiles(long var1);

    private native String WBGetCurrentFileId(long var1);

    private native int WBGetFileInfo(long var1, String var3, WBDocInfoImpl var4);

    private native int WBClearContents(long var1, boolean var3, int var4);

    private native int WBClearUserContents(long var1, long var3, boolean var5, int var6);

    private native int WBSnapshot(long var1, int var3, String var4);

    private native int WBInitVision(long var1, int var3, int var4, boolean var5);

    private native int WBStartShareVision(long var1);

    private native int WBStopShareVision(long var1);

    private native int WBStartFollowVision(long var1);

    private native int WBStopFollowVision(long var1);

    private native int WBSyncVision(long var1);

    private native int WBSendStringMessage(long var1, long var3, String var5);

    private native int WBSendMessage(long var1, long var3, byte[] var5);

    private native int WBBroadcastStringMessage(long var1, String var3);

    private native int WBBroadcastMessage(long var1, byte[] var3);

    private native int WBSetFileCachePath(long var1, String var3);

    private native int WBEnableShowDraws(long var1, boolean var3);

    private native int WBEnableScaleMove(long var1, boolean var3);

    private native int WBEnableAutoSelected(long var1, boolean var3);

    private native int WBSetCallback(long var1, RtcWbCallbackImpl var3);

    private native int WBSetCurrentScaleFactor(long var1, float var3);

    private native int WBGetCurrentPageNumber(long var1);

    private native int WBGetTotalNumberOfPages(long var1);

    private native float WBGetCurrentScaleFactor(long var1);
}

