/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RtcNetworkManager;
import com.pano.rtc.impl.RtcNetworkMgrCallback;

public class RtcNetworkMgrImpl
implements RtcNetworkManager,
RtcNetworkMgrCallback {
    private static final String TAG = "[pano]";
    private final long mNativeHandle;
    private RtcNetworkManager.Callback mCallback;

    RtcNetworkMgrImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    @Override
    public Constants.QResult startNetworkTest(String token, RtcNetworkManager.Callback callback) {
        this.mCallback = callback;
        return Constants.QResult.valueOf(this.startNetworkTest(this.mNativeHandle, token, this));
    }

    @Override
    public Constants.QResult stopNetworkTest() {
        Constants.QResult ret = Constants.QResult.valueOf(this.stopNetworkTest(this.mNativeHandle));
        this.mCallback = null;
        return ret;
    }

    @Override
    public void onNetworkTestComplete(int quality, float txLoss, float rxLoss, int rtt) {
        if (this.mCallback != null) {
            RtcNetworkManager.NetworkQuality nq = new RtcNetworkManager.NetworkQuality();
            nq.rating = RtcNetworkMgrImpl.ToQualityRating(quality);
            nq.txLoss = txLoss;
            nq.rxLoss = rxLoss;
            nq.rtt = rtt;
            this.mCallback.onNetworkTestComplete(nq);
        }
    }

    static Constants.QualityRating ToQualityRating(int quality) {
        Constants.QualityRating result = Constants.QualityRating.Unavailable;
        for (Constants.QualityRating val : Constants.QualityRating.values()) {
            if (val.getValue() != quality) continue;
            result = val;
            break;
        }
        return result;
    }

    private native int startNetworkTest(long var1, String var3, RtcNetworkMgrCallback var4);

    private native int stopNetworkTest(long var1);
}

