/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import com.pano.coco.base.annotation.CalledByNative;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RtcMessageService;
import com.pano.rtc.api.model.RtcPropertyAction;
import com.pano.rtc.impl.RtcMessageCallbackImpl;

public class RtcMessageServiceImpl
implements RtcMessageService,
RtcMessageCallbackImpl {
    private long mNativeHandle;
    private RtcMessageService.Callback mCallback;

    RtcMessageServiceImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    void setNativeHandle(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    @Override
    public Constants.QResult setCallback(RtcMessageService.Callback callback) {
        this.mCallback = callback;
        int result = this.setCallback(this.mNativeHandle, callback != null ? this : null);
        return Constants.QResult.valueOf(result);
    }

    @Override
    public Constants.QResult setProperty(String name, byte[] value) {
        return Constants.QResult.valueOf(this.setProperty(this.mNativeHandle, name, value));
    }

    @Override
    public Constants.QResult sendMessage(long userId, byte[] data) {
        return Constants.QResult.valueOf(this.sendMessage(this.mNativeHandle, userId, data));
    }

    @Override
    public Constants.QResult broadcastMessage(byte[] data, boolean sendBack) {
        return Constants.QResult.valueOf(this.broadcastMessage(this.mNativeHandle, data, sendBack));
    }

    @Override
    public Constants.QResult publish(String topic, byte[] data) {
        return Constants.QResult.valueOf(this.publish(this.mNativeHandle, topic, data));
    }

    @Override
    public Constants.QResult subscribe(String topic) {
        return Constants.QResult.valueOf(this.subscribe(this.mNativeHandle, topic));
    }

    @Override
    public Constants.QResult unsubscribe(String topic) {
        return Constants.QResult.valueOf(this.unsubscribe(this.mNativeHandle, topic));
    }

    @Override
    @CalledByNative
    public void onServiceStateChanged(int state, int reason) {
        if (this.mCallback != null) {
            this.mCallback.onServiceStateChanged(Constants.MessageServiceState.values()[state], Constants.QResult.valueOf(reason));
        }
    }

    @Override
    @CalledByNative
    public void onUserMessage(long userId, byte[] data) {
        if (this.mCallback != null) {
            this.mCallback.onUserMessage(userId, data);
        }
    }

    @Override
    public void onSubscribeResult(String topic, int result) {
        if (this.mCallback != null) {
            this.mCallback.onSubscribeResult(topic, Constants.QResult.valueOf(result));
        }
    }

    @Override
    public void onTopicMessage(String topic, long userId, byte[] data) {
        if (this.mCallback != null) {
            this.mCallback.onTopicMessage(topic, userId, data);
        }
    }

    @Override
    public void onPropertyChanged(RtcPropertyAction[] props) {
        if (this.mCallback != null) {
            this.mCallback.onPropertyChanged(props);
        }
    }

    private native int setCallback(long var1, RtcMessageCallbackImpl var3);

    private native int setProperty(long var1, String var3, byte[] var4);

    private native int sendMessage(long var1, long var3, byte[] var5);

    private native int broadcastMessage(long var1, byte[] var3, boolean var4);

    private native int publish(long var1, String var3, byte[] var4);

    private native int subscribe(long var1, String var3);

    private native int unsubscribe(long var1, String var3);
}

