/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import com.pano.coco.base.annotation.CalledByNative;
import com.pano.coco.base.annotation.Keep;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RtcMediaStatsObserver;
import com.pano.rtc.api.model.stats.RtcAudioRecvStats;
import com.pano.rtc.api.model.stats.RtcAudioSendStats;
import com.pano.rtc.api.model.stats.RtcSystemStats;
import com.pano.rtc.api.model.stats.RtcVideoBweStats;
import com.pano.rtc.api.model.stats.RtcVideoRecvStats;
import com.pano.rtc.api.model.stats.RtcVideoSendStats;
import com.pano.rtc.impl.RtcJsonStatsObserver;
import org.json.JSONException;
import org.json.JSONObject;
import video.pano.rtc.impl.PLogger;

public class RtcMediaStatsHandler
implements RtcJsonStatsObserver {
    private static final String TAG = "[pano]";
    private RtcMediaStatsObserver mStatsObserver;

    void setMediaStatsObserver(RtcMediaStatsObserver observer) {
        this.mStatsObserver = observer;
    }

    RtcMediaStatsHandler() {
    }

    public void stop() {
    }

    public Constants.VideoCodecType toVideoCodecType(int codec) {
        switch (codec) {
            case 0: {
                return Constants.VideoCodecType.Unknown;
            }
            case 1: {
                return Constants.VideoCodecType.H264;
            }
            case 2: {
                return Constants.VideoCodecType.AV1;
            }
        }
        return Constants.VideoCodecType.Unknown;
    }

    public Constants.AudioCodecType toAudioCodecType(int codec) {
        switch (codec) {
            case 0: {
                return Constants.AudioCodecType.Unknown;
            }
            case 1: {
                return Constants.AudioCodecType.G711;
            }
            case 2: {
                return Constants.AudioCodecType.G722;
            }
            case 3: {
                return Constants.AudioCodecType.ILBC;
            }
            case 4: {
                return Constants.AudioCodecType.ISAC;
            }
            case 5: {
                return Constants.AudioCodecType.OPUS;
            }
        }
        return Constants.AudioCodecType.Unknown;
    }

    @Override
    @Keep
    @CalledByNative
    public void onJsonStatsReport(String jsonStats) {
        try {
            JSONObject json = new JSONObject(jsonStats);
            this.processJsonStats(json);
        }
        catch (JSONException e) {
            PLogger.e(TAG, "onJsonStatsReport, JSON error: " + e.getMessage());
        }
    }

    private void processJsonStats(JSONObject json) {
        if (this.mStatsObserver == null) {
            return;
        }
        try {
            String metrics;
            switch (metrics = json.getString("metrics")) {
                case "vtx": {
                    RtcVideoSendStats stats = new RtcVideoSendStats();
                    stats.streamId = json.getInt("streamId");
                    stats.bytesSent = json.getLong("bytes");
                    stats.bitrate = json.getLong("br");
                    stats.packetsLost = json.getLong("losscnt");
                    stats.lossRatio = (float)json.getDouble("loss");
                    stats.rtt = json.getInt("rtt");
                    stats.plisReceived = json.getInt("pli");
                    stats.width = json.getInt("w");
                    stats.height = json.getInt("h");
                    stats.framerate = json.getInt("fps");
                    stats.codecType = this.toVideoCodecType(json.getInt("codec"));
                    this.mStatsObserver.onVideoSendStats(stats);
                    break;
                }
                case "vrx": {
                    RtcVideoRecvStats stats = new RtcVideoRecvStats();
                    stats.userId = Long.parseLong(json.getString("userId"));
                    stats.streamId = json.getInt("streamId");
                    stats.bytesReceived = json.getLong("bytes");
                    stats.bitrate = json.getLong("br");
                    stats.packetsLost = json.getLong("losscnt");
                    stats.lossRatio = (float)json.getDouble("loss");
                    stats.plisSent = json.getInt("pli");
                    stats.width = json.getInt("w");
                    stats.height = json.getInt("h");
                    stats.framerate = json.getInt("fps");
                    stats.codecType = this.toVideoCodecType(json.getInt("codec"));
                    this.mStatsObserver.onVideoRecvStats(stats);
                    break;
                }
                case "atx": {
                    RtcAudioSendStats stats = new RtcAudioSendStats();
                    stats.bytesSent = json.getLong("bytes");
                    stats.bitrate = json.getLong("br");
                    stats.packetsLost = json.getLong("losscnt");
                    stats.lossRatio = (float)json.getDouble("loss");
                    stats.rtt = json.getInt("rtt");
                    stats.inputLevel = (short)json.getInt("level");
                    stats.inputActiveFlag = json.getBoolean("active");
                    stats.codecType = this.toAudioCodecType(json.getInt("codec"));
                    this.mStatsObserver.onAudioSendStats(stats);
                    break;
                }
                case "arx": {
                    RtcAudioRecvStats stats = new RtcAudioRecvStats();
                    stats.userId = Long.parseLong(json.getString("userId"));
                    stats.bytesReceived = json.getLong("bytes");
                    stats.bitrate = json.getLong("br");
                    stats.packetsLost = json.getLong("losscnt");
                    stats.lossRatio = (float)json.getDouble("loss");
                    stats.outputLevel = (short)json.getInt("level");
                    stats.stutterScore = (short)json.getInt("stutter");
                    stats.codecType = this.toAudioCodecType(json.getInt("codec"));
                    this.mStatsObserver.onAudioRecvStats(stats);
                    break;
                }
                case "stx": {
                    RtcVideoSendStats stats = new RtcVideoSendStats();
                    stats.bytesSent = json.getLong("bytes");
                    stats.bitrate = json.getLong("br");
                    stats.packetsLost = json.getLong("losscnt");
                    stats.lossRatio = (float)json.getDouble("loss");
                    stats.rtt = json.getInt("rtt");
                    stats.plisReceived = json.getInt("pli");
                    stats.width = json.getInt("w");
                    stats.height = json.getInt("h");
                    stats.framerate = json.getInt("fps");
                    stats.codecType = this.toVideoCodecType(json.getInt("codec"));
                    this.mStatsObserver.onScreenSendStats(stats);
                    break;
                }
                case "srx": {
                    RtcVideoRecvStats stats = new RtcVideoRecvStats();
                    stats.userId = Long.parseLong(json.getString("userId"));
                    stats.bytesReceived = json.getLong("bytes");
                    stats.bitrate = json.getLong("br");
                    stats.packetsLost = json.getLong("losscnt");
                    stats.lossRatio = (float)json.getDouble("loss");
                    stats.plisSent = json.getInt("pli");
                    stats.width = json.getInt("w");
                    stats.height = json.getInt("h");
                    stats.framerate = json.getInt("fps");
                    stats.codecType = this.toVideoCodecType(json.getInt("codec"));
                    this.mStatsObserver.onScreenRecvStats(stats);
                    break;
                }
                case "vbwe": {
                    RtcVideoBweStats stats = new RtcVideoBweStats();
                    stats.bandwidth = json.getLong("bw");
                    stats.encodeBitrate = json.getLong("encbr");
                    stats.transmitBitrate = json.getLong("txbr");
                    stats.retransmitBitrate = json.getLong("rtxbr");
                    this.mStatsObserver.onVideoBweStats(stats);
                    break;
                }
                case "sys": {
                    RtcSystemStats stats = new RtcSystemStats();
                    stats.totalCpuUsage = json.getInt("cpu");
                    stats.memoryUsage = json.getInt("mem");
                    stats.totalPhysMemory = json.getLong("phys");
                    stats.workingSetSize = json.getLong("wset");
                    this.mStatsObserver.onSystemStats(stats);
                    break;
                }
            }
        }
        catch (JSONException e) {
            PLogger.e(TAG, "processJsonStats, JSON error: " + e.getMessage());
        }
    }
}

