/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.util.Log;
import com.pano.coco.impl.CocoNativeCapturerObserver;
import com.pano.coco.impl.GlobalRef;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.IVideoRender;
import com.pano.rtc.api.PanoAnnotationManager;
import com.pano.rtc.api.RtcAudioDeviceManager;
import com.pano.rtc.api.RtcAudioExProcessor;
import com.pano.rtc.api.RtcAudioIndication;
import com.pano.rtc.api.RtcAudioMixingMgr;
import com.pano.rtc.api.RtcChannelConfig;
import com.pano.rtc.api.RtcEngine;
import com.pano.rtc.api.RtcEngineCallback;
import com.pano.rtc.api.RtcEngineConfig;
import com.pano.rtc.api.RtcExternalAudioPlayer;
import com.pano.rtc.api.RtcExternalAudioRecorder;
import com.pano.rtc.api.RtcMediaStatsObserver;
import com.pano.rtc.api.RtcMessageService;
import com.pano.rtc.api.RtcNetworkManager;
import com.pano.rtc.api.RtcSnapshotVideoOption;
import com.pano.rtc.api.RtcVideoConfig;
import com.pano.rtc.api.RtcVideoDeviceManager;
import com.pano.rtc.api.RtcVideoStreamManager;
import com.pano.rtc.api.RtcVideoTextureFilter;
import com.pano.rtc.api.RtcVideoTextureFilterConfig;
import com.pano.rtc.api.RtcView;
import com.pano.rtc.api.RtcWhiteboard;
import com.pano.rtc.api.model.BuiltinTransformParams;
import com.pano.rtc.api.model.QuadTransformParams;
import com.pano.rtc.api.model.RtcAudioLevel;
import com.pano.rtc.api.model.RtcAudioProfile;
import com.pano.rtc.api.model.VideoBrightnessParams;
import com.pano.rtc.impl.DocshowSettings;
import com.pano.rtc.impl.ExternalAudioPlayerImpl;
import com.pano.rtc.impl.ExternalAudioRecorderImpl;
import com.pano.rtc.impl.PanoAnnotationMgrImpl;
import com.pano.rtc.impl.PanoCoursePageFactory;
import com.pano.rtc.impl.ProxyVideoRender;
import com.pano.rtc.impl.RtcAndroidConfig;
import com.pano.rtc.impl.RtcAudioDeviceMgrImpl;
import com.pano.rtc.impl.RtcAudioMixingMgrImpl;
import com.pano.rtc.impl.RtcChannelConfigImpl;
import com.pano.rtc.impl.RtcEngineCallbackImpl;
import com.pano.rtc.impl.RtcEngineConfigImpl;
import com.pano.rtc.impl.RtcJsonStatsObserver;
import com.pano.rtc.impl.RtcMediaStatsHandler;
import com.pano.rtc.impl.RtcMessageServiceImpl;
import com.pano.rtc.impl.RtcNetworkMgrImpl;
import com.pano.rtc.impl.RtcVideoDeviceMgrImpl;
import com.pano.rtc.impl.RtcVideoStreamMgrImpl;
import com.pano.rtc.impl.RtcWhiteboardImpl;
import com.pano.rtc.video.CocoCaptureFrameObserver;
import com.pano.rtc.video.VideoHwHelper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import video.pano.DefaultVideoDecoderFactory;
import video.pano.DefaultVideoEncoderFactory;
import video.pano.EglBase;
import video.pano.VideoDecoderFactory;
import video.pano.VideoEncoderFactory;
import video.pano.VideoSink;
import video.pano.rtc.audio.AudioDeviceManager;
import video.pano.rtc.base.thread.ThreadUtils;
import video.pano.rtc.base.util.DeviceUuid;
import video.pano.rtc.base.util.NetworkChangeObserver;
import video.pano.rtc.base.util.NetworkChangeReceiver;
import video.pano.rtc.base.util.NetworkUtils;
import video.pano.rtc.base.util.SystemUtils;
import video.pano.rtc.impl.EglSharedContextHelper;
import video.pano.rtc.impl.GestureHandler;
import video.pano.rtc.impl.PLogger;
import video.pano.rtc.impl.screen.PanoScreenCaptureAssistantActivity;
import video.pano.rtc.impl.screen.ScreenPermissionCallback;

public class RtcEngineImpl
extends RtcEngine
implements RtcEngineCallbackImpl,
AudioDeviceManager.AudioManagerEvents,
NetworkChangeObserver,
RtcAudioIndication,
ScreenPermissionCallback {
    private static final String TAG = "[pano]";
    private static final String kPanoServer = "api.pano.video";
    private RtcEngineCallback mCallback;
    private long mNativeHandle;
    private static boolean sNativeInited = false;
    private final RtcMediaStatsHandler mStatsHandler = new RtcMediaStatsHandler();
    private final RtcChannelConfigImpl mChannelConfig = new RtcChannelConfigImpl();
    private boolean mChannelJoined = false;
    private String mCachePath = "";
    private RtcWhiteboardImpl mWhiteboard;
    private Map<String, RtcWhiteboardImpl> mWhiteboardMap;
    private PanoAnnotationMgrImpl mAnnotationMgr;
    private RtcAudioMixingMgrImpl mAudioMixingMgr;
    private RtcNetworkMgrImpl mNetworkMgr;
    private ExternalAudioRecorderImpl mExAudioRecorder;
    private ExternalAudioPlayerImpl mExAudioPlayer;
    private RtcAudioDeviceMgrImpl mAudioDeviceMgr;
    private RtcVideoStreamMgrImpl mVideoStreamMgr;
    private RtcVideoDeviceMgrImpl mVideoDeviceMgr;
    private RtcMessageServiceImpl mRtcMessageService;
    private RtcAudioIndication mAudioIndicator;
    private Constants.AudioAecType mUserAudioAecType = Constants.AudioAecType.Default;
    private int mAudioScenario = 0;
    private boolean mUserVideoHwEncoderFlag = false;
    private boolean mUserVideoHwDecoderFlag = false;
    private NetworkChangeReceiver mNetworkChangeReceiver;
    private long mLocalUserId = 0L;
    private long mRemoteScreenUserId = 0L;
    private ProxyVideoRender mRemoteScreenRender;
    private final DocshowSettings mDocshow;
    private CocoCaptureFrameObserver mCaptureFrameObserver;
    private boolean mLocalFrontCamera = true;
    private String mSdkVersion = "";
    private boolean mDoFaceBeauty = false;
    private boolean mDoBuiltinTransform = false;
    private boolean mDoExtBrightness = false;
    private final WifiManager.WifiLock mWifiLock;
    private boolean mUseBuiltinTrans = false;
    private boolean mUseQuadTrans = false;
    private IVideoRender.ScalingRatio mPredefinedRatio = IVideoRender.ScalingRatio.SCALE_RATIO_FIT;

    public RtcEngineImpl(RtcEngineConfig config) throws Exception {
        Context appContext = config.context.getApplicationContext();
        this.mNativeHandle = 0L;
        PLogger.initLogger(appContext);
        this.mSdkVersion = this.nativeGetSdkVersion();
        SystemUtils.checkSelfPermission(appContext);
        GlobalRef.init(appContext);
        video.pano.rtc.impl.GlobalRef.init(appContext);
        this.mDocshow = new DocshowSettings(appContext);
        this.mUserAudioAecType = config.audioAecType;
        this.mAudioScenario = config.audioScenario;
        this.mUserVideoHwEncoderFlag = config.videoCodecHwAcceleration;
        this.mUserVideoHwDecoderFlag = config.videoCodecHwAcceleration;
        this.setupDefaultCachePath(appContext);
        RtcAndroidConfig cfg = this.getRtcAndroidConfig();
        this.doInitialize(appContext, cfg);
        WifiManager wm = (WifiManager)appContext.getSystemService("wifi");
        this.mWifiLock = wm.createWifiLock(3, "PanoRtcWifiLock");
        RtcEngineImpl.setAndroidInfo(Build.VERSION.RELEASE, Build.MODEL, Build.MANUFACTURER, Build.BOARD);
    }

    private void doInitialize(Context ctx, RtcAndroidConfig cfg) {
        this.mNativeHandle = this.createRtcEngine(ctx, cfg);
        this.setMediaStatsObserver(this.mNativeHandle, this.mStatsHandler);
        PanoCoursePageFactory.setNativeHandle(this.mNativeHandle);
        this.mWhiteboardMap = new HashMap<String, RtcWhiteboardImpl>();
        if (RtcEngineImpl.nativeWhiteboardSupported()) {
            this.mWhiteboard = new RtcWhiteboardImpl(this.mNativeHandle, "default");
            this.setupWhiteboard(this.mWhiteboard);
            this.mWhiteboardMap.put("default", this.mWhiteboard);
            this.mAnnotationMgr = new PanoAnnotationMgrImpl(this.mNativeHandle);
        }
        this.mAudioMixingMgr = new RtcAudioMixingMgrImpl(this.mNativeHandle);
        this.mNetworkMgr = new RtcNetworkMgrImpl(this.mNativeHandle);
        this.mExAudioRecorder = new ExternalAudioRecorderImpl(this.mNativeHandle);
        this.mExAudioPlayer = new ExternalAudioPlayerImpl(this.mNativeHandle);
        this.mAudioDeviceMgr = new RtcAudioDeviceMgrImpl(this.mNativeHandle);
        this.mVideoStreamMgr = new RtcVideoStreamMgrImpl(this.mNativeHandle);
        this.mVideoDeviceMgr = new RtcVideoDeviceMgrImpl(this.mNativeHandle);
        this.mRtcMessageService = new RtcMessageServiceImpl(this.mNativeHandle);
        this.setupNetworkChangeReceiver(ctx);
        this.mCaptureFrameObserver = new CocoCaptureFrameObserver(cfg.getEglSharedContext());
        this.mVideoStreamMgr.setEglSharedContext(cfg.getEglSharedContext());
        this.setDefaultVideoCapturerFilter(this.mCaptureFrameObserver);
    }

    public void doDestroy() {
        this.setDefaultVideoCapturerFilter(null);
        this.setMediaStatsObserver(this.mNativeHandle, null);
        if (this.mCaptureFrameObserver != null) {
            this.mCaptureFrameObserver.release();
            this.mCaptureFrameObserver = null;
        }
        for (RtcWhiteboardImpl whiteboard : this.mWhiteboardMap.values()) {
            whiteboard.destroy();
        }
        this.mWhiteboardMap.clear();
        this.destroyRtcEngine(this.mNativeHandle);
        PanoCoursePageFactory.setNativeHandle(0L);
        this.mNativeHandle = 0L;
        this.mVideoStreamMgr.removeAllLocalProxyRenders();
        this.mVideoStreamMgr.removeAllRemoteProxyRenders();
        this.mAudioDeviceMgr.releaseDeviceManager();
        this.mWhiteboard = null;
        this.mAudioMixingMgr = null;
        this.mNetworkMgr = null;
        this.mExAudioRecorder = null;
        this.mExAudioPlayer = null;
        this.mAudioDeviceMgr = null;
        this.mVideoStreamMgr = null;
        this.mVideoDeviceMgr = null;
        this.mRtcMessageService = null;
        if (this.mNetworkChangeReceiver != null) {
            video.pano.rtc.impl.GlobalRef.applicationContext.unregisterReceiver((BroadcastReceiver)this.mNetworkChangeReceiver);
        }
        if (this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
        }
        this.mStatsHandler.stop();
    }

    private void setupNetworkChangeReceiver(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        intentFilter.setPriority(100);
        this.mNetworkChangeReceiver = new NetworkChangeReceiver(context);
        this.mNetworkChangeReceiver.setNetworkChangeObserver(this);
        context.registerReceiver((BroadcastReceiver)this.mNetworkChangeReceiver, intentFilter);
    }

    private void setupDefaultCachePath(Context context) {
        File extPath = context.getExternalCacheDir();
        if (extPath == null || -1 == context.getPackageManager().checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", context.getPackageName())) {
            extPath = context.getCacheDir();
        }
        this.mCachePath = extPath.getAbsolutePath();
        if (this.mCachePath != null) {
            this.mCachePath = this.mCachePath + "/mango";
            File folder = new File(this.mCachePath);
            boolean success = true;
            if (!folder.exists()) {
                success = folder.mkdir();
            }
            if (!success) {
                PLogger.nw(TAG, "RtcEngine.setupDefaultCachePath mkdir failed");
                this.mCachePath = null;
            }
        } else {
            PLogger.nw(TAG, "RtcEngine.setupDefaultCachePath get path failed");
        }
    }

    private void setupWhiteboard(RtcWhiteboardImpl whiteboard) {
        if (this.mCachePath != null) {
            whiteboard.setFileCachePath(this.mCachePath);
        } else {
            PLogger.nw(TAG, "RtcEngine.setupWhiteboard cache path is null");
        }
    }

    @Override
    public Constants.QResult setParameters(String params) {
        return Constants.QResult.valueOf(this.setParameters(this.mNativeHandle, params));
    }

    @Override
    public Constants.QResult setLocalVideoRender(IVideoRender render) {
        return this.mVideoStreamMgr.setLocalVideoRender(0, render);
    }

    @Override
    public Constants.QResult setRemoteVideoRender(long userId, IVideoRender render) {
        return this.mVideoStreamMgr.setRemoteVideoRender(userId, 0, render);
    }

    @Override
    public Constants.QResult setRemoteScreenRender(long userId, IVideoRender render) {
        PLogger.i(TAG, "RtcEngine.setRemoteScreenRender, userId=" + userId + ", render=" + render);
        if (this.mRemoteScreenRender == null) {
            this.mRemoteScreenRender = this.mVideoStreamMgr.createProxyRender();
        } else {
            VideoSink sink = this.mRemoteScreenRender.getTarget();
            if (sink instanceof RtcView) {
                ((RtcView)sink).setRtcTouchListener(null);
            }
        }
        if (render != null) {
            render.setScalingType(IVideoRender.ScalingType.SCALE_ASPECT_ADJUST);
        }
        this.mRemoteScreenRender.setTarget(render);
        this.mRemoteScreenRender.setScalingType(IVideoRender.ScalingType.SCALE_ASPECT_ADJUST);
        this.mRemoteScreenUserId = userId;
        return Constants.QResult.OK;
    }

    public Constants.QResult initialize(RtcEngineConfig config) {
        if (config.audioScenario != this.mAudioScenario || config.audioAecType != this.mUserAudioAecType || config.videoCodecHwAcceleration != this.mUserVideoHwEncoderFlag || config.videoCodecHwAcceleration != this.mUserVideoHwDecoderFlag) {
            this.destroyRtcEngine(this.mNativeHandle);
            this.mUserAudioAecType = config.audioAecType;
            this.mAudioScenario = config.audioScenario;
            this.mUserVideoHwEncoderFlag = config.videoCodecHwAcceleration;
            this.mUserVideoHwDecoderFlag = config.videoCodecHwAcceleration;
            Context appContext = config.context.getApplicationContext();
            RtcAndroidConfig cfg = this.getRtcAndroidConfig();
            this.doInitialize(appContext, cfg);
        }
        NetworkUtils.NetworkType type = NetworkUtils.getConnectivityStatus(video.pano.rtc.impl.GlobalRef.applicationContext);
        RtcEngineImpl.updateNetworkType(type.getValue());
        String panoServer = !config.server.isEmpty() ? config.server : kPanoServer;
        RtcEngineConfigImpl cfg = new RtcEngineConfigImpl();
        cfg.setAppId(config.appId);
        cfg.setServerURI(panoServer);
        cfg.setVideoHWEncode(this.mUserVideoHwEncoderFlag);
        cfg.setVideoHWDecode(this.mUserVideoHwDecoderFlag);
        cfg.setAudioAecType(this.toRTCAudioAecType(this.mUserAudioAecType).getValue());
        cfg.setAudioScenario(config.audioScenario);
        this.mCallback = config.callback;
        int ret = this.initRtcEngine(this.mNativeHandle, cfg, this);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult joinChannel(String token, String channelId, long userId, RtcChannelConfig config) {
        PLogger.initLogger(video.pano.rtc.impl.GlobalRef.applicationContext);
        if (token == null || token.isEmpty() || channelId == null || channelId.isEmpty()) {
            PLogger.e(TAG, "RtcEngine.joinChannel, token/channelId is empty");
            return Constants.QResult.InvalidArgs;
        }
        channelId = channelId.trim();
        if (config.userName != null && (config.userName.contains("/") || config.userName.contains("\\"))) {
            PLogger.e(TAG, "RtcEngine.joinChannel, invalid userName: " + config.userName);
            return Constants.QResult.InvalidArgs;
        }
        if (this.mChannelJoined) {
            PLogger.e(TAG, "RtcEngine.joinChannel, InvalidState, channelId: " + channelId);
            return Constants.QResult.InvalidState;
        }
        PLogger.i(TAG, "joinChannel, manu=" + Build.MANUFACTURER + ", model=" + Build.MODEL + ", product=" + Build.PRODUCT + ", board=" + Build.BOARD + ", sdkver=" + Build.VERSION.SDK_INT + ", relver=" + Build.VERSION.RELEASE);
        this.mLocalUserId = userId;
        this.mChannelConfig.setToken(token);
        this.mChannelConfig.setUserName(config.userName);
        this.mChannelConfig.setMode_1v1(config.mode_1v1);
        this.mChannelConfig.setServiceFlags(config.serviceFlags);
        this.mChannelConfig.setSubscribeAudioAll(config.subscribeAudioAll);
        NetworkUtils.NetworkType type = NetworkUtils.getConnectivityStatus(video.pano.rtc.impl.GlobalRef.applicationContext);
        RtcEngineImpl.updateNetworkType(type.getValue());
        return this.doJoinChannel(channelId, userId);
    }

    @Override
    public Constants.QResult leaveChannel() {
        for (RtcWhiteboardImpl whiteboard : this.mWhiteboardMap.values()) {
            whiteboard.close();
        }
        int ret = this.leaveChannel(this.mNativeHandle);
        this.mUseQuadTrans = false;
        this.mUseBuiltinTrans = false;
        if (this.mVideoStreamMgr != null) {
            this.mVideoStreamMgr.clearForLeave();
        }
        if (this.mAudioDeviceMgr != null) {
            this.mAudioDeviceMgr.stop();
        }
        this.mChannelJoined = false;
        if (this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
        }
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult startAudio() {
        return Constants.QResult.valueOf(this.startAudio(this.mNativeHandle));
    }

    @Override
    public Constants.QResult stopAudio() {
        return Constants.QResult.valueOf(this.stopAudio(this.mNativeHandle));
    }

    @Override
    public Constants.QResult startVideo(Constants.VideoProfileType profileType, boolean frontCamera) {
        this.mLocalFrontCamera = frontCamera;
        ProxyVideoRender render = this.mVideoStreamMgr.getLocalProxyRender(0);
        if (render != null) {
            int ret;
            if (!ThreadUtils.runningOnUiThread()) {
                PLogger.w(TAG, "RtcEngine.startVideo, not on main thread");
            }
            if ((ret = this.startVideo(this.mNativeHandle, render, profileType.getValue(), frontCamera)) == Constants.QResult.OK.getValue()) {
                RtcVideoStreamMgrImpl.StreamInfo stream = this.mVideoStreamMgr.getStream(0);
                if (stream != null) {
                    stream.cameraId = this.getCameraId(frontCamera);
                    this.mVideoStreamMgr.onLocalVideoStreamStarted(stream.streamId, profileType);
                }
                this.setDefaultVideoCapturerFilter(this.mCaptureFrameObserver);
            }
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.InvalidState;
    }

    @Override
    public Constants.QResult startScreen() {
        PanoScreenCaptureAssistantActivity.mScreenPermissionCallback = this;
        Intent intent = new Intent(video.pano.rtc.impl.GlobalRef.applicationContext, PanoScreenCaptureAssistantActivity.class);
        intent.addFlags(0x10000000);
        try {
            video.pano.rtc.impl.GlobalRef.applicationContext.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            return Constants.QResult.Fatal;
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult stopScreen() {
        return Constants.QResult.valueOf(this.stopScreen(this.mNativeHandle));
    }

    @Override
    public Constants.QResult startVideo(boolean frontCamera, RtcVideoConfig config) {
        ProxyVideoRender render = this.mVideoStreamMgr.getLocalProxyRender(0);
        render.setDeviceMirror(config.sourceMirror);
        return this.startVideo(config.profileType, frontCamera);
    }

    @Override
    public Constants.QResult stopVideo() {
        Constants.QResult ret = Constants.QResult.valueOf(this.stopVideo(this.mNativeHandle));
        this.mVideoStreamMgr.removeLocalProxyRender(0);
        this.mVideoStreamMgr.onLocalVideoStreamStopped(0);
        return ret;
    }

    @Override
    public Constants.QResult startPreview(Constants.VideoProfileType profileType, boolean frontCamera) {
        ProxyVideoRender render = this.mVideoStreamMgr.getLocalProxyRender(0);
        if (render != null) {
            Constants.QResult ret;
            if (!ThreadUtils.runningOnUiThread()) {
                PLogger.w(TAG, "RtcEngine.startPreview, not on main thread");
            }
            if ((ret = Constants.QResult.valueOf(this.startPreview(this.mNativeHandle, render, profileType.getValue(), frontCamera))) == Constants.QResult.OK) {
                this.setDefaultVideoCapturerFilter(this.mCaptureFrameObserver);
            }
            return ret;
        }
        return Constants.QResult.InvalidState;
    }

    @Override
    public Constants.QResult switchCamera() {
        this.mLocalFrontCamera = !this.mLocalFrontCamera;
        Constants.QResult ret = Constants.QResult.valueOf(this.switchCamera(this.mNativeHandle));
        PLogger.i(TAG, "RtcEngine.switchCamera, front=" + this.mLocalFrontCamera + ", ret=" + (Object)((Object)ret));
        RtcVideoStreamMgrImpl.StreamInfo stream = this.mVideoStreamMgr.getStream(0);
        if (stream != null) {
            stream.cameraId = this.getCameraId(this.mLocalFrontCamera);
        }
        this.setDefaultVideoCapturerFilter(this.mCaptureFrameObserver);
        return ret;
    }

    @Override
    public Constants.QResult stopPreview() {
        Constants.QResult ret = Constants.QResult.valueOf(this.stopPreview(this.mNativeHandle));
        RtcVideoStreamMgrImpl.StreamInfo stream = this.mVideoStreamMgr.getStream(0);
        if (stream != null && !stream.started) {
            this.mVideoStreamMgr.removeLocalProxyRender(0);
        }
        return ret;
    }

    @Override
    public Constants.QResult subscribeAudio(long userId) {
        return Constants.QResult.valueOf(this.subscribeAudio(this.mNativeHandle, userId));
    }

    @Override
    public Constants.QResult unsubscribeAudio(long userId) {
        return Constants.QResult.valueOf(this.unsubscribeAudio(this.mNativeHandle, userId));
    }

    @Override
    public Constants.QResult subscribeVideo(long userId, Constants.VideoProfileType profileType) {
        if (!ThreadUtils.runningOnUiThread()) {
            PLogger.w(TAG, "RtcEngine.subscribeVideo, not on main thread, userId=" + userId);
        }
        ProxyVideoRender proxyVideoRender = this.mVideoStreamMgr.getRemoteProxyRender(userId, 0);
        return Constants.QResult.valueOf(this.subscribeVideo(this.mNativeHandle, userId, proxyVideoRender, profileType.getValue()));
    }

    @Override
    public Constants.QResult unsubscribeVideo(long userId) {
        Constants.QResult ret = Constants.QResult.valueOf(this.unsubscribeVideo(this.mNativeHandle, userId));
        this.mVideoStreamMgr.removeRemoteProxyRender(userId, 0);
        return ret;
    }

    @Override
    public Constants.QResult muteAudio() {
        return Constants.QResult.valueOf(this.muteAudio(this.mNativeHandle));
    }

    @Override
    public Constants.QResult unmuteAudio() {
        return Constants.QResult.valueOf(this.unmuteAudio(this.mNativeHandle));
    }

    @Override
    public Constants.QResult muteVideo() {
        Constants.QResult ret = Constants.QResult.valueOf(this.muteVideo(this.mNativeHandle));
        if (ret == Constants.QResult.OK) {
            this.mVideoStreamMgr.onLocalVideoStreamMuteState(0, true);
        }
        return ret;
    }

    @Override
    public Constants.QResult unmuteVideo() {
        Constants.QResult ret = Constants.QResult.valueOf(this.unmuteVideo(this.mNativeHandle));
        this.mVideoStreamMgr.onLocalVideoStreamMuteState(0, false);
        return ret;
    }

    @Override
    public Constants.QResult subscribeScreen(long userId) {
        if (this.mRemoteScreenRender != null) {
            VideoSink sink;
            int ret;
            if (!ThreadUtils.runningOnUiThread()) {
                PLogger.w(TAG, "RtcEngine.subscribeScreen, not on main thread, userId=" + userId);
            }
            if ((ret = this.subscribeScreen(this.mNativeHandle, userId, this.mRemoteScreenRender)) == Constants.QResult.OK.getValue() && (sink = this.mRemoteScreenRender.getTarget()) instanceof RtcView) {
                final RtcView view = (RtcView)sink;
                GestureHandler gestureHandler = new GestureHandler(video.pano.rtc.impl.GlobalRef.applicationContext, new GestureHandler.Callback(){

                    @Override
                    public void onDoubleClicked(float x, float y) {
                        if (RtcEngineImpl.this.mPredefinedRatio == IVideoRender.ScalingRatio.SCALE_RATIO_FIT) {
                            RtcEngineImpl.this.mPredefinedRatio = IVideoRender.ScalingRatio.SCALE_RATIO_ORIGINAL;
                        } else {
                            RtcEngineImpl.this.mPredefinedRatio = IVideoRender.ScalingRatio.SCALE_RATIO_FIT;
                        }
                        view.setScalingRatio(RtcEngineImpl.this.mPredefinedRatio);
                        view.redrawFrame();
                    }

                    @Override
                    public void onMove(float x, float y, float dx, float dy, float vx, float vy) {
                        view.setMovingDistance((int)dx, (int)dy);
                        view.redrawFrame();
                    }

                    @Override
                    public void onScale(float factor, float focusX, float focusY, float spanX, float spanY) {
                        view.setScalingRatioWithFocus(factor, (int)focusX, (int)focusY);
                        view.redrawFrame();
                    }
                });
                view.setRtcTouchListener((v, event) -> gestureHandler.handleEvent(event));
            }
            return Constants.QResult.valueOf(ret);
        }
        PLogger.w(TAG, "RtcEngine.subscribeScreen, render is not set, userId=" + userId);
        return Constants.QResult.InvalidState;
    }

    @Override
    public Constants.QResult unsubscribeScreen(long userId) {
        VideoSink sink;
        if (this.mRemoteScreenRender != null && (sink = this.mRemoteScreenRender.getTarget()) instanceof RtcView) {
            ((RtcView)sink).setRtcTouchListener(null);
        }
        Constants.QResult ret = Constants.QResult.valueOf(this.unsubscribeScreen(this.mNativeHandle, userId));
        this.mRemoteScreenRender = null;
        return ret;
    }

    @Override
    public Constants.QResult setLoudspeakerStatus(boolean onoff) {
        return this.mAudioDeviceMgr.setLoudspeakerStatus(onoff);
    }

    @Override
    public boolean isLoudspeakerOn() {
        return this.mAudioDeviceMgr.isLoudspeakerOn();
    }

    @Override
    public Constants.QResult setMicrophoneMuteStatus(boolean enable) {
        return this.mAudioDeviceMgr.setMicrophoneMuteStatus(enable);
    }

    @Override
    public Constants.QResult setRecordDeviceVolume(int volume) {
        return this.mAudioDeviceMgr.setRecordDeviceVolume(volume);
    }

    @Override
    public int getRecordDeviceVolume() {
        return this.mAudioDeviceMgr.getRecordDeviceVolume();
    }

    @Override
    public Constants.QResult setPlayoutDeviceVolume(int volume) {
        return this.mAudioDeviceMgr.setPlayoutDeviceVolume(volume);
    }

    @Override
    public int getPlayoutDeviceVolume() {
        return this.mAudioDeviceMgr.getPlayoutDeviceVolume();
    }

    @Override
    public int getRecordingLevel() {
        return this.mAudioDeviceMgr.getRecordingLevel();
    }

    @Override
    public int getPlayoutLevel() {
        return this.mAudioDeviceMgr.getPlayoutLevel();
    }

    @Override
    public Constants.QResult setMediaStatsObserver(RtcMediaStatsObserver observer) {
        this.mStatsHandler.setMediaStatsObserver(observer);
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setAudioIndication(RtcAudioIndication indication) {
        RtcEngineImpl indicator = indication != null ? this : null;
        Constants.QResult ret = Constants.QResult.valueOf(this.setAudioIndication(this.mNativeHandle, indicator));
        this.mAudioIndicator = indication;
        return ret;
    }

    @Override
    public Constants.QResult setFaceBeautify(boolean enabled) {
        if (this.mCaptureFrameObserver != null && enabled != this.mDoFaceBeauty) {
            Constants.QResult ret = this.mCaptureFrameObserver.enableInternalFilter(enabled || this.mDoBuiltinTransform);
            if (ret != Constants.QResult.OK) {
                return ret;
            }
            this.mCaptureFrameObserver.setDoFaceBeauty(enabled);
            this.mDoFaceBeauty = enabled;
            return ret;
        }
        return Constants.QResult.Failed;
    }

    @Override
    public Constants.QResult setFaceBeautifyIntensity(float intensity) {
        if (this.mCaptureFrameObserver != null && this.mDoFaceBeauty) {
            this.mCaptureFrameObserver.setBeautifyIntensity(intensity);
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setMediaProcessor(Constants.MediaProcessorType type, Object processor, Object param) {
        PLogger.ni(TAG, "setMediaProcessor, type=" + (Object)((Object)type) + ", processor=" + processor);
        switch (type) {
            case VideoTexturePreprocessor: {
                if (processor instanceof RtcVideoTextureFilter && param instanceof RtcVideoTextureFilterConfig) {
                    return this.setExternalVideoCapturerFilter((RtcVideoTextureFilter)processor, ((RtcVideoTextureFilterConfig)param).textureType, ((RtcVideoTextureFilterConfig)param).withYuv);
                }
                if (processor != null) break;
                return this.setExternalVideoCapturerFilter(null, Constants.TextureType.Texture2D, false);
            }
            case AudioCaptureExProcessor: 
            case AudioCaptureExEffectProcessor: 
            case AudioRenderExProcessor: {
                if (processor instanceof RtcAudioExProcessor) {
                    return Constants.QResult.valueOf(this.setMediaProcessor(this.mNativeHandle, type.getValue(), (RtcAudioExProcessor)processor));
                }
                if (processor != null) break;
                return Constants.QResult.valueOf(this.setMediaProcessor(this.mNativeHandle, type.getValue(), null));
            }
        }
        return Constants.QResult.Failed;
    }

    @Override
    public Constants.QResult setOption(Constants.PanoOptionType type, Object value) {
        switch (type) {
            case PanoOptionBuiltinTransform: {
                if (this.mUseQuadTrans) {
                    PLogger.nw(TAG, "VideoQuadTransform is used already.");
                    return Constants.QResult.InvalidArgs;
                }
                if (!(value instanceof BuiltinTransformParams)) break;
                if (this.mCaptureFrameObserver != null) {
                    BuiltinTransformParams params = (BuiltinTransformParams)value;
                    boolean enabled = params.enable;
                    if (enabled != this.mDoBuiltinTransform) {
                        Constants.QResult ret = this.mCaptureFrameObserver.enableInternalFilter(enabled || this.mDoFaceBeauty);
                        if (ret != Constants.QResult.OK) {
                            return ret;
                        }
                        this.mCaptureFrameObserver.setDoBuiltinTransform(enabled);
                        this.mDoBuiltinTransform = enabled;
                    }
                    if (this.mDoBuiltinTransform) {
                        boolean reset = params.bReset;
                        float xScaling = params.xScaling;
                        float yScaling = params.yScaling;
                        float xRotation = params.xRotation;
                        float yRotation = params.yRotation;
                        float zRotation = params.zRotation;
                        float xProjection = params.xProjection;
                        float yProjection = params.yProjection;
                        this.mCaptureFrameObserver.setBuiltinTransformParameters(reset, xScaling, yScaling, xRotation, yRotation, zRotation, xProjection, yProjection);
                    }
                    this.mUseBuiltinTrans = true;
                }
                return Constants.QResult.OK;
            }
            case EnablePanoAudioProfile: {
                if (!(value instanceof RtcAudioProfile)) break;
                RtcAudioProfile profile = (RtcAudioProfile)value;
                return Constants.QResult.valueOf(this.setAudioProfile(this.mNativeHandle, profile.sampleRate.getValue(), profile.channel.getValue(), profile.profileQuality.getValue()));
            }
            case VideoQuadTransform: {
                if (this.mUseBuiltinTrans) {
                    PLogger.nw(TAG, "PanoOptionBuiltinTransform is used already.");
                    return Constants.QResult.InvalidArgs;
                }
                if (!(value instanceof QuadTransformParams)) break;
                if (this.mCaptureFrameObserver != null) {
                    QuadTransformParams quadT = (QuadTransformParams)value;
                    boolean enabled = quadT.enable;
                    if (enabled != this.mDoBuiltinTransform) {
                        Constants.QResult ret = this.mCaptureFrameObserver.enableInternalFilter(enabled || this.mDoFaceBeauty);
                        if (ret != Constants.QResult.OK) {
                            return ret;
                        }
                        this.mCaptureFrameObserver.setDoBuiltinTransform(enabled);
                        this.mDoBuiltinTransform = enabled;
                    }
                    if (this.mDoBuiltinTransform) {
                        boolean reset = quadT.bReset;
                        boolean mirror = quadT.bMirror;
                        float xTopLeft = 0.0f;
                        float yTopLeft = 0.0f;
                        float xTopRight = 0.0f;
                        float yTopRight = 0.0f;
                        float xBottomLeft = 0.0f;
                        float yBottomLeft = 0.0f;
                        float xBottomRight = 0.0f;
                        float yBottomRight = 0.0f;
                        if (quadT.index.getValue() == Constants.QuadIndex.TopLeft.getValue()) {
                            xTopLeft = quadT.xDeltaAxis;
                            yTopLeft = quadT.yDeltaAxis;
                        } else if (quadT.index.getValue() == Constants.QuadIndex.TopRight.getValue()) {
                            xTopRight = quadT.xDeltaAxis;
                            yTopRight = quadT.yDeltaAxis;
                        } else if (quadT.index.getValue() == Constants.QuadIndex.BottomLeft.getValue()) {
                            xBottomLeft = quadT.xDeltaAxis;
                            yBottomLeft = quadT.yDeltaAxis;
                        } else if (quadT.index.getValue() == Constants.QuadIndex.BottomRight.getValue()) {
                            xBottomRight = quadT.xDeltaAxis;
                            yBottomRight = quadT.yDeltaAxis;
                        }
                        this.mCaptureFrameObserver.setBuiltinTransformParameters(reset, mirror, xTopLeft, yTopLeft, xTopRight, yTopRight, xBottomLeft, yBottomLeft, xBottomRight, yBottomRight);
                    }
                    this.mUseQuadTrans = true;
                }
                return Constants.QResult.OK;
            }
            case AudioPreProcessMode: {
                if (!(value instanceof Constants.AudioPreProcessModeOption)) break;
                Constants.AudioPreProcessModeOption mode = (Constants.AudioPreProcessModeOption)((Object)value);
                return Constants.QResult.valueOf(this.setIntOption(this.mNativeHandle, Constants.PanoOptionType.AudioPreProcessMode.getValue(), mode.getValue()));
            }
            case AudioNoiseSuppressionLevel: {
                if (!(value instanceof Constants.AudioNoiseSuppressionLevelOption)) break;
                Constants.AudioNoiseSuppressionLevelOption mode = (Constants.AudioNoiseSuppressionLevelOption)((Object)value);
                return Constants.QResult.valueOf(this.setIntOption(this.mNativeHandle, Constants.PanoOptionType.AudioNoiseSuppressionLevel.getValue(), mode.getValue()));
            }
            case AudioAutoGainControl: {
                if (!(value instanceof Constants.AudioAutoGainControlOption)) break;
                Constants.AudioAutoGainControlOption mode = (Constants.AudioAutoGainControlOption)((Object)value);
                return Constants.QResult.valueOf(this.setIntOption(this.mNativeHandle, Constants.PanoOptionType.AudioAutoGainControl.getValue(), mode.getValue()));
            }
            case AudioVoiceChangerMode: {
                if (!(value instanceof Constants.AudioVoiceChangerOption)) break;
                Constants.AudioVoiceChangerOption option = (Constants.AudioVoiceChangerOption)((Object)value);
                return Constants.QResult.valueOf(this.setIntOption(this.mNativeHandle, Constants.PanoOptionType.AudioVoiceChangerMode.getValue(), option.getValue()));
            }
            case ScreenOptimization: {
                if (!(value instanceof Boolean)) break;
                return Constants.QResult.valueOf(this.setBoolOption(this.mNativeHandle, Constants.PanoOptionType.ScreenOptimization.getValue(), (Boolean)value));
            }
            case VideoBrightnessAdjuster: {
                if (!(value instanceof VideoBrightnessParams) || this.mCaptureFrameObserver == null) break;
                VideoBrightnessParams brightParam = (VideoBrightnessParams)value;
                boolean enabled = brightParam.enable;
                if (enabled != this.mDoExtBrightness) {
                    Constants.QResult ret = this.mCaptureFrameObserver.enableInternalFilter(enabled || this.mDoExtBrightness);
                    if (ret != Constants.QResult.OK) {
                        return ret;
                    }
                    this.mCaptureFrameObserver.setDoExtBrightness(enabled);
                    this.mDoExtBrightness = enabled;
                }
                if (this.mDoExtBrightness) {
                    this.mCaptureFrameObserver.setBrightness(brightParam.brightness);
                    this.mCaptureFrameObserver.setSmoothness(brightParam.smoothness);
                }
                return Constants.QResult.OK;
            }
            default: {
                if (value instanceof Boolean) {
                    boolean enabled = (Boolean)value;
                    return Constants.QResult.valueOf(this.setBoolOption(this.mNativeHandle, type.getValue(), enabled));
                }
                if (value instanceof Integer) {
                    int v = (Integer)value;
                    return Constants.QResult.valueOf(this.setIntOption(this.mNativeHandle, type.getValue(), v));
                }
                return Constants.QResult.NotImplemented;
            }
        }
        return Constants.QResult.InvalidArgs;
    }

    @Override
    public Constants.QResult snapshotVideo(String outputDir, long userId, RtcSnapshotVideoOption option) {
        return Constants.QResult.valueOf(this.snapshotVideo(this.mNativeHandle, outputDir, userId, option.format.getValue(), option.mirror));
    }

    @Override
    public Constants.QResult startAudioDump(long maxDumpSize) {
        Context context = video.pano.rtc.impl.GlobalRef.applicationContext;
        File extPath = context.getExternalFilesDir("data");
        if (extPath == null || -1 == context.getPackageManager().checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", context.getPackageName())) {
            extPath = context.getDir("data", 0);
        }
        String fileName = extPath.getAbsolutePath();
        fileName = fileName + "/pano_audio.dump";
        Constants.QResult ret = Constants.QResult.valueOf(this.startAudioDump(this.mNativeHandle, fileName, maxDumpSize));
        return ret;
    }

    @Override
    public Constants.QResult stopAudioDump() {
        Constants.QResult ret = Constants.QResult.valueOf(this.stopAudioDump(this.mNativeHandle));
        return ret;
    }

    @Override
    public Constants.QResult setAudioEqualization(Constants.AudioEqualizationMode option) {
        int eqOption = option.getValue();
        Constants.QResult ret = Constants.QResult.valueOf(this.setAudioEqualization(this.mNativeHandle, eqOption));
        return ret;
    }

    @Override
    public Constants.QResult setAudioReverb(Constants.AudioReverbMode option) {
        int rbOption = option.getValue();
        Constants.QResult ret = Constants.QResult.valueOf(this.setAudioReverb(this.mNativeHandle, rbOption));
        return ret;
    }

    @Override
    public Constants.QResult setAudioEarMonitoring(boolean enabled) {
        return this.setOption(Constants.PanoOptionType.EnableAudioEarMonitoring, enabled);
    }

    @Override
    public Constants.QResult setVideoFrameRate(Constants.VideoFrameRateType type) {
        int frameRateType = type.getValue();
        Constants.QResult ret = Constants.QResult.valueOf(this.setVideoFrameRate(this.mNativeHandle, frameRateType));
        return ret;
    }

    @Override
    public Constants.QResult enableUploadDebugLogs(boolean onoff) {
        return this.setOption(Constants.PanoOptionType.EnableUploadDebugLogs, onoff);
    }

    @Override
    public Constants.QResult enableUploadAudioDump(boolean onoff) {
        return this.setOption(Constants.PanoOptionType.EnableUploadAudioDump, onoff);
    }

    @Override
    public Constants.QResult sendFeedback(RtcEngine.FeedbackInfo info) {
        Constants.QResult ret = Constants.QResult.valueOf(this.sendFeedback(this.mNativeHandle, info.type.getValue(), info.productName, info.description, info.contact, info.extraInfo, info.uploadLogs));
        return ret;
    }

    @Override
    public Constants.DeviceRating queryDeviceRating() {
        int rating = this.queryDeviceRating(this.mNativeHandle);
        return RtcEngineImpl.ToDeviceRating(rating);
    }

    @Override
    public String getSdkVersion() {
        return this.mSdkVersion;
    }

    @Override
    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    @Override
    public RtcWhiteboard getWhiteboard() {
        return this.mWhiteboard;
    }

    @Override
    public RtcWhiteboard getWhiteboardById(String whiteboardId) {
        return this.mWhiteboardMap.get(whiteboardId);
    }

    @Override
    public Constants.QResult switchWhiteboard(String whiteboardId) {
        Constants.QResult ret = Constants.QResult.valueOf(this.switchWhiteboard(this.mNativeHandle, whiteboardId));
        if (ret != Constants.QResult.OK) {
            return ret;
        }
        this.mWhiteboard = this.mWhiteboardMap.get(whiteboardId);
        if (null == this.mWhiteboard) {
            RtcWhiteboardImpl whiteboard = new RtcWhiteboardImpl(this.mNativeHandle, whiteboardId);
            this.setupWhiteboard(whiteboard);
            this.mWhiteboardMap.put(whiteboardId, whiteboard);
            this.mWhiteboard = whiteboard;
        }
        return Constants.QResult.OK;
    }

    @Override
    public PanoAnnotationManager getAnnotationMgr() {
        return this.mAnnotationMgr;
    }

    @Override
    public RtcAudioMixingMgr getAudioMixingMgr() {
        return this.mAudioMixingMgr;
    }

    @Override
    public RtcNetworkManager getNetworkManager() {
        return this.mNetworkMgr;
    }

    @Override
    public RtcExternalAudioRecorder getExternalAudioRecorder() {
        return this.mExAudioRecorder;
    }

    @Override
    public RtcExternalAudioPlayer getExternalAudioPlayer() {
        return this.mExAudioPlayer;
    }

    @Override
    public RtcAudioDeviceManager getAudioDeviceManager() {
        return this.mAudioDeviceMgr;
    }

    @Override
    public RtcVideoStreamManager getVideoStreamManager() {
        return this.mVideoStreamMgr;
    }

    @Override
    public RtcVideoDeviceManager getVideoDeviceManager() {
        return this.mVideoDeviceMgr;
    }

    @Override
    public RtcMessageService getMessageService() {
        return this.mRtcMessageService;
    }

    private Constants.QResult doJoinChannel(String channelId, long userId) {
        int ret = this.joinChannel(this.mNativeHandle, channelId, userId, this.mChannelConfig);
        Constants.QResult result = Constants.QResult.valueOf(ret);
        if (result == Constants.QResult.OK) {
            RtcVideoStreamMgrImpl.StreamInfo stream;
            if (this.mAudioDeviceMgr != null) {
                this.mAudioDeviceMgr.start(0, this.mDocshow.getAudioMode());
            }
            if ((stream = this.mVideoStreamMgr.getStream(0)) == null) {
                stream = new RtcVideoStreamMgrImpl.StreamInfo();
                stream.streamId = 0;
                this.mVideoStreamMgr.addStream(stream.streamId, stream);
                this.setDefaultVideoCapturerFilter(this.mCaptureFrameObserver);
            }
        } else {
            this.onChannelJoinConfirm(ret);
        }
        return result;
    }

    private void parseDocshowSettings(String dshow) {
        boolean needUpdateDocshow = false;
        try {
            JSONObject jperf;
            int vFec;
            JSONObject jqos;
            JSONObject jdocshow = new JSONObject(dshow);
            if (jdocshow.has("audio")) {
                int apmComplexity;
                float farPreG;
                float nearPreG;
                int farNG;
                int nearNG;
                int audioLayer;
                int audioStream;
                int audioSource;
                int audioMode;
                int nsLvl;
                int nsType;
                int agcType;
                int sAecType;
                int aecType;
                JSONObject jaudio = jdocshow.getJSONObject("audio");
                if (jaudio.has("aecType") && (aecType = jaudio.getInt("aecType")) != this.mDocshow.getAudioAecType()) {
                    if (this.mUserAudioAecType == Constants.AudioAecType.Default) {
                        needUpdateDocshow = true;
                    }
                    this.mDocshow.setAudioAecType(aecType);
                }
                if (jaudio.has("sAecType") && (sAecType = jaudio.getInt("sAecType")) != this.mDocshow.getAudioSoftAecType()) {
                    needUpdateDocshow = true;
                    this.mDocshow.setAudioSoftAecType(sAecType);
                }
                if (jaudio.has("agcType") && (agcType = jaudio.getInt("agcType")) != this.mDocshow.getAudioAgcType()) {
                    needUpdateDocshow = true;
                    this.mDocshow.setAudioAgcType(agcType);
                }
                if (jaudio.has("nsType") && (nsType = jaudio.getInt("nsType")) != this.mDocshow.getAudioNsType()) {
                    needUpdateDocshow = true;
                    this.mDocshow.setAudioNsType(nsType);
                }
                if (jaudio.has("nsLvl") && (nsLvl = jaudio.getInt("nsLvl")) != this.mDocshow.getAudioNsLevel()) {
                    needUpdateDocshow = true;
                    this.mDocshow.setAudioNsLevel(nsLvl);
                }
                if (jaudio.has("audioMode") && (audioMode = jaudio.getInt("audioMode")) != this.mDocshow.getAudioMode()) {
                    needUpdateDocshow = true;
                    this.mDocshow.setAudioMode(audioMode);
                    ThreadUtils.runOnUiThread(() -> this.mAudioDeviceMgr.setAudioMode(audioMode));
                }
                if (jaudio.has("capType") && (audioSource = jaudio.getInt("capType")) != this.mDocshow.getAudioSource()) {
                    needUpdateDocshow = true;
                    this.mDocshow.setAudioSource(audioSource);
                }
                if (jaudio.has("plyType") && (audioStream = jaudio.getInt("plyType")) != this.mDocshow.getAudioStream()) {
                    needUpdateDocshow = true;
                    this.mDocshow.setAudioStream(audioStream);
                }
                if (jaudio.has("ioAPI") && (audioLayer = jaudio.getInt("ioAPI")) != this.mDocshow.getAudioLayer()) {
                    needUpdateDocshow = true;
                    this.mDocshow.setAudioLayer(audioLayer);
                }
                if (jaudio.has("nearNG") && (nearNG = jaudio.getInt("nearNG")) != this.mDocshow.getAudioNearNG()) {
                    needUpdateDocshow = true;
                    this.mDocshow.setAudioNearNG(nearNG);
                }
                if (jaudio.has("farNG") && (farNG = jaudio.getInt("farNG")) != this.mDocshow.getAudioFarNG()) {
                    needUpdateDocshow = true;
                    this.mDocshow.setAudioFarNG(farNG);
                }
                if (jaudio.has("nearPreG") && (nearPreG = (float)jaudio.getDouble("nearPreG")) != this.mDocshow.getAudioNearPreG()) {
                    needUpdateDocshow = true;
                    this.mDocshow.setAudioNearPreG(nearPreG);
                }
                if (jaudio.has("farPreG") && (farPreG = (float)jaudio.getDouble("farPreG")) != this.mDocshow.getAudioFarPreG()) {
                    needUpdateDocshow = true;
                    this.mDocshow.setAudioFarPreG(farPreG);
                }
                if (jaudio.has("apmComplexity") && (apmComplexity = jaudio.getInt("apmComplexity")) != this.mDocshow.getApmComplexity()) {
                    needUpdateDocshow = true;
                    this.mDocshow.setApmComplexity(apmComplexity);
                }
            }
            if (jdocshow.has("video")) {
                int vdenoise;
                int av1CpuCores;
                int av1CpuFreq;
                int av1DecoderSetting;
                int av1EncoderSetting;
                String videoHwDecoderFlag;
                String videoHwEncoderFlag;
                JSONObject jvideo = jdocshow.getJSONObject("video");
                if (jvideo.has("hw.h264.encoder") && !(videoHwEncoderFlag = jvideo.getString("hw.h264.encoder")).equals(this.mDocshow.getVideoHwEncoderFlag())) {
                    boolean hw_encoder;
                    if ((videoHwEncoderFlag.equals("true") || videoHwEncoderFlag.equals("false")) && (hw_encoder = videoHwEncoderFlag.equals("true")) != this.mUserVideoHwEncoderFlag) {
                        needUpdateDocshow = true;
                    }
                    this.mDocshow.setVideoHwEncoderFlag(videoHwEncoderFlag);
                }
                if (jvideo.has("hw.h264.decoder") && !(videoHwDecoderFlag = jvideo.getString("hw.h264.decoder")).equals(this.mDocshow.getVideoHwDecoderFlag())) {
                    boolean hw_decoder;
                    if ((videoHwDecoderFlag.equals("true") || videoHwDecoderFlag.equals("false")) && (hw_decoder = videoHwDecoderFlag.equals("true")) != this.mUserVideoHwDecoderFlag) {
                        needUpdateDocshow = true;
                    }
                    this.mDocshow.setVideoHwDecoderFlag(videoHwDecoderFlag);
                }
                if (jvideo.has("av1Enc") && (av1EncoderSetting = jvideo.getInt("av1Enc")) != this.mDocshow.getAv1EncoderSetting()) {
                    this.mDocshow.setAv1EncoderSetting(av1EncoderSetting);
                    needUpdateDocshow = true;
                }
                if (jvideo.has("av1Dec") && (av1DecoderSetting = jvideo.getInt("av1Dec")) != this.mDocshow.getAv1DecoderSetting()) {
                    this.mDocshow.setAv1DecoderSetting(av1DecoderSetting);
                    needUpdateDocshow = true;
                }
                if (jvideo.has("av1Freq") && (av1CpuFreq = jvideo.getInt("av1Freq")) != this.mDocshow.getAv1CpuFreq()) {
                    this.mDocshow.setAv1CpuFreq(av1CpuFreq);
                    needUpdateDocshow = true;
                }
                if (jvideo.has("av1Cores") && (av1CpuCores = jvideo.getInt("av1Cores")) != this.mDocshow.getAv1CpuCores()) {
                    this.mDocshow.setAv1CpuCores(av1CpuCores);
                    needUpdateDocshow = true;
                }
                if (jvideo.has("denoise") && (vdenoise = jvideo.getInt("denoise")) != this.mDocshow.getVDenoise()) {
                    this.mDocshow.setVDenoise(vdenoise);
                    needUpdateDocshow = true;
                }
            }
            if (jdocshow.has("qos") && (jqos = jdocshow.getJSONObject("qos")).has("vFec") && (vFec = jqos.getInt("vFec")) != this.mDocshow.getVFec()) {
                this.mDocshow.setVFec(vFec);
                needUpdateDocshow = true;
            }
            int deviceRating = 0;
            if (jdocshow.has("perf") && (jperf = jdocshow.getJSONObject("perf")).has("deviceRating")) {
                deviceRating = jperf.getInt("deviceRating");
            }
            if (deviceRating != this.mDocshow.getDeviceRating()) {
                this.mDocshow.setDeviceRating(deviceRating);
                needUpdateDocshow = true;
            }
        }
        catch (JSONException e) {
            return;
        }
        if (needUpdateDocshow) {
            this.mDocshow.store();
            this.updateAndroidConfig(this.mNativeHandle, this.getRtcAndroidConfig());
        }
    }

    private RtcAndroidConfig getRtcAndroidConfig() {
        RtcAndroidConfig cfg = new RtcAndroidConfig();
        cfg.setAudioScenario(this.mAudioScenario);
        cfg.setAudioAecType(this.mUserAudioAecType.getValue());
        cfg.setContext(video.pano.rtc.impl.GlobalRef.applicationContext);
        EglBase.Context sharedContext = EglSharedContextHelper.getEglSharedContext();
        cfg.setEglSharedContext(sharedContext);
        String videoHwEncoderFlag = this.mDocshow.getVideoHwEncoderFlag();
        String videoHdDecoderFlag = this.mDocshow.getVideoHwDecoderFlag();
        boolean hw_encoder = this.mUserVideoHwEncoderFlag;
        boolean hw_decoder = this.mUserVideoHwDecoderFlag;
        if (videoHwEncoderFlag.equals("false")) {
            hw_encoder = false;
        }
        if (videoHdDecoderFlag.equals("false")) {
            hw_decoder = false;
        }
        boolean bl = hw_encoder = hw_encoder && VideoHwHelper.hasH264HwEncoder();
        if (hw_encoder) {
            cfg.setEncoderFactory((VideoEncoderFactory)new DefaultVideoEncoderFactory(sharedContext, false, cfg.isEnableH264HighProfile()));
        }
        boolean bl2 = hw_decoder = hw_decoder && VideoHwHelper.hasH264HwDecoder();
        if (hw_decoder) {
            cfg.setDecoderFactory((VideoDecoderFactory)new DefaultVideoDecoderFactory(sharedContext));
        }
        cfg.setVideoCodecHwAcceleration(hw_encoder || hw_decoder);
        cfg.setUniqueID(DeviceUuid.getDeviceID(video.pano.rtc.impl.GlobalRef.applicationContext));
        cfg.setDocshowSettings(this.mDocshow);
        return cfg;
    }

    RtcEngineConfigImpl.RTCAudioAecType toRTCAudioAecType(Constants.AudioAecType type) {
        switch (type) {
            case Off: {
                return RtcEngineConfigImpl.RTCAudioAecType.kAudioAecOff;
            }
            case Software: {
                return RtcEngineConfigImpl.RTCAudioAecType.kAudioAecSoftware;
            }
        }
        return RtcEngineConfigImpl.RTCAudioAecType.kAudioAecDefault;
    }

    private String getCameraId(boolean frontCamera) {
        CameraManager manager;
        if (Build.VERSION.SDK_INT >= 21 && (manager = (CameraManager)video.pano.rtc.impl.GlobalRef.applicationContext.getSystemService("camera")) != null) {
            try {
                String[] ids;
                for (String cameraId : ids = manager.getCameraIdList()) {
                    CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId);
                    Integer facing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                    if (facing == null || (facing != 0 || !frontCamera) && (facing != 1 || frontCamera)) continue;
                    return cameraId;
                }
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    @Override
    public void onChannelJoinConfirm(int result) {
        Constants.QResult qr = Constants.QResult.valueOf(result);
        PLogger.i(TAG, "RtcEngine.onChannelJoinConfirm: result=" + result + ", joined=" + this.mChannelJoined);
        boolean bl = this.mChannelJoined = qr == Constants.QResult.OK;
        if (this.mChannelJoined) {
            try {
                if (!this.mWifiLock.isHeld()) {
                    this.mWifiLock.acquire();
                }
            }
            catch (Exception e) {
                PLogger.ne(TAG, "onChannelJoinConfirm, Error getting WIFI Lock: " + e.getMessage());
            }
        } else {
            this.leaveChannel(this.mNativeHandle);
            if (this.mAudioDeviceMgr != null) {
                this.mAudioDeviceMgr.stop();
            }
        }
        if (this.mCallback != null) {
            this.mCallback.onChannelJoinConfirm(qr);
        }
    }

    @Override
    public void onChannelLeaveIndication(int result) {
        Constants.QResult reason = Constants.QResult.valueOf(result);
        PLogger.i(TAG, "RtcEngine.onChannelLeaveIndication: result=" + result + ", joined=" + this.mChannelJoined);
        this.leaveChannel(this.mNativeHandle);
        this.mChannelJoined = false;
        this.mUseBuiltinTrans = false;
        this.mUseQuadTrans = false;
        if (this.mVideoStreamMgr != null) {
            this.mVideoStreamMgr.clearForLeave();
        }
        if (this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
        }
        if (this.mCallback != null) {
            this.mCallback.onChannelLeaveIndication(reason);
        }
    }

    @Override
    public void onChannelCountDown(long remain) {
        PLogger.i(TAG, "RtcEngine.onChannelCountDown: remain=" + remain);
        if (this.mCallback != null) {
            this.mCallback.onChannelCountDown(remain);
        }
    }

    @Override
    public void onUserJoinIndication(long userId, String userName) {
        if (this.mCallback != null) {
            this.mCallback.onUserJoinIndication(userId, userName);
        }
    }

    @Override
    public void onUserLeaveIndication(long userId, int reason) {
        if (this.mCallback != null) {
            Constants.UserLeaveReason r = Constants.UserLeaveReason.Normal;
            if (reason == Constants.UserLeaveReason.Expelled.getValue()) {
                r = Constants.UserLeaveReason.Expelled;
            } else if (reason == Constants.UserLeaveReason.Disconnected.getValue()) {
                r = Constants.UserLeaveReason.Disconnected;
            } else if (reason == Constants.UserLeaveReason.DuplicateUserID.getValue()) {
                r = Constants.UserLeaveReason.DuplicateUserID;
            }
            this.mCallback.onUserLeaveIndication(userId, r);
        }
    }

    @Override
    public void onUserAudioStart(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onUserAudioStart(userId);
        }
    }

    @Override
    public void onUserAudioStop(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onUserAudioStop(userId);
        }
    }

    @Override
    public void onUserAudioSubscribe(long userId, int result) {
        if (this.mCallback != null) {
            this.mCallback.onUserAudioSubscribe(userId, RtcEngineImpl.ToMediaSubscribeResult(result));
        }
    }

    @Override
    public void onUserVideoStart(long userId, int maxProfile) {
        if (this.mCallback != null) {
            Constants.VideoProfileType profile = RtcEngineImpl.ToVideoProfileType(maxProfile);
            this.mCallback.onUserVideoStart(userId, profile);
        }
    }

    @Override
    public void onUserVideoStop(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onUserVideoStop(userId);
        }
    }

    @Override
    public void onUserVideoSubscribe(long userId, int result) {
        if (this.mCallback != null) {
            this.mCallback.onUserVideoSubscribe(userId, RtcEngineImpl.ToMediaSubscribeResult(result));
        }
    }

    @Override
    public void onUserAudioMute(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onUserAudioMute(userId);
        }
    }

    @Override
    public void onUserAudioUnmute(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onUserAudioUnmute(userId);
        }
    }

    @Override
    public void onUserVideoMute(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onUserVideoMute(userId);
        }
    }

    @Override
    public void onUserVideoUnmute(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onUserVideoUnmute(userId);
        }
    }

    @Override
    public void onUserScreenStart(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onUserScreenStart(userId);
        }
    }

    @Override
    public void onUserScreenStop(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onUserScreenStop(userId);
        }
    }

    @Override
    public void onUserScreenSubscribe(long userId, int result) {
        if (this.mCallback != null) {
            this.mCallback.onUserScreenSubscribe(userId, RtcEngineImpl.ToMediaSubscribeResult(result));
        }
    }

    @Override
    public void onUserScreenMute(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onUserScreenMute(userId);
        }
    }

    @Override
    public void onUserScreenUnmute(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onUserScreenUnmute(userId);
        }
    }

    @Override
    public void onWhiteboardAvailable() {
        PLogger.i(TAG, "RtcEngine.onWhiteboardAvailable");
        if (this.mCallback != null) {
            this.mCallback.onWhiteboardAvailable();
        }
    }

    @Override
    public void onWhiteboardUnavailable() {
        PLogger.i(TAG, "RtcEngine.onWhiteboardUnavailable");
        if (this.mCallback != null) {
            this.mCallback.onWhiteboardUnavailable();
        }
    }

    @Override
    public void onWhiteboardStart() {
        PLogger.i(TAG, "RtcEngine.onWhiteboardStart");
        if (this.mCallback != null) {
            this.mCallback.onWhiteboardStart();
        }
    }

    @Override
    public void onWhiteboardStop() {
        PLogger.i(TAG, "RtcEngine.onWhiteboardStop");
        if (this.mCallback != null) {
            this.mCallback.onWhiteboardStop();
        }
    }

    @Override
    public void onWhiteboardStart(String whiteboardId) {
        PLogger.i(TAG, "RtcEngine.onWhiteboardStart " + whiteboardId);
        if (this.mCallback != null) {
            this.mCallback.onWhiteboardStart(whiteboardId);
        }
    }

    @Override
    public void onWhiteboardStop(String whiteboardId) {
        RtcWhiteboardImpl whiteboard;
        PLogger.i(TAG, "RtcEngine.onWhiteboardStop " + whiteboardId);
        if (this.mCallback != null) {
            this.mCallback.onWhiteboardStop(whiteboardId);
        }
        if ((whiteboard = this.mWhiteboardMap.get(whiteboardId)) != null) {
            whiteboard.close();
        }
    }

    @Override
    public void onFirstAudioDataReceived(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onFirstAudioDataReceived(userId);
        }
    }

    @Override
    public void onFirstVideoDataReceived(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onFirstVideoDataReceived(userId);
        }
    }

    @Override
    public void onFirstScreenDataReceived(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onFirstScreenDataReceived(userId);
        }
    }

    @Override
    public void onFirstVideoFrameRendered(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onFirstVideoFrameRendered(userId);
        }
    }

    @Override
    public void onFirstScreenFrameRendered(long userId) {
        if (this.mCallback != null) {
            this.mCallback.onFirstScreenFrameRendered(userId);
        }
    }

    @Override
    public void onAudioDeviceStateChanged(String deviceId, int deviceType, int deviceState) {
        if (this.mCallback != null) {
            this.mCallback.onAudioDeviceStateChanged(deviceId, this.ToAudioDeviceType(deviceType), this.ToAudioDeviceState(deviceState));
        }
    }

    @Override
    public void onVideoDeviceStateChanged(String deviceId, int deviceType, int deviceState) {
        if (this.mCallback != null) {
            this.mCallback.onVideoDeviceStateChanged(deviceId, this.ToVideoDeviceType(deviceType), this.ToVideoDeviceState(deviceState));
        }
    }

    @Override
    public void onVideoCaptureStateChanged(String deviceId, int state) {
        if (this.mCallback != null) {
            this.mCallback.onVideoCaptureStateChanged(deviceId, RtcEngineImpl.ToVideoCaptureState(state));
        }
    }

    @Override
    public void onMessage(long userId, byte[] msg) {
        if (this.mCallback != null) {
            // empty if block
        }
    }

    @Override
    public void onChannelFailover(int state) {
        PLogger.i(TAG, "RtcEngine.onChannelFailover, state=" + state);
        if (this.mCallback != null) {
            Constants.FailoverState fs = Constants.FailoverState.Failed;
            switch (state) {
                case 0: {
                    fs = Constants.FailoverState.Reconnecting;
                    break;
                }
                case 1: {
                    fs = Constants.FailoverState.Success;
                    break;
                }
                case 2: {
                    fs = Constants.FailoverState.Failed;
                }
            }
            this.mVideoStreamMgr.notifyChannelFailover(fs);
            this.mCallback.onChannelFailover(fs);
        }
    }

    @Override
    public void onActiveSpeakerListUpdated(long[] userIds) {
        if (this.mCallback != null) {
            this.mCallback.onActiveSpeakerListUpdated(userIds);
        }
    }

    @Override
    public void onAudioMixingStateChanged(long taskId, int state) {
        PLogger.i(TAG, "RtcEngine.onAudioMixingStateChanged, taskId=" + taskId + " state=" + state);
        if (this.mAudioMixingMgr != null) {
            Constants.AudioMixingState s = Constants.AudioMixingState.Started;
            switch (state) {
                case 0: {
                    s = Constants.AudioMixingState.Started;
                    break;
                }
                default: {
                    s = Constants.AudioMixingState.Finished;
                }
            }
            this.mAudioMixingMgr.onAudioMixingStateChanged(taskId, s);
        }
    }

    @Override
    public void onVideoSnapshotCompleted(boolean succeed, long userId, String filename) {
        PLogger.i(TAG, "RtcEngine.onVideoSnapshotCompleted, succeed=" + succeed + " userId=" + userId + " filename=" + filename);
        if (this.mCallback != null) {
            this.mCallback.onVideoSnapshotCompleted(succeed, userId, filename);
        }
    }

    @Override
    public void onNetworkQuality(long userId, int quality) {
        if (this.mCallback != null) {
            this.mCallback.onNetworkQuality(userId, RtcNetworkMgrImpl.ToQualityRating(quality));
        }
    }

    @Override
    public void onAudioStartResult(int result) {
        if (this.mCallback != null) {
            this.mCallback.onAudioStartResult(Constants.QResult.valueOf(result));
        }
    }

    @Override
    public void onVideoStartResult(int result) {
        if (this.mCallback != null) {
            this.mCallback.onVideoStartResult(Constants.QResult.valueOf(result));
        }
    }

    @Override
    public void onScreenStartResult(int result) {
        if (this.mCallback != null) {
            this.mCallback.onScreenStartResult(Constants.QResult.valueOf(result));
        }
    }

    @Override
    public void onProcessDocshowSettings(String dshow) {
        PLogger.ni(TAG, "RtcEngine.onProcessDocshowSettings");
        this.parseDocshowSettings(dshow);
    }

    @Override
    public void onAudioDeviceChanged(int selectedAudioDevice, Set<Integer> availableAudioDevices) {
    }

    @Override
    public void onNetworkChanged(NetworkUtils.NetworkType type) {
        this.notifyNetworkChanged(this.mNativeHandle, type.getValue());
    }

    @Override
    public void onUserAudioLevel(RtcAudioLevel level) {
        if (this.mAudioIndicator != null) {
            this.mAudioIndicator.onUserAudioLevel(level);
        }
    }

    static Constants.VideoProfileType ToVideoProfileType(int profile) {
        Constants.VideoProfileType profileType = Constants.VideoProfileType.HD720P;
        for (Constants.VideoProfileType prof : Constants.VideoProfileType.values()) {
            if (prof.getValue() != profile) continue;
            profileType = prof;
            break;
        }
        return profileType;
    }

    private Constants.AudioDeviceType ToAudioDeviceType(int type) {
        Constants.AudioDeviceType result = Constants.AudioDeviceType.Unknown;
        for (Constants.AudioDeviceType val : Constants.AudioDeviceType.values()) {
            if (val.getValue() != type) continue;
            result = val;
            break;
        }
        return result;
    }

    private Constants.AudioDeviceState ToAudioDeviceState(int state) {
        Constants.AudioDeviceState result = Constants.AudioDeviceState.Inactive;
        for (Constants.AudioDeviceState val : Constants.AudioDeviceState.values()) {
            if (val.getValue() != state) continue;
            result = val;
            break;
        }
        return result;
    }

    private Constants.VideoDeviceType ToVideoDeviceType(int type) {
        Constants.VideoDeviceType result = Constants.VideoDeviceType.Unknown;
        for (Constants.VideoDeviceType val : Constants.VideoDeviceType.values()) {
            if (val.getValue() != type) continue;
            result = val;
            break;
        }
        return result;
    }

    private Constants.VideoDeviceState ToVideoDeviceState(int state) {
        Constants.VideoDeviceState result = Constants.VideoDeviceState.Removed;
        for (Constants.VideoDeviceState val : Constants.VideoDeviceState.values()) {
            if (val.getValue() != state) continue;
            result = val;
            break;
        }
        return result;
    }

    static Constants.VideoCaptureState ToVideoCaptureState(int state) {
        Constants.VideoCaptureState result = Constants.VideoCaptureState.Unknown;
        for (Constants.VideoCaptureState val : Constants.VideoCaptureState.values()) {
            if (val.getValue() != state) continue;
            result = val;
            break;
        }
        return result;
    }

    static Constants.MediaSubscribeResult ToMediaSubscribeResult(int result) {
        Constants.MediaSubscribeResult r = Constants.MediaSubscribeResult.Success;
        for (Constants.MediaSubscribeResult val : Constants.MediaSubscribeResult.values()) {
            if (val.getValue() != result) continue;
            r = val;
            break;
        }
        return r;
    }

    static Constants.DeviceRating ToDeviceRating(int rating) {
        Constants.DeviceRating r = Constants.DeviceRating.Unavailable;
        for (Constants.DeviceRating val : Constants.DeviceRating.values()) {
            if (val.getValue() != rating) continue;
            r = val;
            break;
        }
        return r;
    }

    private static boolean loadNativeLibrary() {
        boolean loaded = true;
        try {
            System.loadLibrary("panortc");
        }
        catch (UnsatisfiedLinkError err) {
            loaded = false;
            Log.e((String)TAG, (String)("Failed to load native library: panortc, e=" + err));
            err.printStackTrace();
        }
        return loaded;
    }

    public static boolean initNativeLibs() {
        if (!sNativeInited) {
            sNativeInited = RtcEngineImpl.loadNativeLibrary();
        }
        return sNativeInited;
    }

    private Constants.QResult setDefaultVideoCapturerFilter(CocoCaptureFrameObserver filter) {
        String device = this.mVideoStreamMgr.getCaptureDevice(0);
        RtcVideoStreamMgrImpl.StreamInfo stream = this.mVideoStreamMgr.getStream(0);
        if (stream != null) {
            stream.internalFilter = filter;
            CocoNativeCapturerObserver.setFilter(filter, device);
        } else {
            stream = new RtcVideoStreamMgrImpl.StreamInfo();
            stream.streamId = 0;
            this.mVideoStreamMgr.addStream(stream.streamId, stream);
            CocoNativeCapturerObserver.setFilter(filter, device);
        }
        return Constants.QResult.OK;
    }

    private Constants.QResult setExternalVideoCapturerFilter(RtcVideoTextureFilter filter, Constants.TextureType type, boolean withYuv) {
        if (this.mCaptureFrameObserver != null) {
            return this.mCaptureFrameObserver.setExternalFilter(filter, type, withYuv);
        }
        return Constants.QResult.Failed;
    }

    @Override
    public void onScreenPermissionRequest(boolean granted) {
        if (granted) {
            this.startScreen(this.mNativeHandle);
        } else if (this.mCallback != null) {
            this.mCallback.onScreenStartResult(Constants.QResult.AuthFailed);
        }
    }

    private native long createRtcEngine(Context var1, RtcAndroidConfig var2);

    private native void destroyRtcEngine(long var1);

    private native int initRtcEngine(long var1, RtcEngineConfigImpl var3, RtcEngineCallbackImpl var4);

    private native int updateAndroidConfig(long var1, RtcAndroidConfig var3);

    private native int joinChannel(long var1, String var3, long var4, RtcChannelConfigImpl var6);

    private native int leaveChannel(long var1);

    private native int startAudio(long var1);

    private native int stopAudio(long var1);

    private native int startVideo(long var1, ProxyVideoRender var3, int var4, boolean var5);

    private native int startScreen(long var1);

    private native int stopScreen(long var1);

    private native int stopVideo(long var1);

    private native int startPreview(long var1, VideoSink var3, int var4, boolean var5);

    private native int switchCamera(long var1);

    private native int stopPreview(long var1);

    private native int subscribeAudio(long var1, long var3);

    private native int unsubscribeAudio(long var1, long var3);

    private native int subscribeVideo(long var1, long var3, ProxyVideoRender var5, int var6);

    private native int unsubscribeVideo(long var1, long var3);

    private native int muteAudio(long var1);

    private native int unmuteAudio(long var1);

    private native int muteVideo(long var1);

    private native int unmuteVideo(long var1);

    private native int subscribeScreen(long var1, long var3, VideoSink var5);

    private native int unsubscribeScreen(long var1, long var3);

    private native int snapshotVideo(long var1, String var3, long var4, int var6, boolean var7);

    private native int setBoolOption(long var1, int var3, boolean var4);

    private native int setIntOption(long var1, int var3, int var4);

    private native int startAudioDump(long var1, String var3, long var4);

    private native int stopAudioDump(long var1);

    private native int setAudioEqualization(long var1, int var3);

    private native int setAudioReverb(long var1, int var3);

    private native int setAudioProfile(long var1, int var3, int var4, int var5);

    private native int setVideoFrameRate(long var1, int var3);

    private native int sendFeedback(long var1, int var3, String var4, String var5, String var6, String var7, boolean var8);

    private native int queryDeviceRating(long var1);

    private native int setMediaStatsObserver(long var1, RtcJsonStatsObserver var3);

    private native int setAudioIndication(long var1, RtcAudioIndication var3);

    private native int setMediaProcessor(long var1, int var3, RtcAudioExProcessor var4);

    private native int setParameters(long var1, String var3);

    private native int switchWhiteboard(long var1, String var3);

    private native String nativeGetSdkVersion();

    private native void notifyNetworkChanged(long var1, int var3);

    private static native void setAndroidInfo(String var0, String var1, String var2, String var3);

    private static native void updateNetworkType(int var0);

    private static native boolean nativeWhiteboardSupported();
}

