/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.view.ViewParent;
import com.pano.rtc.api.PanoCoursePageView;
import com.pano.rtc.api.RtcEngine;
import com.pano.rtc.api.RtcWbView;
import com.pano.rtc.api.RtcWhiteboard;

public class PanoCoursePageFactory {
    private static long mNativeHandle = 0L;

    private static PanoCoursePageView getPanoCoursePageViewById(String pageId) {
        String realWhiteboardId = pageId.substring(0, pageId.lastIndexOf("-"));
        RtcWhiteboard rtcWhiteboard = RtcEngine.getInstance().getWhiteboardById(realWhiteboardId);
        RtcWbView rtcWbView = rtcWhiteboard.getAttachedRtcWbView();
        if (rtcWbView == null) {
            return null;
        }
        ViewParent parent = rtcWbView.getParent();
        return parent != null ? (PanoCoursePageView)parent : null;
    }

    public static void setNativeHandle(long handle) {
        mNativeHandle = handle;
    }

    public static void open(String pageId, String url, long nativeHandle) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.open(pageId, mNativeHandle, url);
        }
    }

    public static void show(String pageId) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.show(pageId);
        }
    }

    public static void hide(String pageId) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.hide(pageId);
        }
    }

    public static void close(String pageId) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.close(pageId);
        }
    }

    public static void resize(String pageId, int width, int height) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.resize(width, height);
        }
    }

    public static void evaluateJavaScript(String pageId, String javascript) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.evaluateJavaScript(pageId, javascript);
        }
    }

    public static void scaleAtPoint(String pageId, float scale, float x, float y) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.scaleAtPoint(pageId, scale, x, y);
        }
    }

    public static void move(String pageId, float dx, float dy) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.move(pageId, dx, dy);
        }
    }

    public static void snapshot(String pageId, String filePath, boolean viewArea, int contentW, int contentH) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.snapShot(pageId, filePath, viewArea, contentW, contentH);
        }
    }

    public static void openMedia(String shapeId, String url, long nativeHandle) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(shapeId);
        if (panoCoursePageView != null) {
            panoCoursePageView.openMedia(shapeId, mNativeHandle, url);
        }
    }

    public static void showMedia(String shapeId) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(shapeId);
        if (panoCoursePageView != null) {
            panoCoursePageView.showMedia(shapeId);
        }
    }

    public static void hideMedia(String shapeId) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(shapeId);
        if (panoCoursePageView != null) {
            panoCoursePageView.hideMedia(shapeId);
        }
    }

    public static void closeMedia(String shapeId) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(shapeId);
        if (panoCoursePageView != null) {
            panoCoursePageView.closeMedia(shapeId);
        }
    }

    public static void stopMedia(String shapeId) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(shapeId);
        if (panoCoursePageView != null) {
            panoCoursePageView.stopMedia(shapeId);
        }
    }

    public static void updateRgn(String shapeId, float left, float top, float right, float bottom) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(shapeId);
        if (panoCoursePageView != null) {
            panoCoursePageView.updateMediaRgn(shapeId, left, top, right, bottom);
        }
    }

    public static void updatePlayerStatus(String shapeId, boolean isPlay, float playTS, boolean isRepeat) {
        PanoCoursePageView panoCoursePageView = PanoCoursePageFactory.getPanoCoursePageViewById(shapeId);
        if (panoCoursePageView != null) {
            panoCoursePageView.updateMediaStatus(shapeId, isPlay, playTS, isRepeat);
        }
    }

    public static native void onUrlChange(long var0, String var2, String var3);

    public static native void onSnapshotComplete(long var0, String var2, String var3);
}

