/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import com.pano.rtc.api.Constants;
import com.pano.rtc.api.PanoAnnotation;
import com.pano.rtc.api.PanoAnnotationManager;
import com.pano.rtc.impl.PanoAnnoMgrCallbackImpl;
import com.pano.rtc.impl.PanoExternalAnnotationImpl;
import com.pano.rtc.impl.PanoShareAnnotationImpl;
import com.pano.rtc.impl.PanoVideoAnnotationImpl;
import java.util.HashMap;
import java.util.Map;
import video.pano.rtc.impl.PLogger;

public class PanoAnnotationMgrImpl
implements PanoAnnotationManager,
PanoAnnoMgrCallbackImpl {
    private static final String TAG = "[pano]";
    private static final String kAnnotationIdPrefix = "pano-annotation-ext-";
    private long mNativeHandle;
    private PanoAnnotationManager.Callback mCallback;
    private final Map<String, PanoVideoAnnotationImpl> mVideoAnnoMap;
    private final Map<String, PanoShareAnnotationImpl> mShareAnnoMap;
    private final Map<String, PanoExternalAnnotationImpl> mExternalAnnoMap;

    public PanoAnnotationMgrImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        this.mVideoAnnoMap = new HashMap<String, PanoVideoAnnotationImpl>();
        this.mShareAnnoMap = new HashMap<String, PanoShareAnnotationImpl>();
        this.mExternalAnnoMap = new HashMap<String, PanoExternalAnnotationImpl>();
    }

    void destroy() {
        for (PanoVideoAnnotationImpl panoVideoAnnotationImpl : this.mVideoAnnoMap.values()) {
            panoVideoAnnotationImpl.destroy();
        }
        this.mVideoAnnoMap.clear();
        for (PanoShareAnnotationImpl panoShareAnnotationImpl : this.mShareAnnoMap.values()) {
            panoShareAnnotationImpl.destroy();
        }
        this.mShareAnnoMap.clear();
        for (PanoExternalAnnotationImpl panoExternalAnnotationImpl : this.mExternalAnnoMap.values()) {
            panoExternalAnnotationImpl.destroy();
        }
        this.mExternalAnnoMap.clear();
        this.mNativeHandle = 0L;
    }

    @Override
    public Constants.QResult setCallback(PanoAnnotationManager.Callback callback) {
        this.mCallback = callback;
        this.AnnoMgrSetCallback(this.mNativeHandle, this);
        return Constants.QResult.OK;
    }

    @Override
    public PanoAnnotation getVideoAnnotation(long userId, int streamId) {
        String annotationId = userId + "-" + streamId;
        PanoVideoAnnotationImpl annotation = this.mVideoAnnoMap.get(annotationId);
        if (null == annotation) {
            annotation = new PanoVideoAnnotationImpl(this.mNativeHandle, userId, streamId);
            this.mVideoAnnoMap.put(annotationId, annotation);
        }
        return annotation;
    }

    @Override
    public PanoAnnotation getShareAnnotation(long userId) {
        String annotationId = String.valueOf(userId);
        PanoShareAnnotationImpl annotation = this.mShareAnnoMap.get(annotationId);
        if (null == annotation) {
            annotation = new PanoShareAnnotationImpl(this.mNativeHandle, userId);
            this.mShareAnnoMap.put(annotationId, annotation);
        }
        return annotation;
    }

    @Override
    public PanoAnnotation getExternalAnnotation(String annotationId) {
        if (!annotationId.startsWith(kAnnotationIdPrefix)) {
            return null;
        }
        PanoExternalAnnotationImpl annotation = this.mExternalAnnoMap.get(annotationId);
        if (null == annotation) {
            annotation = new PanoExternalAnnotationImpl(this.mNativeHandle, annotationId);
            this.mExternalAnnoMap.put(annotationId, annotation);
        }
        return annotation;
    }

    @Override
    public void onVideoAnnotationStart(long userId, int streamId) {
        PLogger.i(TAG, "PanoAnnotationMgrImpl.onVideoAnnotationStart " + userId + ", " + streamId);
        if (this.mCallback != null) {
            this.mCallback.onVideoAnnotationStart(userId, streamId);
        }
    }

    @Override
    public void onVideoAnnotationStop(long userId, int streamId) {
        PLogger.i(TAG, "PanoAnnotationMgrImpl.onVideoAnnotationStop " + userId + ", " + streamId);
        if (this.mCallback != null) {
            this.mCallback.onVideoAnnotationStop(userId, streamId);
        }
    }

    @Override
    public void onShareAnnotationStart(long userId) {
        PLogger.i(TAG, "PanoAnnotationMgrImpl.onShareAnnotationStart " + userId);
        if (this.mCallback != null) {
            this.mCallback.onShareAnnotationStart(userId);
        }
    }

    @Override
    public void onShareAnnotationStop(long userId) {
        PLogger.i(TAG, "PanoAnnotationMgrImpl.onShareAnnotationStop " + userId);
        if (this.mCallback != null) {
            this.mCallback.onShareAnnotationStop(userId);
        }
    }

    @Override
    public void onExternalAnnotationStart(String annotationId) {
        PLogger.i(TAG, "PanoAnnotationMgrImpl.onExternalAnnotationStart " + annotationId);
        if (this.mCallback != null) {
            this.mCallback.onExternalAnnotationStart(annotationId);
        }
    }

    @Override
    public void onExternalAnnotationStop(String annotationId) {
        PLogger.i(TAG, "PanoAnnotationMgrImpl.onExternalAnnotationStop " + annotationId);
        if (this.mCallback != null) {
            this.mCallback.onExternalAnnotationStop(annotationId);
        }
    }

    private native int AnnoMgrSetCallback(long var1, PanoAnnoMgrCallbackImpl var3);
}

