/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.content.Context;
import android.content.SharedPreferences;
import com.pano.rtc.impl.RtcEngineConfigImpl;
import video.pano.rtc.base.annotation.CalledByNative;
import video.pano.rtc.base.annotation.Keep;

class DocshowSettings {
    private final Context mContext;
    private int audioAecType = RtcEngineConfigImpl.RTCAudioAecType.kAudioAecBuiltIn.getValue();
    private int audioSoftAecType = RtcEngineConfigImpl.RTCAudioSoftwareAecType.kAudioSoftwareAecDefault.getValue();
    private int audioAgcType = RtcEngineConfigImpl.RTCAudioAgcType.kAudioAgcDefault.getValue();
    private int audioNsType = RtcEngineConfigImpl.RTCAudioNsType.kAudioNsDefault.getValue();
    private int audioNsLevel = RtcEngineConfigImpl.RTCAudioNsLevel.kAudioNsLvlDefault.getValue();
    private int audioMode = 3;
    private int audioSource = 7;
    private int audioStream = 0;
    private int audioLayer = RtcEngineConfigImpl.RTCAudioLayer.kPlatformDefaultAudio.getValue();
    private int audioNearNG = 0;
    private int audioFarNG = 0;
    private float audioNearPreG = 1.0f;
    private float audioFarPreG = 1.0f;
    private int apmComplexity = 5;
    private String videoHwEncoder = "none";
    private String videoHwDecoder = "none";
    private int av1EncoderSetting = 2;
    private int av1DecoderSetting = 2;
    private int av1CpuFreq = 0;
    private int av1CpuCores = 1;
    private int vDenoise = 1;
    private int vFec = 0;
    private int deviceRating = 0;

    DocshowSettings(Context context) {
        this.mContext = context;
        this.load();
    }

    public DocshowSettings(DocshowSettings other) {
        this.mContext = other.mContext;
        this.audioAecType = other.audioAecType;
        this.audioSoftAecType = other.audioSoftAecType;
        this.audioAgcType = other.audioAgcType;
        this.audioNsType = other.audioNsType;
        this.audioNsLevel = other.audioNsLevel;
        this.audioMode = other.audioMode;
        this.audioSource = other.audioSource;
        this.audioStream = other.audioStream;
        this.audioLayer = other.audioLayer;
        this.audioNearNG = other.audioNearNG;
        this.audioFarNG = other.audioFarNG;
        this.audioNearPreG = other.audioNearPreG;
        this.audioFarPreG = other.audioFarPreG;
        this.apmComplexity = other.apmComplexity;
        this.videoHwEncoder = other.videoHwEncoder;
        this.videoHwDecoder = other.videoHwDecoder;
        this.av1EncoderSetting = other.av1EncoderSetting;
        this.av1DecoderSetting = other.av1DecoderSetting;
        this.av1CpuFreq = other.av1CpuFreq;
        this.av1CpuCores = other.av1CpuCores;
        this.vDenoise = other.vDenoise;
        this.vFec = other.vFec;
        this.deviceRating = other.deviceRating;
    }

    private void load() {
        SharedPreferences sp = this.mContext.getSharedPreferences("PanoDocshow", 0);
        this.audioAecType = sp.getInt("AudioAecType", RtcEngineConfigImpl.RTCAudioAecType.kAudioAecDefault.getValue());
        this.audioSoftAecType = sp.getInt("AudioSoftAecType", RtcEngineConfigImpl.RTCAudioSoftwareAecType.kAudioSoftwareAecDefault.getValue());
        this.audioAgcType = sp.getInt("AudioAgcType", RtcEngineConfigImpl.RTCAudioAgcType.kAudioAgcDefault.getValue());
        this.audioNsType = sp.getInt("AudioNsType", RtcEngineConfigImpl.RTCAudioNsType.kAudioNsDefault.getValue());
        this.audioNsLevel = sp.getInt("AudioNsLevel", RtcEngineConfigImpl.RTCAudioNsLevel.kAudioNsLvlDefault.getValue());
        this.audioMode = sp.getInt("AudioMode", 3);
        this.audioSource = sp.getInt("AudioSource", 7);
        this.audioStream = sp.getInt("AudioStream", 0);
        this.audioLayer = sp.getInt("AudioLayer", RtcEngineConfigImpl.RTCAudioLayer.kPlatformDefaultAudio.getValue());
        this.audioNearNG = sp.getInt("AudioNearNG", 0);
        this.audioFarNG = sp.getInt("AudioFarNG", 0);
        this.audioNearPreG = sp.getFloat("AudioNearPreG", 0.0f);
        this.audioFarPreG = sp.getFloat("AudioFarPreG", 0.0f);
        this.apmComplexity = sp.getInt("apmComplexity", 5);
        this.videoHwEncoder = sp.getString("VideoHwEncoder", "none");
        this.videoHwDecoder = sp.getString("VideoHwDecoder", "none");
        this.av1EncoderSetting = sp.getInt("Av1EncoderSetting", 1);
        this.av1DecoderSetting = sp.getInt("Av1DecoderSetting", 1);
        this.av1CpuFreq = sp.getInt("Av1CpuFreq", 0);
        this.av1CpuCores = sp.getInt("Av1CpuCores", 1);
        this.vDenoise = sp.getInt("VDenoise", 1);
        this.vFec = sp.getInt("VFec", 0);
        this.deviceRating = sp.getInt("DeviceRating", 0);
    }

    void store() {
        SharedPreferences sp = this.mContext.getSharedPreferences("PanoDocshow", 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt("AudioAecType", this.audioAecType);
        editor.putInt("AudioSoftAecType", this.audioSoftAecType);
        editor.putInt("AudioAgcType", this.audioAgcType);
        editor.putInt("AudioNsType", this.audioNsType);
        editor.putInt("AudioNsLevel", this.audioNsLevel);
        editor.putInt("AudioMode", this.audioMode);
        editor.putInt("AudioSource", this.audioSource);
        editor.putInt("AudioStream", this.audioStream);
        editor.putInt("AudioLayer", this.audioLayer);
        editor.putInt("AudioNearNG", this.audioNearNG);
        editor.putInt("AudioFarNG", this.audioFarNG);
        editor.putFloat("AudioNearPreG", this.audioNearPreG);
        editor.putFloat("AudioFarPreG", this.audioFarPreG);
        editor.putInt("apmComplexity", this.apmComplexity);
        editor.putString("VideoHwEncoder", this.videoHwEncoder);
        editor.putString("VideoHwDecoder", this.videoHwDecoder);
        editor.putInt("Av1EncoderSetting", this.av1EncoderSetting);
        editor.putInt("Av1DecoderSetting", this.av1DecoderSetting);
        editor.putInt("Av1CpuFreq", this.av1CpuFreq);
        editor.putInt("Av1CpuCores", this.av1CpuCores);
        editor.putInt("VDenoise", this.vDenoise);
        editor.putInt("VFec", this.vFec);
        editor.putInt("DeviceRating", this.deviceRating);
        editor.apply();
    }

    @Keep
    @CalledByNative
    public int getAudioAecType() {
        return this.audioAecType;
    }

    @Keep
    @CalledByNative
    public int getAudioSoftAecType() {
        return this.audioSoftAecType;
    }

    @Keep
    @CalledByNative
    public int getAudioAgcType() {
        return this.audioAgcType;
    }

    @Keep
    @CalledByNative
    public int getAudioNsType() {
        return this.audioNsType;
    }

    @Keep
    @CalledByNative
    public int getAudioNsLevel() {
        return this.audioNsLevel;
    }

    @Keep
    @CalledByNative
    public int getAudioMode() {
        return this.audioMode;
    }

    @Keep
    @CalledByNative
    public int getAudioSource() {
        return this.audioSource;
    }

    @Keep
    @CalledByNative
    public int getAudioStream() {
        return this.audioStream;
    }

    @Keep
    @CalledByNative
    public int getAudioLayer() {
        return this.audioLayer;
    }

    @Keep
    @CalledByNative
    public int getAudioNearNG() {
        return this.audioNearNG;
    }

    @Keep
    @CalledByNative
    public int getAudioFarNG() {
        return this.audioFarNG;
    }

    @Keep
    @CalledByNative
    public float getAudioNearPreG() {
        return this.audioNearPreG;
    }

    @Keep
    @CalledByNative
    public float getAudioFarPreG() {
        return this.audioFarPreG;
    }

    @Keep
    @CalledByNative
    public int getApmComplexity() {
        return this.apmComplexity;
    }

    @Keep
    @CalledByNative
    String getVideoHwEncoderFlag() {
        return this.videoHwEncoder;
    }

    @Keep
    @CalledByNative
    String getVideoHwDecoderFlag() {
        return this.videoHwDecoder;
    }

    @Keep
    @CalledByNative
    int getAv1EncoderSetting() {
        return this.av1EncoderSetting;
    }

    @Keep
    @CalledByNative
    int getAv1DecoderSetting() {
        return this.av1DecoderSetting;
    }

    @Keep
    @CalledByNative
    int getAv1CpuFreq() {
        return this.av1CpuFreq;
    }

    @Keep
    @CalledByNative
    int getAv1CpuCores() {
        return this.av1CpuCores;
    }

    @Keep
    @CalledByNative
    public int getVDenoise() {
        return this.vDenoise;
    }

    @Keep
    @CalledByNative
    public int getVFec() {
        return this.vFec;
    }

    @Keep
    @CalledByNative
    public int getDeviceRating() {
        return this.deviceRating;
    }

    void setAudioAecType(int aecType) {
        this.audioAecType = aecType;
    }

    void setAudioSoftAecType(int aecType) {
        this.audioSoftAecType = aecType;
    }

    void setAudioAgcType(int agcType) {
        this.audioAgcType = agcType;
    }

    void setAudioNsType(int nsType) {
        this.audioNsType = nsType;
    }

    void setAudioNsLevel(int nsLevel) {
        this.audioNsLevel = nsLevel;
    }

    void setAudioMode(int mode) {
        this.audioMode = mode;
    }

    void setAudioSource(int source) {
        this.audioSource = source;
    }

    void setAudioStream(int stream) {
        this.audioStream = stream;
    }

    void setAudioLayer(int layer) {
        this.audioLayer = layer;
    }

    void setAudioNearNG(int ng) {
        this.audioNearNG = ng;
    }

    void setAudioFarNG(int ng) {
        this.audioFarNG = ng;
    }

    void setAudioNearPreG(float g) {
        this.audioNearPreG = g;
    }

    void setAudioFarPreG(float g) {
        this.audioFarPreG = g;
    }

    void setApmComplexity(int complexity) {
        this.apmComplexity = complexity;
    }

    void setVideoHwEncoderFlag(String flag) {
        this.videoHwEncoder = flag;
    }

    void setVideoHwDecoderFlag(String flag) {
        this.videoHwDecoder = flag;
    }

    void setAv1EncoderSetting(int encSetting) {
        this.av1EncoderSetting = encSetting;
    }

    void setAv1DecoderSetting(int decSetting) {
        this.av1DecoderSetting = decSetting;
    }

    void setAv1CpuFreq(int freq) {
        this.av1CpuFreq = freq;
    }

    void setAv1CpuCores(int cores) {
        this.av1CpuCores = cores;
    }

    void setVDenoise(int denoise) {
        this.vDenoise = denoise;
    }

    void setVFec(int fec) {
        this.vFec = fec;
    }

    void setDeviceRating(int rating) {
        this.deviceRating = rating;
    }
}

