/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.api;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;

public class RtcWbView
extends SurfaceView
implements SurfaceHolder.Callback {
    private boolean mIsReady = false;
    private boolean mPassThrough = false;
    private Callback mCallback;
    private View.OnTouchListener mUserTouchListener;
    private View.OnTouchListener mRtcTouchListener;

    public RtcWbView(Context context) {
        super(context);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public RtcWbView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public boolean isViewReady() {
        return this.mIsReady;
    }

    public void addCallback(Callback cb) {
        this.mCallback = cb;
    }

    public void removeCallback(Callback cb) {
        this.mCallback = null;
    }

    public void setPassThrough(boolean passThrough) {
        this.mPassThrough = passThrough;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        if (!this.mIsReady) {
            this.mIsReady = true;
            if (this.mCallback != null) {
                this.mCallback.onViewReady(w, h);
            }
        } else if (this.mCallback != null) {
            this.mCallback.onViewSizeChanged(w, h);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mIsReady = false;
        if (this.mCallback != null) {
            this.mCallback.onViewDestroyed();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mPassThrough) {
            return false;
        }
        boolean handled = false;
        if (this.mUserTouchListener != null && this.mUserTouchListener.onTouch((View)this, event)) {
            handled = true;
        }
        super.onTouchEvent(event);
        if (this.mRtcTouchListener != null && this.mRtcTouchListener.onTouch((View)this, event)) {
            handled = true;
        }
        return handled;
    }

    public void setOnTouchListener(View.OnTouchListener listener) {
        this.mUserTouchListener = listener;
    }

    public void setRtcTouchListener(View.OnTouchListener listener) {
        this.mRtcTouchListener = listener;
    }

    public void setTransparent(boolean enable) {
        if (enable) {
            this.setZOrderOnTop(true);
            this.getHolder().setFormat(-2);
        }
    }

    public static interface Callback {
        public void onViewReady(int var1, int var2);

        public void onViewSizeChanged(int var1, int var2);

        public void onViewDestroyed();
    }
}

