/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.api;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.pano.rtc.api.IVideoRender;
import com.pano.rtc.impl.RtcEngineImpl;
import video.pano.EglBase;
import video.pano.GlRectDrawer;
import video.pano.RendererCommon;
import video.pano.rtc.impl.EglSharedContextHelper;
import video.pano.rtc.render.SurfaceViewRenderer;

public class RtcView
extends SurfaceViewRenderer
implements IVideoRender {
    private IVideoRender.ScalingType mScaleType = IVideoRender.ScalingType.SCALE_ASPECT_FIT;
    private boolean mMirror = false;
    private View.OnTouchListener mUserTouchListener;
    private View.OnTouchListener mRtcTouchListener;

    public RtcView(Context context) {
        super(context);
    }

    public RtcView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void init(RendererCommon.RendererEvents rendererEvents) {
        RtcEngineImpl.initNativeLibs();
        this.init(EglSharedContextHelper.getEglSharedContext(), rendererEvents, EglBase.CONFIG_PLAIN, (RendererCommon.GlDrawer)new GlRectDrawer());
        this.setScalingType(this.mScaleType);
    }

    @Override
    public void setScalingType(IVideoRender.ScalingType type) {
        RendererCommon.ScalingType renderScaling;
        this.mScaleType = type;
        switch (type) {
            case SCALE_ASPECT_FIT: {
                renderScaling = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
                break;
            }
            case SCALE_ASPECT_FILL: {
                renderScaling = RendererCommon.ScalingType.SCALE_ASPECT_FILL;
                break;
            }
            case SCALE_ASPECT_BALANCED: {
                renderScaling = RendererCommon.ScalingType.SCALE_ASPECT_BALANCED;
                break;
            }
            case SCALE_ASPECT_ADJUST: {
                renderScaling = RendererCommon.ScalingType.SCALE_ASPECT_ADJUST;
                break;
            }
            default: {
                renderScaling = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
            }
        }
        super.setScalingType(renderScaling);
    }

    @Override
    public void setMirror(boolean mirror) {
        this.mMirror = mirror;
        super.setMirror(mirror);
    }

    @Override
    public void setScalingRatioWithFocus(float ratio, int x, int y) {
        if (ratio == 0.0f) {
            return;
        }
        ratio = 1.0f / ratio;
        super.setScalingRatioWithFocus(ratio, x, y);
    }

    @Override
    public void setScalingRatio(IVideoRender.ScalingRatio ratio) {
        RendererCommon.ScalingRatio renderRatio;
        switch (ratio) {
            case SCALE_RATIO_FIT: {
                renderRatio = RendererCommon.ScalingRatio.SCALE_RATIO_FIT;
                break;
            }
            case SCALE_RATIO_ORIGINAL: {
                renderRatio = RendererCommon.ScalingRatio.SCALE_RATIO_ORIGINAL;
                break;
            }
            default: {
                renderRatio = RendererCommon.ScalingRatio.SCALE_RATIO_NONE;
            }
        }
        super.setScalingRatio(renderRatio);
    }

    @Override
    public void setMovingDistance(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        super.setMovingDistance(dx, dy);
    }

    @Override
    public IVideoRender.ScalingType getScalingType() {
        return this.mScaleType;
    }

    @Override
    public boolean getMirror() {
        return this.mMirror;
    }

    @Override
    public void release() {
        super.release();
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean handled = false;
        if (this.mUserTouchListener != null && this.mUserTouchListener.onTouch((View)this, event)) {
            handled = true;
        }
        super.onTouchEvent(event);
        if (this.mRtcTouchListener != null && this.mRtcTouchListener.onTouch((View)this, event)) {
            handled = true;
        }
        return handled;
    }

    public void setOnTouchListener(View.OnTouchListener listener) {
        this.mUserTouchListener = listener;
    }

    public void setRtcTouchListener(View.OnTouchListener listener) {
        this.mRtcTouchListener = listener;
    }
}

