/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.api;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.pano.rtc.api.PanoExoPlayerView;
import com.pano.rtc.api.PanoWebView;
import com.pano.rtc.api.RtcWbView;
import java.io.File;
import video.pano.rtc.impl.PLogger;

public class PanoCoursePageView
extends FrameLayout {
    private static final String TAG = "PanoCoursePageView";
    private final RtcWbView mRtcWbView;

    public PanoCoursePageView(Context context) {
        this(context, null);
    }

    public PanoCoursePageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mRtcWbView = new RtcWbView(context, attrs);
        this.addView((View)this.mRtcWbView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public RtcWbView getAttachRtcWbView() {
        return this.mRtcWbView;
    }

    public void open(String pageId, long nativeHandle, String url) {
        this.post(() -> {
            PanoWebView panoWebView = new PanoWebView(this.getContext());
            panoWebView.setPageId(pageId);
            this.addView((View)panoWebView, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            panoWebView.loadUrl(url);
            panoWebView.setNativeHandle(nativeHandle);
            PLogger.i(TAG, "open " + pageId);
        });
    }

    public void hide(String pageId) {
        this.post(() -> {
            PanoWebView panoWebView = this.getWebViewById(pageId);
            if (panoWebView != null) {
                panoWebView.setVisibility(8);
                PLogger.i(TAG, "hide " + pageId);
            }
        });
    }

    public void show(String pageId) {
        this.post(() -> {
            PanoWebView panoWebView = this.getWebViewById(pageId);
            if (panoWebView != null) {
                this.removeView((View)panoWebView);
                this.addView((View)panoWebView, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                panoWebView.setVisibility(0);
                PLogger.i(TAG, "show " + pageId);
            }
        });
    }

    public void close(String pageId) {
        this.post(() -> {
            PanoWebView panoWebView = this.getWebViewById(pageId);
            if (panoWebView != null) {
                panoWebView.close();
                this.removeView((View)panoWebView);
                PLogger.i(TAG, "close " + pageId);
            }
        });
    }

    public void resize(int width, int height) {
        this.post(() -> {
            ViewGroup.LayoutParams params = this.getLayoutParams();
            params.width = width;
            params.height = height;
            this.setLayoutParams(params);
        });
    }

    public void evaluateJavaScript(String pageId, String javascript) {
        this.post(() -> {
            PanoWebView panoWebView = this.getWebViewById(pageId);
            if (panoWebView != null) {
                panoWebView.evaluateJavascript(javascript, null);
            }
        });
    }

    public void scaleAtPoint(String pageId, float scale, float x, float y) {
        PanoWebView panoWebView = this.getWebViewById(pageId);
        if (panoWebView != null) {
            panoWebView.scaleAtPoint(scale, x, y);
        }
    }

    public void move(String pageId, float dx, float dy) {
        PanoWebView panoWebView = this.getWebViewById(pageId);
        if (panoWebView != null) {
            panoWebView.move(-dx, -dy);
        }
    }

    public void snapShot(String pageId, String filePath, boolean viewArea, int contentW, int contentH) {
        PanoWebView panoWebView = this.getWebViewById(pageId);
        if (panoWebView != null) {
            panoWebView.snapshot(filePath + File.separator + "whiteboard_snapshot_" + pageId + ".jpg", viewArea, contentW, contentH);
        }
    }

    public void openMedia(String shapeId, long nativeHandle, String url) {
        this.post(() -> {
            PanoExoPlayerView panoMediaPlayerView = new PanoExoPlayerView(this.getContext());
            panoMediaPlayerView.setShapeId(shapeId);
            panoMediaPlayerView.setBackgroundColor(-16777216);
            this.addView((View)panoMediaPlayerView, -1, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            panoMediaPlayerView.setMediaUrl(url);
            panoMediaPlayerView.setNativeHandle(nativeHandle);
            PLogger.i(TAG, "openMedia " + shapeId);
        });
    }

    public void hideMedia(String shapeId) {
        this.post(() -> {
            PanoExoPlayerView panoMediaPlayerView = this.getMediaPlayerViewById(shapeId);
            if (panoMediaPlayerView != null) {
                panoMediaPlayerView.setVisibility(8);
                PLogger.i(TAG, "hideMedia " + shapeId);
            }
        });
    }

    public void showMedia(String shapeId) {
        this.post(() -> {
            PanoExoPlayerView panoMediaPlayerView = this.getMediaPlayerViewById(shapeId);
            if (panoMediaPlayerView != null) {
                this.removeView((View)panoMediaPlayerView);
                this.addView((View)panoMediaPlayerView, -1, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                panoMediaPlayerView.setVisibility(0);
                PLogger.i(TAG, "showMedia " + shapeId);
            }
        });
    }

    public void closeMedia(String shapeId) {
        PLogger.i(TAG, "closeMedia " + shapeId);
        this.post(() -> {
            PanoExoPlayerView panoMediaPlayerView = this.getMediaPlayerViewById(shapeId);
            if (panoMediaPlayerView != null) {
                panoMediaPlayerView.close();
                this.removeView((View)panoMediaPlayerView);
                PLogger.i(TAG, "closeMedia " + shapeId);
            }
        });
    }

    public void stopMedia(String shapeId) {
        PLogger.i(TAG, "stopMedia " + shapeId);
        this.post(() -> {
            PanoExoPlayerView panoMediaPlayerView = this.getMediaPlayerViewById(shapeId);
            if (panoMediaPlayerView != null) {
                panoMediaPlayerView.stopPlay();
                PLogger.i(TAG, "stopMedia " + shapeId);
            }
        });
    }

    public void updateMediaRgn(String shapeId, float left, float top, float right, float bottom) {
        this.post(() -> {
            PanoExoPlayerView panoMediaPlayerView = this.getMediaPlayerViewById(shapeId);
            if (panoMediaPlayerView != null) {
                ViewGroup.LayoutParams params = panoMediaPlayerView.getLayoutParams();
                if (params instanceof FrameLayout.LayoutParams) {
                    FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)params;
                    lp.leftMargin = (int)left;
                    lp.topMargin = (int)top;
                    lp.width = (int)(right - left);
                    lp.height = (int)(bottom - top);
                    panoMediaPlayerView.setLayoutParams((ViewGroup.LayoutParams)lp);
                }
                panoMediaPlayerView.updateSize();
            }
        });
    }

    public void updateMediaStatus(String shapeId, boolean isPlay, float playTS, boolean isRepeat) {
        this.post(() -> {
            PanoExoPlayerView panoMediaPlayerView = this.getMediaPlayerViewById(shapeId);
            if (panoMediaPlayerView != null) {
                panoMediaPlayerView.updatePlayerStatus(isPlay, playTS, isRepeat);
            }
        });
    }

    private PanoWebView getWebViewById(String pageId) {
        if (TextUtils.isEmpty((CharSequence)pageId)) {
            return null;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            PanoWebView panoWebView;
            View childView = this.getChildAt(i);
            if (!(childView instanceof PanoWebView) || !pageId.equals((panoWebView = (PanoWebView)childView).getPageId())) continue;
            return panoWebView;
        }
        return null;
    }

    private PanoExoPlayerView getMediaPlayerViewById(String shapeId) {
        if (TextUtils.isEmpty((CharSequence)shapeId)) {
            return null;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            PanoExoPlayerView panoMediaPlayerView;
            View childView = this.getChildAt(i);
            if (!(childView instanceof PanoExoPlayerView) || !shapeId.equals((panoMediaPlayerView = (PanoExoPlayerView)childView).getShapeId())) continue;
            return panoMediaPlayerView;
        }
        return null;
    }
}

