/*
 * Decompiled with CFR 0.152.
 */
package video.pano.android.gpuimage.filter;

import android.opengl.GLES20;
import android.opengl.Matrix;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import video.pano.android.gpuimage.filter.GPUImageFilter;

public class GPUImageTransformFilter
extends GPUImageFilter {
    public static final String TRANSFORM_VERTEX_SHADER = "attribute vec4 position;\n attribute vec4 inputTextureCoordinate;\n \n uniform mat4 transformMatrix;\n uniform mat4 orthographicMatrix;\n \n varying vec2 textureCoordinate;\n \n void main()\n {\n     gl_Position = transformMatrix * vec4(position.xyz, 1.0) * orthographicMatrix;\n     textureCoordinate = inputTextureCoordinate.xy;\n }";
    private int transformMatrixUniform;
    private int orthographicMatrixUniform;
    private float[] orthographicMatrix = new float[16];
    private float[] transform3D;
    private boolean ignoreAspectRatio;
    private boolean anchorTopLeft;

    public GPUImageTransformFilter() {
        super(TRANSFORM_VERTEX_SHADER, "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}");
        Matrix.orthoM((float[])this.orthographicMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f);
        this.transform3D = new float[16];
        Matrix.setIdentityM((float[])this.transform3D, (int)0);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.transformMatrixUniform = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"transformMatrix");
        this.orthographicMatrixUniform = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"orthographicMatrix");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setUniformMatrix4f(this.transformMatrixUniform, this.transform3D);
        this.setUniformMatrix4f(this.orthographicMatrixUniform, this.orthographicMatrix);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        if (!this.ignoreAspectRatio) {
            Matrix.orthoM((float[])this.orthographicMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-1.0f * (float)height / (float)width), (float)(1.0f * (float)height / (float)width), (float)-1.0f, (float)1.0f);
            this.setUniformMatrix4f(this.orthographicMatrixUniform, this.orthographicMatrix);
        }
    }

    @Override
    public void onDraw(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        FloatBuffer vertBuffer = cubeBuffer;
        if (!this.ignoreAspectRatio) {
            float[] adjustedVertices = new float[8];
            cubeBuffer.position(0);
            cubeBuffer.get(adjustedVertices);
            float normalizedHeight = (float)this.getOutputHeight() / (float)this.getOutputWidth();
            adjustedVertices[1] = adjustedVertices[1] * normalizedHeight;
            adjustedVertices[3] = adjustedVertices[3] * normalizedHeight;
            adjustedVertices[5] = adjustedVertices[5] * normalizedHeight;
            adjustedVertices[7] = adjustedVertices[7] * normalizedHeight;
            vertBuffer = ByteBuffer.allocateDirect(adjustedVertices.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            vertBuffer.put(adjustedVertices).position(0);
        }
        super.onDraw(textureId, vertBuffer, textureBuffer);
    }

    public void setTransform3D(float[] transform3D) {
        this.transform3D = transform3D;
        this.setUniformMatrix4f(this.transformMatrixUniform, transform3D);
    }

    public float[] getTransform3D() {
        return this.transform3D;
    }

    public void setIgnoreAspectRatio(boolean ignoreAspectRatio) {
        this.ignoreAspectRatio = ignoreAspectRatio;
        if (ignoreAspectRatio) {
            Matrix.orthoM((float[])this.orthographicMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f);
            this.setUniformMatrix4f(this.orthographicMatrixUniform, this.orthographicMatrix);
        } else {
            this.onOutputSizeChanged(this.getOutputWidth(), this.getOutputHeight());
        }
    }

    public boolean ignoreAspectRatio() {
        return this.ignoreAspectRatio;
    }

    public void setAnchorTopLeft(boolean anchorTopLeft) {
        this.anchorTopLeft = anchorTopLeft;
        this.setIgnoreAspectRatio(this.ignoreAspectRatio);
    }

    public boolean anchorTopLeft() {
        return this.anchorTopLeft;
    }
}

