/*
 * Decompiled with CFR 0.152.
 */
package video.pano.android.gpuimage.filter;

import android.graphics.PointF;
import android.opengl.GLES20;
import video.pano.android.gpuimage.filter.GPUImageFilter;

public class GPUImageSphereRefractionFilter
extends GPUImageFilter {
    public static final String SPHERE_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\n\nuniform highp vec2 center;\nuniform highp float radius;\nuniform highp float aspectRatio;\nuniform highp float refractiveIndex;\n\nvoid main()\n{\nhighp vec2 textureCoordinateToUse = vec2(textureCoordinate.x, (textureCoordinate.y * aspectRatio + 0.5 - 0.5 * aspectRatio));\nhighp float distanceFromCenter = distance(center, textureCoordinateToUse);\nlowp float checkForPresenceWithinSphere = step(distanceFromCenter, radius);\n\ndistanceFromCenter = distanceFromCenter / radius;\n\nhighp float normalizedDepth = radius * sqrt(1.0 - distanceFromCenter * distanceFromCenter);\nhighp vec3 sphereNormal = normalize(vec3(textureCoordinateToUse - center, normalizedDepth));\n\nhighp vec3 refractedVector = refract(vec3(0.0, 0.0, -1.0), sphereNormal, refractiveIndex);\n\ngl_FragColor = texture2D(inputImageTexture, (refractedVector.xy + 1.0) * 0.5) * checkForPresenceWithinSphere;     \n}\n";
    private PointF center;
    private int centerLocation;
    private float radius;
    private int radiusLocation;
    private float aspectRatio;
    private int aspectRatioLocation;
    private float refractiveIndex;
    private int refractiveIndexLocation;

    public GPUImageSphereRefractionFilter() {
        this(new PointF(0.5f, 0.5f), 0.25f, 0.71f);
    }

    public GPUImageSphereRefractionFilter(PointF center, float radius, float refractiveIndex) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", SPHERE_FRAGMENT_SHADER);
        this.center = center;
        this.radius = radius;
        this.refractiveIndex = refractiveIndex;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.centerLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"center");
        this.radiusLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"radius");
        this.aspectRatioLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"aspectRatio");
        this.refractiveIndexLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"refractiveIndex");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setAspectRatio(this.aspectRatio);
        this.setRadius(this.radius);
        this.setCenter(this.center);
        this.setRefractiveIndex(this.refractiveIndex);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        this.aspectRatio = (float)height / (float)width;
        this.setAspectRatio(this.aspectRatio);
        super.onOutputSizeChanged(width, height);
    }

    private void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
        this.setFloat(this.aspectRatioLocation, aspectRatio);
    }

    public void setRefractiveIndex(float refractiveIndex) {
        this.refractiveIndex = refractiveIndex;
        this.setFloat(this.refractiveIndexLocation, refractiveIndex);
    }

    public void setCenter(PointF center) {
        this.center = center;
        this.setPoint(this.centerLocation, center);
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.setFloat(this.radiusLocation, radius);
    }
}

