/*
 * Decompiled with CFR 0.152.
 */
package video.pano.android.gpuimage.filter;

import android.annotation.SuppressLint;
import android.opengl.GLES20;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import video.pano.android.gpuimage.GPUImageRenderer;
import video.pano.android.gpuimage.filter.GPUImageFilter;
import video.pano.android.gpuimage.util.Rotation;
import video.pano.android.gpuimage.util.TextureRotationUtil;

public class GPUImageFilterGroup
extends GPUImageFilter {
    private List<GPUImageFilter> filters;
    private List<GPUImageFilter> mergedFilters;
    private int[] frameBuffers;
    private int[] frameBufferTextures;
    private final FloatBuffer glCubeBuffer;
    private final FloatBuffer glTextureBuffer;
    private final FloatBuffer glTextureFlipBuffer;

    public GPUImageFilterGroup() {
        this(null);
    }

    public GPUImageFilterGroup(List<GPUImageFilter> filters) {
        this.filters = filters;
        if (this.filters == null) {
            this.filters = new ArrayList<GPUImageFilter>();
        } else {
            this.updateMergedFilters();
        }
        this.glCubeBuffer = ByteBuffer.allocateDirect(GPUImageRenderer.CUBE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.glCubeBuffer.put(GPUImageRenderer.CUBE).position(0);
        this.glTextureBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.TEXTURE_NO_ROTATION.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.glTextureBuffer.put(TextureRotationUtil.TEXTURE_NO_ROTATION).position(0);
        float[] flipTexture = TextureRotationUtil.getRotation(Rotation.NORMAL, false, true);
        this.glTextureFlipBuffer = ByteBuffer.allocateDirect(flipTexture.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.glTextureFlipBuffer.put(flipTexture).position(0);
    }

    public void addFilter(GPUImageFilter aFilter) {
        if (aFilter == null) {
            return;
        }
        this.filters.add(aFilter);
        this.updateMergedFilters();
    }

    @Override
    public void onInit() {
        super.onInit();
        for (GPUImageFilter filter : this.filters) {
            filter.ifNeedInit();
        }
    }

    @Override
    public void onDestroy() {
        this.destroyFramebuffers();
        for (GPUImageFilter filter : this.filters) {
            filter.destroy();
        }
        super.onDestroy();
    }

    private void destroyFramebuffers() {
        if (this.frameBufferTextures != null) {
            GLES20.glDeleteTextures((int)this.frameBufferTextures.length, (int[])this.frameBufferTextures, (int)0);
            this.frameBufferTextures = null;
        }
        if (this.frameBuffers != null) {
            GLES20.glDeleteFramebuffers((int)this.frameBuffers.length, (int[])this.frameBuffers, (int)0);
            this.frameBuffers = null;
        }
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        int i;
        super.onOutputSizeChanged(width, height);
        if (this.frameBuffers != null) {
            this.destroyFramebuffers();
        }
        int size = this.filters.size();
        for (i = 0; i < size; ++i) {
            this.filters.get(i).onOutputSizeChanged(width, height);
        }
        if (this.mergedFilters != null && this.mergedFilters.size() > 0) {
            size = this.mergedFilters.size();
            this.frameBuffers = new int[size - 1];
            this.frameBufferTextures = new int[size - 1];
            for (i = 0; i < size - 1; ++i) {
                GLES20.glGenFramebuffers((int)1, (int[])this.frameBuffers, (int)i);
                GLES20.glGenTextures((int)1, (int[])this.frameBufferTextures, (int)i);
                GLES20.glBindTexture((int)3553, (int)this.frameBufferTextures[i]);
                GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
                GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
                GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
                GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
                GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
                GLES20.glBindFramebuffer((int)36160, (int)this.frameBuffers[i]);
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.frameBufferTextures[i], (int)0);
                GLES20.glBindTexture((int)3553, (int)0);
                GLES20.glBindFramebuffer((int)36160, (int)0);
            }
        }
    }

    @Override
    @SuppressLint(value={"WrongCall"})
    public void onDraw(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        this.runPendingOnDrawTasks();
        if (!this.isInitialized() || this.frameBuffers == null || this.frameBufferTextures == null) {
            return;
        }
        if (this.mergedFilters != null) {
            int size = this.mergedFilters.size();
            int previousTexture = textureId;
            for (int i = 0; i < size; ++i) {
                boolean isNotLast;
                GPUImageFilter filter = this.mergedFilters.get(i);
                boolean bl = isNotLast = i < size - 1;
                if (isNotLast) {
                    GLES20.glBindFramebuffer((int)36160, (int)this.frameBuffers[i]);
                    GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                }
                if (i == 0) {
                    filter.onDraw(previousTexture, cubeBuffer, textureBuffer);
                } else if (i == size - 1) {
                    filter.onDraw(previousTexture, this.glCubeBuffer, size % 2 == 0 ? this.glTextureFlipBuffer : this.glTextureBuffer);
                } else {
                    filter.onDraw(previousTexture, this.glCubeBuffer, this.glTextureBuffer);
                }
                if (!isNotLast) continue;
                GLES20.glBindFramebuffer((int)36160, (int)0);
                previousTexture = this.frameBufferTextures[i];
            }
        }
    }

    public List<GPUImageFilter> getFilters() {
        return this.filters;
    }

    public List<GPUImageFilter> getMergedFilters() {
        return this.mergedFilters;
    }

    public void updateMergedFilters() {
        if (this.filters == null) {
            return;
        }
        if (this.mergedFilters == null) {
            this.mergedFilters = new ArrayList<GPUImageFilter>();
        } else {
            this.mergedFilters.clear();
        }
        for (GPUImageFilter filter : this.filters) {
            if (filter instanceof GPUImageFilterGroup) {
                ((GPUImageFilterGroup)filter).updateMergedFilters();
                List<GPUImageFilter> filters = ((GPUImageFilterGroup)filter).getMergedFilters();
                if (filters == null || filters.isEmpty()) continue;
                this.mergedFilters.addAll(filters);
                continue;
            }
            this.mergedFilters.add(filter);
        }
    }
}

