/*
 * Decompiled with CFR 0.152.
 */
package video.pano.android.gpuimage.filter;

import android.opengl.GLES20;
import video.pano.android.gpuimage.filter.GPUImageFilter;

public class GPUImageBrightnessFilter
extends GPUImageFilter {
    public static final String BRIGHTNESS_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n \n uniform sampler2D inputImageTexture;\n uniform lowp float brightness;\n \n void main()\n {\n     lowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n     \n     gl_FragColor = vec4((textureColor.rgb + vec3(brightness)), textureColor.w);\n }";
    private int brightnessLocation;
    private float brightness;

    public GPUImageBrightnessFilter() {
        this(0.0f);
    }

    public GPUImageBrightnessFilter(float brightness) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", BRIGHTNESS_FRAGMENT_SHADER);
        this.brightness = brightness;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.brightnessLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"brightness");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setBrightness(this.brightness);
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
        this.setFloat(this.brightnessLocation, this.brightness);
    }
}

