/*
 * Decompiled with CFR 0.152.
 */
package video.pano;

import android.content.Context;
import android.graphics.Matrix;
import android.view.WindowManager;
import video.pano.TextureBufferImpl;
import video.pano.VideoFrame;

interface CameraSession {
    public static final long kNumNanosecsPerSec = 1000000000L;

    public void stop();

    public int setFlash(boolean var1);

    public void setMeteringAreas(float var1, float var2);

    public void setFocusAreas(float var1, float var2);

    public boolean isZoomSupported();

    public float getMaxZoom();

    public float getMinZoom();

    public void setZoom(float var1);

    public float getCurrentZoom();

    public float getExposureCompensationStep();

    public int getMinExposureCompensation();

    public int getMaxExposureCompensation();

    public void setExposureCompensation(int var1);

    public int getCurrentExposureCompensation();

    public static int getDeviceOrientation(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static VideoFrame.TextureBuffer createTextureBufferWithModifiedTransformMatrix(TextureBufferImpl buffer, boolean mirror, int rotation) {
        Matrix transformMatrix = new Matrix();
        transformMatrix.preTranslate(0.5f, 0.5f);
        if (mirror) {
            transformMatrix.preScale(-1.0f, 1.0f);
        }
        transformMatrix.preRotate((float)rotation);
        transformMatrix.preTranslate(-0.5f, -0.5f);
        return buffer.applyTransformMatrix(transformMatrix, buffer.getWidth(), buffer.getHeight());
    }

    public static interface Events {
        public void onCameraOpening();

        public void onCameraError(CameraSession var1, String var2);

        public void onCameraDisconnected(CameraSession var1);

        public void onCameraClosed(CameraSession var1);

        public void onFrameCaptured(CameraSession var1, VideoFrame var2);
    }

    public static interface CreateSessionCallback {
        public void onDone(CameraSession var1);

        public void onFailure(FailureType var1, String var2);
    }

    public static enum FailureType {
        ERROR,
        DISCONNECTED;

    }
}

