/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.impl.whiteboard;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;
import video.pano.rtc.impl.GlobalRef;
import video.pano.rtc.impl.whiteboard.WBTextObject;

public class WBTextDialog
extends Dialog {
    private final Context mContext;
    private EditText mEditText;
    private final int mPositionX;
    private final int mPositionY;
    private final WBTextObject mTextObject;
    private final Point mTextLocation = new Point();
    private boolean mIsEditText = false;
    private static int DY = -1;
    private static final int MAGIC = 81;

    public WBTextDialog(Context context, int x, int y, WBTextObject textObject) {
        super(context);
        this.mContext = context;
        this.mPositionX = x;
        this.mPositionY = y;
        this.mTextObject = textObject;
        this.mIsEditText = textObject.getText() != null;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        final Window dialogWindow = this.getWindow();
        assert (dialogWindow != null);
        float uiTextSize = this.mTextObject.format.size;
        DisplayMetrics metrics = this.mContext.getResources().getDisplayMetrics();
        if (metrics.density > 0.0f) {
            uiTextSize /= metrics.density;
        }
        this.mEditText = new EditText(GlobalRef.applicationContext);
        this.mEditText.setBackground((Drawable)new ColorDrawable(0));
        this.mEditText.setHint((CharSequence)"please enter text");
        this.mEditText.setTextColor(this.mTextObject.format.color);
        this.mEditText.setTextSize(uiTextSize);
        this.mEditText.setText((CharSequence)this.mTextObject.text);
        this.mEditText.setEms(10);
        this.mEditText.setFocusable(true);
        this.mEditText.setImeOptions(6);
        this.mEditText.setInputType(131073);
        this.mEditText.setPadding(0, 0, 0, 80);
        ViewTreeObserver vto = this.mEditText.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                WBTextDialog.this.mEditText.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                int[] loc = new int[2];
                WBTextDialog.this.mEditText.getLocationOnScreen(loc);
                ((WBTextDialog)WBTextDialog.this).mTextLocation.x = loc[0];
                ((WBTextDialog)WBTextDialog.this).mTextLocation.y = loc[1];
                WindowManager.LayoutParams wlp = dialogWindow.getAttributes();
                if (DY == -1) {
                    DY = ((WBTextDialog)WBTextDialog.this).mTextLocation.y - wlp.y;
                }
            }
        });
        this.mEditText.requestFocus();
        this.requestWindowFeature(1);
        dialogWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setContentView((View)this.mEditText);
        dialogWindow.setSoftInputMode(20);
        dialogWindow.clearFlags(2);
        WindowManager.LayoutParams wlp = dialogWindow.getAttributes();
        wlp.gravity = 0x800033;
        wlp.x = this.mPositionX;
        wlp.y = DY != -1 ? this.mPositionY - DY : this.mPositionY - 81;
        wlp.width = -2;
        wlp.height = -2;
        dialogWindow.setAttributes(wlp);
        this.setCanceledOnTouchOutside(true);
    }

    public WBTextObject getTextObject() {
        if (this.mEditText != null && this.mTextObject != null) {
            this.mTextObject.setText(this.mEditText.getText().toString());
            int x = this.mIsEditText ? this.mPositionX : this.mTextLocation.x;
            int y = this.mIsEditText ? this.mPositionY : this.mTextLocation.y;
            int w = this.mEditText.getWidth();
            int h = this.mEditText.getHeight();
            this.mTextObject.setRect(x, y, w, h);
        }
        return this.mTextObject;
    }
}

