/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RtcVideoDeviceManager;
import com.pano.rtc.api.model.RtcDeviceInfo;
import com.pano.rtc.impl.RtcVideoStreamMgrImpl;
import video.pano.CustomizedOrientation;

public class RtcVideoDeviceMgrImpl
implements RtcVideoDeviceManager {
    private static final String TAG = "[pano]";
    private final long mNativeHandle;

    RtcVideoDeviceMgrImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    @Override
    public RtcDeviceInfo[] getCaptureDeviceList() {
        return this.getCaptureDeviceList(this.mNativeHandle);
    }

    @Override
    public Constants.QResult setDeviceOrientation(String deviceId, Integer orientation) {
        String cameraId = RtcVideoStreamMgrImpl.getCameraId(deviceId);
        if (!RtcVideoStreamMgrImpl.verifyCameraId(cameraId)) {
            return Constants.QResult.InvalidArgs;
        }
        int camId = -1;
        try {
            camId = Integer.parseInt(cameraId);
        }
        catch (NumberFormatException e) {
            return Constants.QResult.InvalidArgs;
        }
        return this.setDeviceOrientation(camId, orientation);
    }

    public Constants.QResult setDeviceOrientation(int cameraId, Integer orientation) {
        CustomizedOrientation.setDeviceOrientation((int)cameraId, (Integer)orientation);
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setMirrorCorrection(boolean correction) {
        CustomizedOrientation.setMirrorCorrection((boolean)correction);
        return Constants.QResult.OK;
    }

    private native RtcDeviceInfo[] getCaptureDeviceList(long var1);
}

