/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.view.Surface;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.PanoAnnotation;
import com.pano.rtc.api.RtcWbView;
import com.pano.rtc.impl.PanoAnnoCallbackImpl;
import com.pano.rtc.impl.RtcWbDrawer;
import video.pano.rtc.impl.GlobalRef;

public class PanoVideoAnnotationImpl
implements PanoAnnotation,
PanoAnnoCallbackImpl {
    private long mNativeHandle;
    private final long mUserId;
    private final int mStreamId;
    private RtcWbView mWbView;
    private RtcWbView.Callback mViewCallback;
    private PanoAnnotation.Callback mAnnoCallback;
    private final RtcWbDrawer mWbDrawer;
    private boolean mEnableDrawer;

    PanoVideoAnnotationImpl(long nativeHandle, long userId, int streamId) {
        this.mNativeHandle = nativeHandle;
        this.mUserId = userId;
        this.mStreamId = streamId;
        String wbId = "pano-annotation-video-" + userId + "-" + streamId;
        this.mWbDrawer = new RtcWbDrawer(this.mNativeHandle, wbId, new RtcWbDrawer.Callback(){

            @Override
            public void onActionBegin() {
            }

            @Override
            public void onActionEnd() {
            }
        });
        this.mEnableDrawer = true;
    }

    @Override
    public Constants.QResult setCallback(PanoAnnotation.Callback callback) {
        this.mAnnoCallback = callback;
        this.AnnoSetCallback(this.mNativeHandle, this.mUserId, this.mStreamId, this);
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setRoleType(Constants.WBRoleType role) {
        int ret = this.AnnoSetRoleType(this.mNativeHandle, this.mUserId, this.mStreamId, role.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult startAnnotation(final RtcWbView view) {
        this.mViewCallback = new RtcWbView.Callback(){

            @Override
            public void onViewReady(int w, int h) {
                PanoVideoAnnotationImpl.this.AnnoOpen(PanoVideoAnnotationImpl.this.getNativeHandle(), PanoVideoAnnotationImpl.this.mUserId, PanoVideoAnnotationImpl.this.mStreamId, view.getHolder().getSurface());
            }

            @Override
            public void onViewSizeChanged(int w, int h) {
                PanoVideoAnnotationImpl.this.AnnoUpdateViewSize(PanoVideoAnnotationImpl.this.getNativeHandle(), PanoVideoAnnotationImpl.this.mUserId, PanoVideoAnnotationImpl.this.mStreamId, w, h);
            }

            @Override
            public void onViewDestroyed() {
                PanoVideoAnnotationImpl.this.AnnoClose(PanoVideoAnnotationImpl.this.getNativeHandle(), PanoVideoAnnotationImpl.this.mUserId, PanoVideoAnnotationImpl.this.mStreamId);
            }
        };
        view.addCallback(this.mViewCallback);
        this.mWbView = view;
        this.mWbView.setTransparent(true);
        if (this.mEnableDrawer) {
            this.mWbDrawer.start(GlobalRef.applicationContext, view);
        }
        if (view.isViewReady()) {
            int ret = this.AnnoOpen(this.mNativeHandle, this.mUserId, this.mStreamId, view.getHolder().getSurface());
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult stopAnnotation() {
        if (this.mEnableDrawer) {
            this.mWbDrawer.stop();
        }
        if (this.mWbView != null) {
            this.mWbView.removeCallback(this.mViewCallback);
            this.mViewCallback = null;
            this.mWbView = null;
        }
        if (this.mNativeHandle != 0L) {
            int ret = this.AnnoStop(this.mNativeHandle, this.mUserId, this.mStreamId);
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    long getNativeHandle() {
        return this.mNativeHandle;
    }

    void destroy() {
        this.mNativeHandle = 0L;
    }

    @Override
    public Constants.QResult setVisible(boolean visible) {
        if (this.mWbView != null) {
            if (visible) {
                this.mWbView.setVisibility(0);
            } else {
                this.mWbView.setVisibility(4);
            }
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setToolType(Constants.WBToolType type) {
        if (this.mWbView != null) {
            this.mWbView.setPassThrough(type == Constants.WBToolType.None);
        }
        int ret = this.AnnoSetToolType(this.mNativeHandle, this.mUserId, this.mStreamId, type.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setLineWidth(int size) {
        int ret = this.AnnoSetLineWidth(this.mNativeHandle, this.mUserId, this.mStreamId, size);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setColor(int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >>> 24) / 255.0f;
        return this.setColor(r, g, b, a);
    }

    @Override
    public Constants.QResult setColor(float r, float g, float b, float a) {
        int ret = this.AnnoSetColor(this.mNativeHandle, this.mUserId, this.mStreamId, r, g, b, a);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFontStyle(Constants.WBFontStyle style) {
        int ret = this.AnnoSetFontStyle(this.mNativeHandle, this.mUserId, this.mStreamId, style.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFontSize(int size) {
        int ret = this.AnnoSetFontSize(this.mNativeHandle, this.mUserId, this.mStreamId, size);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult clearContents() {
        int ret = this.AnnoClearContents(this.mNativeHandle, this.mUserId, this.mStreamId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult clearUserContents(long userId) {
        int ret = this.AnnoClearUserContents(this.mNativeHandle, this.mUserId, this.mStreamId, userId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult undo() {
        int ret = this.AnnoUndo(this.mNativeHandle, this.mUserId, this.mStreamId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult redo() {
        int ret = this.AnnoRedo(this.mNativeHandle, this.mUserId, this.mStreamId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult snapshot(String outputDir) {
        int ret = this.AnnoSnapshot(this.mNativeHandle, this.mUserId, this.mStreamId, outputDir);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.WBToolType getToolType() {
        int type = this.AnnoGetToolType(this.mNativeHandle, this.mUserId, this.mStreamId);
        return Constants.WBToolType.valueOf(type);
    }

    @Override
    public void onAnnoRoleChanged(int newRole) {
        if (this.mAnnoCallback != null) {
            this.mAnnoCallback.onAnnoRoleChanged(this.ToWBRoleType(newRole));
        }
    }

    @Override
    public void onSnapshotComplete(int result, String filename) {
        if (this.mAnnoCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mAnnoCallback.onSnapshotComplete(qr, filename);
        }
    }

    @Override
    public Constants.QResult setAspectSize(int w, int h) {
        return Constants.QResult.NotSupported;
    }

    @Override
    public Constants.QResult setScalingMode(PanoAnnotation.AnnoScalingMode mode) {
        return Constants.QResult.NotSupported;
    }

    @Override
    public Constants.QResult enableLocalRender(boolean enable) {
        return Constants.QResult.NotSupported;
    }

    private Constants.WBRoleType ToWBRoleType(int type) {
        Constants.WBRoleType result = Constants.WBRoleType.Attendee;
        for (Constants.WBRoleType val : Constants.WBRoleType.values()) {
            if (val.getValue() != type) continue;
            result = val;
            break;
        }
        return result;
    }

    private native int AnnoSetRoleType(long var1, long var3, int var5, int var6);

    private native int AnnoOpen(long var1, long var3, int var5, Surface var6);

    private native int AnnoUpdateViewSize(long var1, long var3, int var5, int var6, int var7);

    private native int AnnoClose(long var1, long var3, int var5);

    private native int AnnoStop(long var1, long var3, int var5);

    private native int AnnoSetVisible(long var1, long var3, int var5, boolean var6);

    private native int AnnoSetToolType(long var1, long var3, int var5, int var6);

    private native int AnnoGetToolType(long var1, long var3, int var5);

    private native int AnnoSetLineWidth(long var1, long var3, int var5, int var6);

    private native int AnnoSetColor(long var1, long var3, int var5, float var6, float var7, float var8, float var9);

    private native int AnnoSetFontStyle(long var1, long var3, int var5, int var6);

    private native int AnnoSetFontSize(long var1, long var3, int var5, int var6);

    private native int AnnoClearContents(long var1, long var3, int var5);

    private native int AnnoClearUserContents(long var1, long var3, int var5, long var6);

    private native int AnnoUndo(long var1, long var3, int var5);

    private native int AnnoRedo(long var1, long var3, int var5);

    private native int AnnoSnapshot(long var1, long var3, int var5, String var6);

    private native int AnnoSetCallback(long var1, long var3, int var5, PanoAnnoCallbackImpl var6);
}

