/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.view.Surface;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.PanoAnnotation;
import com.pano.rtc.api.RtcWbView;
import com.pano.rtc.impl.PanoAnnoCallbackImpl;
import com.pano.rtc.impl.RtcWbDrawer;
import video.pano.rtc.impl.GlobalRef;

public class PanoExternalAnnotationImpl
implements PanoAnnotation,
PanoAnnoCallbackImpl {
    private long mNativeHandle;
    private final String mAnnotationId;
    private RtcWbView mWbView;
    private RtcWbView.Callback mViewCallback;
    private PanoAnnotation.Callback mAnnoCallback;
    private final RtcWbDrawer mWbDrawer;
    private boolean mEnableDrawer;

    PanoExternalAnnotationImpl(long nativeHandle, String annotationId) {
        this.mNativeHandle = nativeHandle;
        this.mAnnotationId = annotationId;
        this.mWbDrawer = new RtcWbDrawer(this.mNativeHandle, this.mAnnotationId, new RtcWbDrawer.Callback(){

            @Override
            public void onActionBegin() {
            }

            @Override
            public void onActionEnd() {
            }
        });
        this.mEnableDrawer = true;
    }

    @Override
    public Constants.QResult setCallback(PanoAnnotation.Callback callback) {
        this.mAnnoCallback = callback;
        this.AnnoSetCallback(this.mNativeHandle, this.mAnnotationId, this);
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setRoleType(Constants.WBRoleType role) {
        int ret = this.AnnoSetRoleType(this.mNativeHandle, this.mAnnotationId, role.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult startAnnotation(final RtcWbView view) {
        this.mViewCallback = new RtcWbView.Callback(){

            @Override
            public void onViewReady(int w, int h) {
                PanoExternalAnnotationImpl.this.AnnoOpen(PanoExternalAnnotationImpl.this.getNativeHandle(), PanoExternalAnnotationImpl.this.mAnnotationId, view.getHolder().getSurface());
            }

            @Override
            public void onViewSizeChanged(int w, int h) {
                PanoExternalAnnotationImpl.this.AnnoUpdateViewSize(PanoExternalAnnotationImpl.this.getNativeHandle(), PanoExternalAnnotationImpl.this.mAnnotationId, w, h);
            }

            @Override
            public void onViewDestroyed() {
                PanoExternalAnnotationImpl.this.AnnoClose(PanoExternalAnnotationImpl.this.getNativeHandle(), PanoExternalAnnotationImpl.this.mAnnotationId);
            }
        };
        view.addCallback(this.mViewCallback);
        this.mWbView = view;
        this.mWbView.setTransparent(true);
        if (this.mEnableDrawer) {
            this.mWbDrawer.start(GlobalRef.applicationContext, view);
        }
        if (view.isViewReady()) {
            int ret = this.AnnoOpen(this.mNativeHandle, this.mAnnotationId, view.getHolder().getSurface());
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult stopAnnotation() {
        if (this.mEnableDrawer) {
            this.mWbDrawer.stop();
        }
        if (this.mWbView != null) {
            this.mWbView.removeCallback(this.mViewCallback);
            this.mViewCallback = null;
            this.mWbView = null;
        }
        if (this.mNativeHandle != 0L) {
            int ret = this.AnnoStop(this.mNativeHandle, this.mAnnotationId);
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    long getNativeHandle() {
        return this.mNativeHandle;
    }

    void destroy() {
        this.mNativeHandle = 0L;
    }

    @Override
    public Constants.QResult setVisible(boolean visible) {
        if (this.mWbView != null) {
            if (visible) {
                this.mWbView.setVisibility(0);
            } else {
                this.mWbView.setVisibility(4);
            }
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setToolType(Constants.WBToolType type) {
        if (this.mWbView != null) {
            this.mWbView.setPassThrough(type == Constants.WBToolType.None);
        }
        int ret = this.AnnoSetToolType(this.mNativeHandle, this.mAnnotationId, type.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setLineWidth(int size) {
        int ret = this.AnnoSetLineWidth(this.mNativeHandle, this.mAnnotationId, size);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setColor(int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >>> 24) / 255.0f;
        return this.setColor(r, g, b, a);
    }

    @Override
    public Constants.QResult setColor(float r, float g, float b, float a) {
        int ret = this.AnnoSetColor(this.mNativeHandle, this.mAnnotationId, r, g, b, a);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFontStyle(Constants.WBFontStyle style) {
        int ret = this.AnnoSetFontStyle(this.mNativeHandle, this.mAnnotationId, style.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFontSize(int size) {
        int ret = this.AnnoSetFontSize(this.mNativeHandle, this.mAnnotationId, size);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult clearContents() {
        int ret = this.AnnoClearContents(this.mNativeHandle, this.mAnnotationId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult clearUserContents(long userId) {
        int ret = this.AnnoClearUserContents(this.mNativeHandle, this.mAnnotationId, userId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult undo() {
        int ret = this.AnnoUndo(this.mNativeHandle, this.mAnnotationId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult redo() {
        int ret = this.AnnoRedo(this.mNativeHandle, this.mAnnotationId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult snapshot(String outputDir) {
        int ret = this.AnnoSnapshot(this.mNativeHandle, this.mAnnotationId, outputDir);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.WBToolType getToolType() {
        int type = this.AnnoGetToolType(this.mNativeHandle, this.mAnnotationId);
        return Constants.WBToolType.valueOf(type);
    }

    @Override
    public Constants.QResult setAspectSize(int w, int h) {
        int ret = this.AnnoSetAspectSize(this.mNativeHandle, this.mAnnotationId, w, h);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setScalingMode(PanoAnnotation.AnnoScalingMode mode) {
        int ret = this.AnnoSetScalingMode(this.mNativeHandle, this.mAnnotationId, mode.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult enableLocalRender(boolean enable) {
        int ret = this.AnnoEnableLocalRender(this.mNativeHandle, this.mAnnotationId, enable);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public void onAnnoRoleChanged(int newRole) {
        if (this.mAnnoCallback != null) {
            this.mAnnoCallback.onAnnoRoleChanged(this.ToWBRoleType(newRole));
        }
    }

    @Override
    public void onSnapshotComplete(int result, String filename) {
        if (this.mAnnoCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mAnnoCallback.onSnapshotComplete(qr, filename);
        }
    }

    private Constants.WBRoleType ToWBRoleType(int type) {
        Constants.WBRoleType result = Constants.WBRoleType.Attendee;
        for (Constants.WBRoleType val : Constants.WBRoleType.values()) {
            if (val.getValue() != type) continue;
            result = val;
            break;
        }
        return result;
    }

    private native int AnnoSetRoleType(long var1, String var3, int var4);

    private native int AnnoOpen(long var1, String var3, Surface var4);

    private native int AnnoUpdateViewSize(long var1, String var3, int var4, int var5);

    private native int AnnoClose(long var1, String var3);

    private native int AnnoStop(long var1, String var3);

    private native int AnnoSetVisible(long var1, String var3, boolean var4);

    private native int AnnoSetToolType(long var1, String var3, int var4);

    private native int AnnoGetToolType(long var1, String var3);

    private native int AnnoSetLineWidth(long var1, String var3, int var4);

    private native int AnnoSetColor(long var1, String var3, float var4, float var5, float var6, float var7);

    private native int AnnoSetFontStyle(long var1, String var3, int var4);

    private native int AnnoSetFontSize(long var1, String var3, int var4);

    private native int AnnoClearContents(long var1, String var3);

    private native int AnnoClearUserContents(long var1, String var3, long var4);

    private native int AnnoUndo(long var1, String var3);

    private native int AnnoRedo(long var1, String var3);

    private native int AnnoSnapshot(long var1, String var3, String var4);

    private native int AnnoSetAspectSize(long var1, String var3, int var4, int var5);

    private native int AnnoSetScalingMode(long var1, String var3, int var4);

    private native int AnnoEnableLocalRender(long var1, String var3, boolean var4);

    private native int AnnoSetCallback(long var1, String var3, PanoAnnoCallbackImpl var4);
}

