/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.api;

import android.content.Context;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.MediaController;
import video.pano.rtc.impl.PLogger;

public class PanoMediaPlayerView
extends FrameLayout
implements SurfaceHolder.Callback,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnVideoSizeChangedListener,
MediaController.MediaPlayerControl {
    private static final String TAG = "PanoMediaPlayerView";
    private long mNativeHandle;
    private static final Object handleLock = new Object();
    private String mShapeId;
    private final SurfaceView mSurfaceView;
    private final MediaController mediaController;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private boolean mIsPrepared = false;
    private int mSyncTS = 0;
    private static final int SHOW_CONTROLLER = 1;
    private static final int HIDE_CONTROLLER = 2;
    private static final int UPDATE_PROGRESS = 3;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PanoMediaPlayerView.this.mediaController.show();
                    break;
                }
                case 2: {
                    PanoMediaPlayerView.this.mediaController.hide();
                    break;
                }
                case 3: {
                    if (PanoMediaPlayerView.this.mPlayer == null) break;
                    PanoMediaPlayerView.this.updateTime();
                    if (!PanoMediaPlayerView.this.mPlayer.isPlaying()) break;
                    PanoMediaPlayerView.this.mHandler.sendEmptyMessageDelayed(3, 3000L);
                }
            }
        }
    };
    private MediaPlayer mPlayer;
    private String mMediaUrl = "";
    private boolean mIsPlay = false;
    private float mPlayTS = 0.0f;
    private static int kDefaultPlayReseekInterval = 3000;

    public PanoMediaPlayerView(Context context) {
        super(context);
        this.mSurfaceView = new SurfaceView(context);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
        FrameLayout.LayoutParams svParams = new FrameLayout.LayoutParams(-1, -1);
        svParams.gravity = 17;
        this.addView((View)this.mSurfaceView, (ViewGroup.LayoutParams)svParams);
        this.mediaController = new MediaController(context);
        this.mediaController.setAnchorView((View)this);
        this.mediaController.setMediaPlayer((MediaController.MediaPlayerControl)this);
        this.initPlayer();
    }

    public PanoMediaPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mSurfaceView = new SurfaceView(context, attrs);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
        FrameLayout.LayoutParams svParams = new FrameLayout.LayoutParams(-1, -1);
        svParams.gravity = 17;
        this.addView((View)this.mSurfaceView, (ViewGroup.LayoutParams)svParams);
        this.mediaController = new MediaController(context);
        this.mediaController.setAnchorView((View)this);
        this.mediaController.setMediaPlayer((MediaController.MediaPlayerControl)this);
        this.initPlayer();
    }

    private void initPlayer() {
        PLogger.i(TAG, "initPlayer");
        this.mPlayer = new MediaPlayer();
        this.mPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this);
        this.mPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
    }

    public void close() {
        PLogger.i(TAG, "close");
        this.mNativeHandle = 0L;
        if (this.mPlayer != null) {
            this.mPlayer.reset();
            this.mPlayer.release();
            this.mPlayer = null;
        }
    }

    public void stopPlay() {
        PLogger.i(TAG, "stopPlay");
        this.mHandler.removeMessages(3);
        if (this.mPlayer != null) {
            if (this.mPlayer.isPlaying()) {
                this.mPlayer.stop();
            }
            this.mPlayer.reset();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mNativeHandle = 0L;
        this.stopPlay();
        if (this.mPlayer != null) {
            this.mPlayer.reset();
            this.mPlayer.release();
            this.mPlayer = null;
        }
    }

    public void setShapeId(String shapeId) {
        this.mShapeId = shapeId;
    }

    public String getShapeId() {
        return this.mShapeId;
    }

    public void setNativeHandle(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void setMediaUrl(String url) {
        this.mMediaUrl = url;
        try {
            this.mPlayer.setDataSource(this.mMediaUrl);
            this.mPlayer.prepareAsync();
            this.mPlayer.setVideoScalingMode(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        PLogger.i(TAG, "surfaceChanged " + w + "," + h);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        PLogger.i(TAG, "surfaceCreated");
        if (this.mPlayer != null) {
            this.mPlayer.setDisplay(holder);
        }
        this.mSurfaceView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (PanoMediaPlayerView.this.mediaController != null && PanoMediaPlayerView.this.mIsPrepared) {
                    PanoMediaPlayerView.this.mediaController.show();
                }
                return false;
            }
        });
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        PLogger.i(TAG, "surfaceDestroyed");
    }

    public void onPrepared(MediaPlayer mp) {
        PLogger.i(TAG, "onPrepared");
        this.mediaController.setEnabled(true);
        this.mIsPrepared = true;
        this.mHandler.sendEmptyMessage(1);
        if (Build.VERSION.SDK_INT >= 26) {
            this.mPlayer.seekTo((long)this.mSyncTS, 3);
        } else {
            this.mPlayer.seekTo(this.mSyncTS);
        }
        if (this.mIsPlay) {
            this.mPlayer.start();
        }
    }

    public void onCompletion(MediaPlayer mp) {
        PLogger.i(TAG, "onCompletion");
        if (!this.mPlayer.isLooping()) {
            this.mPlayer.pause();
        }
        if (this.mediaController != null) {
            this.mediaController.show(5000);
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        PLogger.i(TAG, "onError " + what + "," + extra);
        return true;
    }

    public void onSeekComplete(MediaPlayer mp) {
        PLogger.i(TAG, "onSeekComplete " + (float)mp.getCurrentPosition() / 1000.0f);
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        PLogger.i(TAG, "onVideoSizeChanged " + width + ", " + height);
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        this.post(() -> this.updateSurfaceViewSize());
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mediaController != null && this.mIsPrepared) {
            this.mediaController.show();
        }
        return false;
    }

    private void updateTime() {
        this.syncPlayerStatus(this.mPlayer.getCurrentPosition());
    }

    public void start() {
        PLogger.i(TAG, "start");
        if (this.mPlayer != null) {
            this.mPlayer.start();
            this.mHandler.sendEmptyMessage(3);
            this.syncPlayerStatus(this.mPlayer.getCurrentPosition());
        }
    }

    public void pause() {
        PLogger.i(TAG, "pause");
        if (this.mPlayer != null) {
            this.mPlayer.pause();
            this.syncPlayerStatus(this.mPlayer.getCurrentPosition());
        }
    }

    public void seekTo(int pos) {
        PLogger.i(TAG, "seekTo");
        if (this.mPlayer != null) {
            this.mPlayer.seekTo(pos);
            this.syncPlayerStatus(this.mPlayer.getCurrentPosition());
        }
    }

    public boolean isPlaying() {
        return this.mPlayer != null ? this.mPlayer.isPlaying() : false;
    }

    public boolean canPause() {
        return true;
    }

    public boolean canSeekBackward() {
        return true;
    }

    public boolean canSeekForward() {
        return true;
    }

    public int getAudioSessionId() {
        return 0;
    }

    public int getDuration() {
        return this.mPlayer != null ? this.mPlayer.getDuration() : 0;
    }

    public int getCurrentPosition() {
        return this.mPlayer != null ? this.mPlayer.getCurrentPosition() : 0;
    }

    public int getBufferPercentage() {
        return 0;
    }

    public void updatePlayerStatus(boolean isPlay, float playTS, boolean isRepeat) {
        PLogger.i(TAG, "updatePlayerStatus " + isPlay + ", ts:" + playTS + ", " + isRepeat);
        this.mIsPlay = isPlay;
        if (!this.mPlayer.isPlaying() && this.mIsPlay) {
            this.mPlayer.start();
        }
        if (this.mPlayer.isPlaying() && !this.mIsPlay) {
            this.mPlayer.pause();
        }
        this.mSyncTS = (int)(playTS * 1000.0f);
        if (this.needSeekToTS(this.mSyncTS, isPlay) && this.mIsPrepared) {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mPlayer.seekTo((long)this.mSyncTS, 3);
            } else {
                this.mPlayer.seekTo(this.mSyncTS);
            }
        }
        this.mPlayer.setLooping(isRepeat);
    }

    public void updateSize(int w, int h) {
        this.updateSurfaceViewSize();
    }

    private boolean needSeekToTS(int playTS, boolean isPlay) {
        int curTS = this.mPlayer.getCurrentPosition();
        if (isPlay) {
            return curTS < playTS - kDefaultPlayReseekInterval || curTS > playTS + kDefaultPlayReseekInterval;
        }
        return true;
    }

    private void syncPlayerStatus(int playTS) {
        PLogger.i(TAG, "syncPlayerStatus " + playTS + "," + this.mPlayer.isPlaying());
        if (!this.mPlayer.isPlaying() && !this.mIsPlay) {
            return;
        }
        this.mIsPlay = this.mPlayer.isPlaying();
        if (this.mNativeHandle != 0L) {
            PanoMediaPlayerView.onSyncPlayerStatus(this.mNativeHandle, this.mShapeId, this.mPlayer.isPlaying(), (float)playTS / 1000.0f, this.mPlayer.isLooping());
        }
    }

    private void updateSurfaceViewSize() {
        if (this.mVideoWidth == 0 || this.mVideoHeight == 0) {
            return;
        }
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        if (this.mVideoWidth * viewHeight > this.mVideoHeight * viewWidth) {
            viewHeight = this.mVideoHeight * viewWidth / this.mVideoWidth;
        } else {
            viewWidth = this.mVideoWidth * viewHeight / this.mVideoHeight;
        }
        ViewGroup.LayoutParams params = this.mSurfaceView.getLayoutParams();
        if (params instanceof FrameLayout.LayoutParams) {
            params.width = viewWidth;
            params.height = viewHeight;
        }
        this.mSurfaceView.setLayoutParams(params);
    }

    public static native void onSyncPlayerStatus(long var0, String var2, boolean var3, float var4, boolean var5);
}

