/*
 * Decompiled with CFR 0.152.
 */
package video.api.rtmpdroid.internal;

import android.os.Build;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lvideo/api/rtmpdroid/internal/ExVideoCodecs;", "", "value", "", "(Ljava/lang/String;)V", "fourCCList", "", "supportedCodecs", "getSupportedCodecs", "()Ljava/util/List;", "getValue", "()Ljava/lang/String;", "hasCodec", "", "mimeType", "Companion", "lib_packedRelease"})
public final class ExVideoCodecs {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String value;
    @NotNull
    private final List<String> fourCCList;
    @NotNull
    private static final String AV1_FOURCC_TAG = "av01";
    @NotNull
    private static final String VP9_FOURCC_TAG = "vp9";
    @NotNull
    private static final String HEVC_FOURCC_TAG = "hvc1";
    @NotNull
    private static final Map<String, String> codecsMap;

    public ExVideoCodecs(@Nullable String value) {
        String[] stringArray;
        this.value = value;
        Object object = this.value;
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) == null || (object = CollectionsKt.toList((Iterable)((Iterable)object))) == null) {
            object = CollectionsKt.emptyList();
        }
        this.fourCCList = object;
        for (String mimeType : this.getSupportedCodecs()) {
            if (Companion.isSupportedCodec(mimeType)) continue;
            throw new IllegalArgumentException("Mimetype " + mimeType + " is not supported by enhanced RTMP protocol");
        }
    }

    @Nullable
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final List<String> getSupportedCodecs() {
        List list = new ArrayList();
        for (Map.Entry<String, String> entry : codecsMap.entrySet()) {
            String mimeType = entry.getKey();
            String fourCC = entry.getValue();
            if (!this.fourCCList.contains(fourCC)) continue;
            list.add(mimeType);
        }
        return list;
    }

    public final boolean hasCodec(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return this.getSupportedCodecs().contains(mimeType);
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)"video/x-vnd.on2.vp9", (Object)VP9_FOURCC_TAG), TuplesKt.to((Object)"video/hevc", (Object)HEVC_FOURCC_TAG)};
        Object $this$codecsMap_u24lambda_u240 = object = MapsKt.mutableMapOf((Pair[])object);
        boolean bl = false;
        if (Build.VERSION.SDK_INT >= 29) {
            $this$codecsMap_u24lambda_u240.put("video/av01", AV1_FOURCC_TAG);
        }
        codecsMap = MapsKt.toMap((Map)object);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lvideo/api/rtmpdroid/internal/ExVideoCodecs$Companion;", "", "()V", "AV1_FOURCC_TAG", "", "HEVC_FOURCC_TAG", "VP9_FOURCC_TAG", "codecsMap", "", "fromMimeTypes", "Lvideo/api/rtmpdroid/internal/ExVideoCodecs;", "mimeTypes", "", "isSupportedCodec", "", "mimeType", "lib_packedRelease"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSupportedCodec(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return codecsMap.containsKey(mimeType);
        }

        @NotNull
        public final ExVideoCodecs fromMimeTypes(@NotNull List<String> mimeTypes) {
            Intrinsics.checkNotNullParameter(mimeTypes, (String)"mimeTypes");
            if (mimeTypes.isEmpty()) {
                return new ExVideoCodecs(null);
            }
            List value = new ArrayList();
            for (String mimeType : mimeTypes) {
                String codec = (String)codecsMap.get(mimeType);
                if (codec != null) {
                    value.add(codec);
                    continue;
                }
                throw new IllegalArgumentException("Mimetype " + mimeType + " is not supported by enhanced RTMP protocol");
            }
            return new ExVideoCodecs(CollectionsKt.joinToString$default((Iterable)value, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

