/*
 * Decompiled with CFR 0.152.
 */
package video.api.uploader.api.work.workers;

import android.content.Context;
import android.util.Log;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.uploader.api.JSON;
import video.api.uploader.api.models.Video;
import video.api.uploader.api.upload.IProgressiveUploadSession;
import video.api.uploader.api.upload.UploadPartProgressListener;
import video.api.uploader.api.work.stores.ProgressiveUploadSessionStore;
import video.api.uploader.api.work.workers.AbstractUploadWorker;
import video.api.uploader.api.work.workers.ProgressiveUploadWorker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lvideo/api/uploader/api/work/workers/ProgressiveUploadWorker;", "Lvideo/api/uploader/api/work/workers/AbstractUploadWorker;", "Lvideo/api/uploader/api/upload/UploadPartProgressListener;", "context", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onProgress", "", "bytesWritten", "", "totalBytes", "Companion", "android-video-uploader_release"})
@SourceDebugExtension(value={"SMAP\nProgressiveUploadWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressiveUploadWorker.kt\nvideo/api/uploader/api/work/workers/ProgressiveUploadWorker\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 Data.kt\nandroidx/work/DataKt\n*L\n1#1,143:1\n314#2,11:144\n31#3,5:155\n31#3,5:160\n31#3,5:165\n*S KotlinDebug\n*F\n+ 1 ProgressiveUploadWorker.kt\nvideo/api/uploader/api/work/workers/ProgressiveUploadWorker\n*L\n71#1:144,11\n91#1:155,5\n98#1:160,5\n102#1:165,5\n*E\n"})
public final class ProgressiveUploadWorker
extends AbstractUploadWorker
implements UploadPartProgressListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "ProgressiveUploadWorker";
    @NotNull
    private static final String SESSION_ID_KEY = "sessionId";
    @NotNull
    private static final String IS_LAST_PART_KEY = "isLastPart";
    @NotNull
    private static final String PART_ID_KEY = "partId";
    private static final int DEFAULT_SESSION_ID = -1;
    private static final int DEFAULT_PART_ID = -1;

    public ProgressiveUploadWorker(@NotNull Context context, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
        super(context, workerParams);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object doWork(@NotNull Continuation<? super ListenableWorker.Result> var1_1) {
        if (!(var1_1 instanceof doWork.1)) ** GOTO lbl-1000
        var17_2 = var1_1;
        if ((var17_2.label & -2147483648) != 0) {
            var17_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                int I$1;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProgressiveUploadWorker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.doWork((Continuation<? super ListenableWorker.Result>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.createNotificationChannel();
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.setForeground(this.createForegroundInfo(this.onUploadStarted()), (Continuation)$continuation);
                if (v0 == var18_4) {
                    return var18_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (ProgressiveUploadWorker)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                sessionIndex = this.getInputData().getInt("sessionId", -1);
                filePath = this.getInputData().getString("filePath");
                isLastPart = this.getInputData().getBoolean("isLastPart", false);
                partId = this.getInputData().getInt("partId", -1);
                if (sessionIndex == -1) {
                    this.createErrorNotification(new IOException("Missing session id"));
                    v1 = ListenableWorker.Result.failure();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"failure(...)");
                    return v1;
                }
                if (filePath == null) {
                    this.createErrorNotification(new IOException("File path not set"));
                    v2 = ListenableWorker.Result.failure();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"failure(...)");
                    return v2;
                }
                file = new File(filePath);
                $i$f$suspendCancellableCoroutine = false;
                $continuation.L$0 = this;
                $continuation.L$1 = filePath;
                $continuation.L$2 = file;
                $continuation.I$0 = sessionIndex;
                $continuation.Z$0 = isLastPart;
                $continuation.I$1 = partId;
                $continuation.label = 2;
                uCont$iv = (Continuation)$continuation;
                $i$a$-suspendCoroutineUninterceptedOrReturn-CancellableContinuationKt$suspendCancellableCoroutine$2$iv = false;
                cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                cancellable$iv.initCancellability();
                continuation = (CancellableContinuation)cancellable$iv;
                $i$a$-suspendCancellableCoroutine-ProgressiveUploadWorker$doWork$video$1 = false;
                future = AbstractUploadWorker.Companion.getUploaderExecutor$android_video_uploader_release().submit(new Runnable(partId, sessionIndex, file, isLastPart != false, this, (CancellableContinuation<? super Video>)continuation){
                    final /* synthetic */ int $partId;
                    final /* synthetic */ int $sessionIndex;
                    final /* synthetic */ File $file;
                    final /* synthetic */ boolean $isLastPart;
                    final /* synthetic */ ProgressiveUploadWorker this$0;
                    final /* synthetic */ CancellableContinuation<Video> $continuation;
                    {
                        this.$partId = $partId;
                        this.$sessionIndex = $sessionIndex;
                        this.$file = $file;
                        this.$isLastPart = $isLastPart;
                        this.this$0 = $receiver;
                        this.$continuation = $continuation;
                    }

                    public final void run() {
                        try {
                            Video video2;
                            if (this.$partId != -1) {
                                IProgressiveUploadSession iProgressiveUploadSession = ProgressiveUploadSessionStore.INSTANCE.get(this.$sessionIndex);
                                Intrinsics.checkNotNull((Object)iProgressiveUploadSession);
                                video2 = iProgressiveUploadSession.uploadPart(this.$file, this.$partId, this.$isLastPart, this.this$0);
                            } else {
                                IProgressiveUploadSession iProgressiveUploadSession = ProgressiveUploadSessionStore.INSTANCE.get(this.$sessionIndex);
                                Intrinsics.checkNotNull((Object)iProgressiveUploadSession);
                                video2 = iProgressiveUploadSession.uploadPart(this.$file, this.$isLastPart, (UploadPartProgressListener)this.this$0);
                            }
                            Video video3 = video2;
                            this.$continuation.resume((Object)video3, null);
                        }
                        catch (Exception e) {
                            ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
                        }
                    }
                });
                continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(future){
                    final /* synthetic */ Future<?> $future;
                    {
                        this.$future = $future;
                        super(1);
                    }

                    public final void invoke(@Nullable Throwable it) {
                        this.$future.cancel(true);
                    }
                });
                v3 = cancellable$iv.getResult();
                if (v3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)$continuation));
                }
                v4 = v3;
                if (v3 == var18_4) {
                    return var18_4;
                }
                ** GOTO lbl81
            }
            case 2: {
                $i$f$suspendCancellableCoroutine = false;
                partId = $continuation.I$1;
                $continuation.Z$0;
                $continuation.I$0;
                (File)$continuation.L$2;
                filePath = (String)$continuation.L$1;
                this = (ProgressiveUploadWorker)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl81:
                    // 2 sources

                    video = (Video)v4;
                    $i$f$suspendCancellableCoroutine = new Pair[]{TuplesKt.to((Object)"filePath", (Object)filePath), TuplesKt.to((Object)"video", (Object)new JSON().serialize(video))};
                    pairs$iv = $i$f$suspendCancellableCoroutine;
                    $i$f$workDataOf = false;
                    dataBuilder$iv = new Data.Builder();
                    for (Pair pair$iv : pairs$iv) {
                        dataBuilder$iv.put((String)pair$iv.getFirst(), pair$iv.getSecond());
                    }
                    v5 = dataBuilder$iv.build();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"dataBuilder.build()");
                    var7_40 = ListenableWorker.Result.success((Data)v5);
                    Intrinsics.checkNotNull((Object)var7_40);
                }
                catch (CancellationException e) {
                    Log.i((String)"ProgressiveUploadWorker", (String)("Upload part " + partId + " cancelled"));
                    $i$f$workDataOf = new Pair[]{TuplesKt.to((Object)"error", (Object)e.getMessage())};
                    pairs$iv = $i$f$workDataOf;
                    $i$f$workDataOf = false;
                    dataBuilder$iv = new Data.Builder();
                    for (Pair pair$iv : pairs$iv) {
                        dataBuilder$iv.put((String)pair$iv.getFirst(), pair$iv.getSecond());
                    }
                    v6 = dataBuilder$iv.build();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"dataBuilder.build()");
                    var9_12 = ListenableWorker.Result.failure((Data)v6);
                    Intrinsics.checkNotNull((Object)var9_12);
                    var7_40 = var9_12;
                }
                catch (Exception e) {
                    Log.e((String)"ProgressiveUploadWorker", (String)("Upload part " + partId + " failed"), (Throwable)e);
                    this.createErrorNotification(e);
                    pairs$iv = new Pair[]{TuplesKt.to((Object)"error", (Object)e.getMessage())};
                    $i$f$workDataOf = false;
                    dataBuilder$iv = new Data.Builder();
                    for (Pair pair$iv : pairs$iv) {
                        dataBuilder$iv.put((String)pair$iv.getFirst(), pair$iv.getSecond());
                    }
                    v7 = dataBuilder$iv.build();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"dataBuilder.build()");
                    var9_13 = ListenableWorker.Result.failure((Data)v7);
                    Intrinsics.checkNotNull((Object)var9_13);
                    var7_40 = var9_13;
                }
                return var7_40;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void onProgress(long bytesWritten, long totalBytes) {
        this.updateProgress((int)(bytesWritten * (long)100 / totalBytes));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lvideo/api/uploader/api/work/workers/ProgressiveUploadWorker$Companion;", "", "()V", "DEFAULT_PART_ID", "", "DEFAULT_SESSION_ID", "IS_LAST_PART_KEY", "", "PART_ID_KEY", "SESSION_ID_KEY", "TAG", "createInputData", "Landroidx/work/Data;", "sessionId", "file", "Ljava/io/File;", "isLastPart", "", "partId", "(ILjava/io/File;ZLjava/lang/Integer;)Landroidx/work/Data;", "android-video-uploader_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Data createInputData(int sessionId, @NotNull File file, boolean isLastPart, @Nullable Integer partId) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Integer n = partId;
            Data data = new Data.Builder().putInt(ProgressiveUploadWorker.SESSION_ID_KEY, sessionId).putString("filePath", file.getAbsolutePath()).putBoolean(ProgressiveUploadWorker.IS_LAST_PART_KEY, isLastPart).putInt(ProgressiveUploadWorker.PART_ID_KEY, n != null ? n : -1).build();
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"build(...)");
            return data;
        }

        public static /* synthetic */ Data createInputData$default(Companion companion, int n, File file, boolean bl, Integer n2, int n3, Object object) {
            if ((n3 & 8) != 0) {
                n2 = null;
            }
            return companion.createInputData(n, file, bl, n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

