/*
 * Decompiled with CFR 0.152.
 */
package video.api.player.analytics;

import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import video.api.player.analytics.OptionsKt;
import video.api.player.analytics.VideoInfo;
import video.api.player.analytics.VideoType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lvideo/api/player/analytics/Utils;", "", "()V", "nowUtcToIso", "", "parseMediaUrl", "Lvideo/api/player/analytics/VideoInfo;", "mediaUrl", "Ljava/net/URL;", "collectorDomainURL", "analytics_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @NotNull
    public final String nowUtcToIso() {
        ZonedDateTime zdt = ZonedDateTime.now((ZoneId)ZoneId.of((String)"UTC"));
        String string = zdt.format(DateTimeFormatter.ISO_INSTANT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zdt.format(DateTimeFormatter.ISO_INSTANT)");
        return string;
    }

    @NotNull
    public final VideoInfo parseMediaUrl(@NotNull URL mediaUrl, @NotNull URL collectorDomainURL) {
        Intrinsics.checkNotNullParameter((Object)mediaUrl, (String)"mediaUrl");
        Intrinsics.checkNotNullParameter((Object)collectorDomainURL, (String)"collectorDomainURL");
        String regex = "https://[^/]+/(?>(vod|live)/)?(?>.*/)?((vi|li)[^/^.]*).*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(mediaUrl.toString());
        if (matcher.groupCount() < 3) {
            throw new IOException("The media url doesn't look like an api.video URL.");
        }
        try {
            matcher.find();
            String string = matcher.group(2);
            if (string == null) {
                throw new IOException("Failed to get videoId");
            }
            String videoId = string;
            String firstGroup = matcher.group(1);
            Object object = firstGroup;
            if (object == null || (object = OptionsKt.toVideoType(object)) == null) {
                if (StringsKt.startsWith$default((String)videoId, (String)"li", (boolean)false, (int)2, null)) {
                    object = VideoType.LIVE;
                } else {
                    throw new IOException("Failed to get videoType");
                }
            }
            Object videoType = object;
            return new VideoInfo(videoId, (VideoType)((Object)videoType), collectorDomainURL);
        }
        catch (Exception e) {
            throw new IOException("The media url " + mediaUrl + " doesn't look like an api.video URL", e);
        }
    }
}

