/*
 * Decompiled with CFR 0.152.
 */
package video.api.livestream.views;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.AttributeSet;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.camera.viewfinder.CameraViewfinder;
import androidx.camera.viewfinder.ViewfinderSurfaceRequest;
import androidx.camera.viewfinder.ViewfinderSurfaceRequestUtil;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import io.github.thibaultbee.streampack.streamers.interfaces.ICameraStreamer;
import io.github.thibaultbee.streampack.utils.ContextExtensionsForCameraKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.livestream.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\t\u0018\u0000 :2\u00020\u0001:\u0001:B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J,\u0010\u001d\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001e0#H\u0002J\b\u0010$\u001a\u00020%H\u0014J(\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007H\u0014J\b\u0010+\u001a\u00020%H\u0016J8\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020\u00172\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020%0/2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020%0/H\u0002J\r\u00103\u001a\u00020%H\u0000\u00a2\u0006\u0002\b4J\u0018\u00105\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\fH\u0002J\r\u00107\u001a\u00020%H\u0000\u00a2\u0006\u0002\b8J\b\u00109\u001a\u00020%H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lvideo/api/livestream/views/ApiVideoView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cameraViewFinder", "Landroidx/camera/viewfinder/CameraViewfinder;", "isPreviewing", "", "measureAndLayout", "Ljava/lang/Runnable;", "value", "Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;", "streamer", "getStreamer$livestream_release", "()Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;", "setStreamer$livestream_release", "(Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;)V", "viewFinderSurfaceRequest", "Landroidx/camera/viewfinder/ViewfinderSurfaceRequest;", "createRequest", "targetViewSize", "Landroid/util/Size;", "camera", "", "getPreviewOutputSize", "T", "characteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "targetSize", "targetClass", "Ljava/lang/Class;", "onDetachedFromWindow", "", "onSizeChanged", "w", "h", "oldw", "oldh", "requestLayout", "sendRequest", "request", "onSuccess", "Lkotlin/Function1;", "Landroid/view/Surface;", "onFailure", "", "startPreview", "startPreview$livestream_release", "startPreviewIfReady", "shouldFailSilently", "stopPreview", "stopPreview$livestream_release", "stopPreviewInternal", "Companion", "livestream_release"})
@SourceDebugExtension(value={"SMAP\nApiVideoView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiVideoView.kt\nvideo/api/livestream/views/ApiVideoView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1549#2:258\n1620#2,3:259\n*S KotlinDebug\n*F\n+ 1 ApiVideoView.kt\nvideo/api/livestream/views/ApiVideoView\n*L\n252#1:258\n252#1:259,3\n*E\n"})
public final class ApiVideoView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CameraViewfinder cameraViewFinder;
    @Nullable
    private ViewfinderSurfaceRequest viewFinderSurfaceRequest;
    private boolean isPreviewing;
    @Nullable
    private ICameraStreamer streamer;
    @NotNull
    private final Runnable measureAndLayout;
    @NotNull
    private static final String TAG = "ApiVideoView";

    @JvmOverloads
    public ApiVideoView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.cameraViewFinder = new CameraViewfinder(context, attrs, defStyle);
        this.addView((View)this.cameraViewFinder, new ViewGroup.LayoutParams(-1, -1));
        this.measureAndLayout = () -> ApiVideoView.measureAndLayout$lambda$0(this);
    }

    public /* synthetic */ ApiVideoView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final ICameraStreamer getStreamer$livestream_release() {
        return this.streamer;
    }

    public final void setStreamer$livestream_release(@Nullable ICameraStreamer value) {
        if (this.streamer != null) {
            ILogger.DefaultImpls.w$default((ILogger)((ILogger)Logger.INSTANCE), (String)TAG, (String)"Streamer has already been set", null, (int)4, null);
            return;
        }
        this.streamer = value;
        this.startPreviewIfReady(new Size(this.getWidth(), this.getHeight()), true);
    }

    public void requestLayout() {
        super.requestLayout();
        this.post(this.measureAndLayout);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.startPreviewIfReady(new Size(w, h), true);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopPreview$livestream_release();
    }

    public final void stopPreview$livestream_release() {
        this.post(() -> ApiVideoView.stopPreview$lambda$1(this));
    }

    private final void stopPreviewInternal() {
        ICameraStreamer iCameraStreamer = this.streamer;
        if (iCameraStreamer != null) {
            iCameraStreamer.stopPreview();
        }
        ViewfinderSurfaceRequest viewfinderSurfaceRequest = this.viewFinderSurfaceRequest;
        if (viewfinderSurfaceRequest != null) {
            viewfinderSurfaceRequest.markSurfaceSafeToRelease();
        }
        this.viewFinderSurfaceRequest = null;
        this.isPreviewing = false;
    }

    public final void startPreview$livestream_release() {
        this.startPreviewIfReady(new Size(this.getWidth(), this.getHeight()), false);
    }

    private final void startPreviewIfReady(Size targetViewSize, boolean shouldFailSilently) {
        ICameraStreamer iCameraStreamer = this.streamer;
        if (iCameraStreamer == null) {
            ApiVideoView $this$startPreviewIfReady_u24lambda_u242 = this;
            boolean bl = false;
            ILogger.DefaultImpls.w$default((ILogger)((ILogger)Logger.INSTANCE), (String)TAG, (String)"Streamer has not been set", null, (int)4, null);
            return;
        }
        ICameraStreamer streamer = iCameraStreamer;
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            ILogger.DefaultImpls.w$default((ILogger)((ILogger)Logger.INSTANCE), (String)TAG, (String)"View size is not ready", null, (int)4, null);
            return;
        }
        try {
            if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.CAMERA") != 0) {
                throw new SecurityException("Camera permission is needed to run this application");
            }
            String camera = streamer.getCamera();
            ILogger.DefaultImpls.i$default((ILogger)((ILogger)Logger.INSTANCE), (String)TAG, (String)("Starting on camera: " + camera), null, (int)4, null);
            ILogger.DefaultImpls.d$default((ILogger)((ILogger)Logger.INSTANCE), (String)TAG, (String)("Target view size: " + targetViewSize), null, (int)4, null);
            this.post(() -> ApiVideoView.startPreviewIfReady$lambda$3(this, targetViewSize, camera, streamer));
        }
        catch (Exception e) {
            if (shouldFailSilently) {
                Logger.INSTANCE.w(TAG, e.toString(), (Throwable)e);
            }
            throw e;
        }
    }

    private final ViewfinderSurfaceRequest createRequest(Size targetViewSize, String camera) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Size previewSize = this.getPreviewOutputSize(ContextExtensionsForCameraKt.getCameraCharacteristics((Context)context, (String)camera), targetViewSize, SurfaceHolder.class);
        ILogger.DefaultImpls.d$default((ILogger)((ILogger)Logger.INSTANCE), (String)TAG, (String)("Selected preview size: " + previewSize), null, (int)4, null);
        ViewfinderSurfaceRequest.Builder builder = new ViewfinderSurfaceRequest.Builder(previewSize);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        ViewfinderSurfaceRequestUtil.populateFromCharacteristics((ViewfinderSurfaceRequest.Builder)builder, (CameraCharacteristics)ContextExtensionsForCameraKt.getCameraCharacteristics((Context)context2, (String)camera));
        ViewfinderSurfaceRequest viewfinderSurfaceRequest = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)viewfinderSurfaceRequest, (String)"build(...)");
        return viewfinderSurfaceRequest;
    }

    private final void sendRequest(ViewfinderSurfaceRequest request, Function1<? super Surface, Unit> onSuccess, Function1<? super Throwable, Unit> onFailure) {
        ListenableFuture listenableFuture = this.cameraViewFinder.requestSurfaceAsync(request);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"requestSurfaceAsync(...)");
        ListenableFuture surfaceListenableFuture = listenableFuture;
        Futures.addCallback((ListenableFuture)surfaceListenableFuture, (FutureCallback)((FutureCallback)new FutureCallback<Surface>(onSuccess, onFailure){
            final /* synthetic */ Function1<Surface, Unit> $onSuccess;
            final /* synthetic */ Function1<Throwable, Unit> $onFailure;
            {
                this.$onSuccess = $onSuccess;
                this.$onFailure = $onFailure;
            }

            public void onSuccess(@NotNull Surface surface) {
                Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
                this.$onSuccess.invoke((Object)surface);
            }

            public void onFailure(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$onFailure.invoke((Object)t);
            }
        }), (Executor)ContextCompat.getMainExecutor((Context)this.getContext()));
    }

    /*
     * WARNING - void declaration
     */
    private final <T> Size getPreviewOutputSize(CameraCharacteristics characteristics, Size targetSize, Class<T> targetClass) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Intrinsics.checkNotNull((Object)object);
        Size[] sizeArray = ((StreamConfigurationMap)object).getOutputSizes(targetClass);
        Intrinsics.checkNotNullExpressionValue((Object)sizeArray, (String)"getOutputSizes(...)");
        List allSizes = ArraysKt.toList((Object[])sizeArray);
        Iterable iterable = CollectionsKt.sortedWith((Iterable)allSizes, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Size it = (Size)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getHeight() * it.getWidth());
                it = (Size)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getHeight() * it.getWidth()));
            }
        });
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Size size = (Size)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Size(it.getWidth(), it.getHeight()));
        }
        List validSizes = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        return ExtensionsKt.closestTo(validSizes, targetSize);
    }

    @JvmOverloads
    public ApiVideoView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ApiVideoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void measureAndLayout$lambda$0(ApiVideoView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.measure(View.MeasureSpec.makeMeasureSpec((int)this$0.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this$0.getHeight(), (int)0x40000000));
        this$0.layout(this$0.getLeft(), this$0.getTop(), this$0.getRight(), this$0.getBottom());
    }

    private static final void stopPreview$lambda$1(ApiVideoView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.isPreviewing) {
            this$0.stopPreviewInternal();
        }
    }

    private static final void startPreviewIfReady$lambda$3(ApiVideoView this$0, Size $targetViewSize, String $camera, ICameraStreamer $streamer) {
        ViewfinderSurfaceRequest request;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$targetViewSize, (String)"$targetViewSize");
        Intrinsics.checkNotNullParameter((Object)$camera, (String)"$camera");
        Intrinsics.checkNotNullParameter((Object)$streamer, (String)"$streamer");
        if (this$0.isPreviewing) {
            ILogger.DefaultImpls.e$default((ILogger)((ILogger)Logger.INSTANCE), (String)TAG, (String)"Preview is already running", null, (int)4, null);
            return;
        }
        this$0.isPreviewing = true;
        this$0.viewFinderSurfaceRequest = request = this$0.createRequest($targetViewSize, $camera);
        this$0.sendRequest(request, (Function1<? super Surface, Unit>)((Function1)new Function1<Surface, Unit>(this$0, $streamer, $camera){
            final /* synthetic */ ApiVideoView this$0;
            final /* synthetic */ ICameraStreamer $streamer;
            final /* synthetic */ String $camera;
            {
                this.this$0 = $receiver;
                this.$streamer = $streamer;
                this.$camera = $camera;
                super(1);
            }

            public final void invoke(@NotNull Surface surface) {
                Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
                if (ActivityCompat.checkSelfPermission((Context)this.this$0.getContext(), (String)"android.permission.CAMERA") != 0) {
                    ViewfinderSurfaceRequest viewfinderSurfaceRequest = ApiVideoView.access$getViewFinderSurfaceRequest$p(this.this$0);
                    if (viewfinderSurfaceRequest != null) {
                        viewfinderSurfaceRequest.markSurfaceSafeToRelease();
                    }
                    ApiVideoView.access$setViewFinderSurfaceRequest$p(this.this$0, null);
                    ApiVideoView.access$setPreviewing$p(this.this$0, false);
                    ILogger.DefaultImpls.e$default((ILogger)((ILogger)Logger.INSTANCE), (String)"ApiVideoView", (String)"Camera permission is needed to run this application", null, (int)4, null);
                } else {
                    try {
                        this.$streamer.startPreview(surface, this.$camera);
                    }
                    catch (Exception e) {
                        ViewfinderSurfaceRequest viewfinderSurfaceRequest = ApiVideoView.access$getViewFinderSurfaceRequest$p(this.this$0);
                        if (viewfinderSurfaceRequest != null) {
                            viewfinderSurfaceRequest.markSurfaceSafeToRelease();
                        }
                        ApiVideoView.access$setViewFinderSurfaceRequest$p(this.this$0, null);
                        ApiVideoView.access$setPreviewing$p(this.this$0, false);
                        Logger.INSTANCE.w("ApiVideoView", "Failed to start preview: " + e, (Throwable)e);
                    }
                }
            }
        }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this$0){
            final /* synthetic */ ApiVideoView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                ViewfinderSurfaceRequest viewfinderSurfaceRequest = ApiVideoView.access$getViewFinderSurfaceRequest$p(this.this$0);
                if (viewfinderSurfaceRequest != null) {
                    viewfinderSurfaceRequest.markSurfaceSafeToRelease();
                }
                ApiVideoView.access$setViewFinderSurfaceRequest$p(this.this$0, null);
                ApiVideoView.access$setPreviewing$p(this.this$0, false);
                Logger.INSTANCE.w("ApiVideoView", "Failed to get a Surface: " + t, t);
            }
        }));
    }

    public static final /* synthetic */ ViewfinderSurfaceRequest access$getViewFinderSurfaceRequest$p(ApiVideoView $this) {
        return $this.viewFinderSurfaceRequest;
    }

    public static final /* synthetic */ void access$setViewFinderSurfaceRequest$p(ApiVideoView $this, ViewfinderSurfaceRequest viewfinderSurfaceRequest) {
        $this.viewFinderSurfaceRequest = viewfinderSurfaceRequest;
    }

    public static final /* synthetic */ void access$setPreviewing$p(ApiVideoView $this, boolean bl) {
        $this.isPreviewing = bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lvideo/api/livestream/views/ApiVideoView$Companion;", "", "()V", "TAG", "", "livestream_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

