/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.services;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import androidx.annotation.StringRes;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import video.api.client.api.notifications.NotificationUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u00020\u00122\b\b\u0001\u0010\u0014\u001a\u00020\u00072\b\b\u0001\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lvideo/api/client/api/services/ServiceNotificationUtils;", "", "service", "Landroid/app/Service;", "channelId", "", "notificationId", "", "(Landroid/app/Service;Ljava/lang/String;I)V", "hasNotified", "", "notificationManager", "Landroid/app/NotificationManager;", "getNotificationManager", "()Landroid/app/NotificationManager;", "notificationManager$delegate", "Lkotlin/Lazy;", "cancel", "", "createNotificationChannel", "nameResourceId", "descriptionResourceId", "notify", "notification", "Landroid/app/Notification;", "android-api-client_release"})
public final class ServiceNotificationUtils {
    @NotNull
    private final Service service;
    @NotNull
    private final String channelId;
    private final int notificationId;
    @NotNull
    private final Lazy notificationManager$delegate;
    private boolean hasNotified;

    public ServiceNotificationUtils(@NotNull Service service, @NotNull String channelId, int notificationId) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.service = service;
        this.channelId = channelId;
        this.notificationId = notificationId;
        this.notificationManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationManager>(this){
            final /* synthetic */ ServiceNotificationUtils this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NotificationManager invoke() {
                Object object = ServiceNotificationUtils.access$getService$p(this.this$0).getSystemService("notification");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
                return (NotificationManager)object;
            }
        }));
    }

    private final NotificationManager getNotificationManager() {
        Lazy lazy = this.notificationManager$delegate;
        return (NotificationManager)lazy.getValue();
    }

    public final void cancel() {
        this.service.stopForeground(true);
        this.hasNotified = false;
    }

    public final void notify(@NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        if (!this.hasNotified) {
            this.service.startForeground(this.notificationId, notification);
            this.hasNotified = true;
        } else {
            this.getNotificationManager().notify(this.notificationId, notification);
        }
    }

    public final void createNotificationChannel(@StringRes int nameResourceId, @StringRes int descriptionResourceId) {
        NotificationUtils.INSTANCE.createNotificationChannel((Context)this.service, this.channelId, nameResourceId, descriptionResourceId);
    }

    public static final /* synthetic */ Service access$getService$p(ServiceNotificationUtils $this) {
        return $this.service;
    }
}

