/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.client.api.models.DeepObject;

@ApiModel(description="Collection of details about the video object that you can use to work with the video object.")
public class VideoAssets
implements Serializable,
DeepObject {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_HLS = "hls";
    @SerializedName(value="hls")
    private URI hls;
    public static final String SERIALIZED_NAME_IFRAME = "iframe";
    @SerializedName(value="iframe")
    private String iframe;
    public static final String SERIALIZED_NAME_PLAYER = "player";
    @SerializedName(value="player")
    private URI player;
    public static final String SERIALIZED_NAME_THUMBNAIL = "thumbnail";
    @SerializedName(value="thumbnail")
    private URI thumbnail;
    public static final String SERIALIZED_NAME_MP4 = "mp4";
    @SerializedName(value="mp4")
    private URI mp4;

    public VideoAssets hls(URI hls) {
        this.hls = hls;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This is the manifest URL. For HTTP Live Streaming (HLS), when a HLS video stream is initiated, the first file to download is the manifest. This file has the extension M3U8, and provides the video player with information about the various bitrates available for streaming.")
    public URI getHls() {
        return this.hls;
    }

    public void setHls(URI hls) {
        this.hls = hls;
    }

    public VideoAssets iframe(String iframe) {
        this.iframe = iframe;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<iframe src=\"//embed.api.video/c188ed58-3403-46a2-b91b-44603d10b2c9?token=831a9bd9-9f50-464c-a369-8e9d914371ae\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>", value="Code to use video from a third party website")
    public String getIframe() {
        return this.iframe;
    }

    public void setIframe(String iframe) {
        this.iframe = iframe;
    }

    public VideoAssets player(URI player) {
        this.player = player;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://embed.api.video/1b9d6ae8-8f57-4b6d-8552-d636926b4f5f?token=831a9bd9-9f50-464c-a369-8e9d914371ae", value="Raw url of the player.")
    public URI getPlayer() {
        return this.player;
    }

    public void setPlayer(URI player) {
        this.player = player;
    }

    public VideoAssets thumbnail(URI thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://cdn.api.video/stream/831a9bd9-9f50-464c-a369-8e9d914371ae/thumbnail.jpg", value="Poster of the video.")
    public URI getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(URI thumbnail) {
        this.thumbnail = thumbnail;
    }

    public VideoAssets mp4(URI mp4) {
        this.mp4 = mp4;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://cdn.api.video/vod/vi4k0jvEUuaTdRAEjQ4Jfrgz/token/8fd70443-d9f0-45d2-b01c-12c8cfc707c9/mp4/source.mp4", value="Available only if mp4Support is enabled. Raw mp4 url.")
    public URI getMp4() {
        return this.mp4;
    }

    public void setMp4(URI mp4) {
        this.mp4 = mp4;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoAssets videoAssets = (VideoAssets)o;
        return Objects.equals(this.hls, videoAssets.hls) && Objects.equals(this.iframe, videoAssets.iframe) && Objects.equals(this.player, videoAssets.player) && Objects.equals(this.thumbnail, videoAssets.thumbnail) && Objects.equals(this.mp4, videoAssets.mp4);
    }

    public int hashCode() {
        return Objects.hash(this.hls, this.iframe, this.player, this.thumbnail, this.mp4);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoAssets {\n");
        sb.append("    hls: ").append(this.toIndentedString(this.hls)).append("\n");
        sb.append("    iframe: ").append(this.toIndentedString(this.iframe)).append("\n");
        sb.append("    player: ").append(this.toIndentedString(this.player)).append("\n");
        sb.append("    thumbnail: ").append(this.toIndentedString(this.thumbnail)).append("\n");
        sb.append("    mp4: ").append(this.toIndentedString(this.mp4)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

