/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import org.threeten.bp.OffsetDateTime;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.ApiResponse;
import video.api.client.api.Pair;
import video.api.client.api.models.AnalyticsAggregatedMetricsResponse;
import video.api.client.api.models.AnalyticsMetricsBreakdownResponse;
import video.api.client.api.models.AnalyticsMetricsBreakdownResponseData;
import video.api.client.api.models.AnalyticsMetricsOverTimeResponse;
import video.api.client.api.models.AnalyticsMetricsOverTimeResponseData;
import video.api.client.api.models.Environment;
import video.api.client.api.models.FilterBy2;
import video.api.client.api.models.Page;

public class AnalyticsApi {
    private ApiClient localVarApiClient;

    public AnalyticsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public AnalyticsApi() {
        this.localVarApiClient = new ApiClient(Environment.PRODUCTION.basePath);
    }

    public AnalyticsApi(String basePath) {
        this.localVarApiClient = new ApiClient(basePath);
    }

    public AnalyticsApi(Environment environment) {
        this.localVarApiClient = new ApiClient(environment.basePath);
    }

    public AnalyticsApi(String apiKey, String basePath) {
        this.localVarApiClient = new ApiClient(apiKey, basePath);
    }

    public AnalyticsApi(String apiKey, Environment environment) {
        this.localVarApiClient = new ApiClient(apiKey, environment.basePath);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call getAggregatedMetricsCall(String metric, String aggregation, OffsetDateTime from, OffsetDateTime to, FilterBy2 filterBy, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/data/metrics/{metric}/{aggregation}".replaceAll("\\{metric\\}", this.localVarApiClient.escapeString(metric.toString())).replaceAll("\\{aggregation\\}", this.localVarApiClient.escapeString(aggregation.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (filterBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filterBy", filterBy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call getAggregatedMetricsValidateBeforeCall(String metric, String aggregation, OffsetDateTime from, OffsetDateTime to, FilterBy2 filterBy, ApiCallback _callback) throws ApiException {
        if (metric == null) {
            throw new ApiException("Missing the required parameter 'metric' when calling getAggregatedMetrics");
        }
        if (aggregation == null) {
            throw new ApiException("Missing the required parameter 'aggregation' when calling getAggregatedMetrics");
        }
        Call localVarCall = this.getAggregatedMetricsCall(metric, aggregation, from, to, filterBy, _callback);
        return localVarCall;
    }

    private ApiResponse<AnalyticsAggregatedMetricsResponse> getAggregatedMetricsWithHttpInfo(String metric, String aggregation, OffsetDateTime from, OffsetDateTime to, FilterBy2 filterBy) throws ApiException {
        Call localVarCall = this.getAggregatedMetricsValidateBeforeCall(metric, aggregation, from, to, filterBy, null);
        Type localVarReturnType = new TypeToken<AnalyticsAggregatedMetricsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAggregatedMetricsAsync(String metric, String aggregation, OffsetDateTime from, OffsetDateTime to, FilterBy2 filterBy, ApiCallback<AnalyticsAggregatedMetricsResponse> _callback) throws ApiException {
        Call localVarCall = this.getAggregatedMetricsValidateBeforeCall(metric, aggregation, from, to, filterBy, _callback);
        Type localVarReturnType = new TypeToken<AnalyticsAggregatedMetricsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetAggregatedMetricsRequest getAggregatedMetrics(String metric, String aggregation) {
        return new APIgetAggregatedMetricsRequest(metric, aggregation);
    }

    private Call getMetricsBreakdownCall(String metric, String breakdown, OffsetDateTime from, OffsetDateTime to, String sortBy, String sortOrder, FilterBy2 filterBy, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/data/buckets/{metric}/{breakdown}".replaceAll("\\{metric\\}", this.localVarApiClient.escapeString(metric.toString())).replaceAll("\\{breakdown\\}", this.localVarApiClient.escapeString(breakdown.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (filterBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filterBy", filterBy));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call getMetricsBreakdownValidateBeforeCall(String metric, String breakdown, OffsetDateTime from, OffsetDateTime to, String sortBy, String sortOrder, FilterBy2 filterBy, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        if (metric == null) {
            throw new ApiException("Missing the required parameter 'metric' when calling getMetricsBreakdown");
        }
        if (breakdown == null) {
            throw new ApiException("Missing the required parameter 'breakdown' when calling getMetricsBreakdown");
        }
        Call localVarCall = this.getMetricsBreakdownCall(metric, breakdown, from, to, sortBy, sortOrder, filterBy, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<AnalyticsMetricsBreakdownResponse> getMetricsBreakdownWithHttpInfo(String metric, String breakdown, OffsetDateTime from, OffsetDateTime to, String sortBy, String sortOrder, FilterBy2 filterBy, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.getMetricsBreakdownValidateBeforeCall(metric, breakdown, from, to, sortBy, sortOrder, filterBy, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<AnalyticsMetricsBreakdownResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getMetricsBreakdownAsync(String metric, String breakdown, OffsetDateTime from, OffsetDateTime to, String sortBy, String sortOrder, FilterBy2 filterBy, Integer currentPage, Integer pageSize, ApiCallback<AnalyticsMetricsBreakdownResponse> _callback) throws ApiException {
        Call localVarCall = this.getMetricsBreakdownValidateBeforeCall(metric, breakdown, from, to, sortBy, sortOrder, filterBy, currentPage, pageSize, _callback);
        Type localVarReturnType = new TypeToken<AnalyticsMetricsBreakdownResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetMetricsBreakdownRequest getMetricsBreakdown(String metric, String breakdown) {
        return new APIgetMetricsBreakdownRequest(metric, breakdown);
    }

    private Call getMetricsOverTimeCall(String metric, OffsetDateTime from, OffsetDateTime to, String interval, String sortBy, String sortOrder, FilterBy2 filterBy, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/data/timeseries/{metric}".replaceAll("\\{metric\\}", this.localVarApiClient.escapeString(metric.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (filterBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filterBy", filterBy));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call getMetricsOverTimeValidateBeforeCall(String metric, OffsetDateTime from, OffsetDateTime to, String interval, String sortBy, String sortOrder, FilterBy2 filterBy, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        if (metric == null) {
            throw new ApiException("Missing the required parameter 'metric' when calling getMetricsOverTime");
        }
        Call localVarCall = this.getMetricsOverTimeCall(metric, from, to, interval, sortBy, sortOrder, filterBy, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<AnalyticsMetricsOverTimeResponse> getMetricsOverTimeWithHttpInfo(String metric, OffsetDateTime from, OffsetDateTime to, String interval, String sortBy, String sortOrder, FilterBy2 filterBy, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.getMetricsOverTimeValidateBeforeCall(metric, from, to, interval, sortBy, sortOrder, filterBy, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<AnalyticsMetricsOverTimeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getMetricsOverTimeAsync(String metric, OffsetDateTime from, OffsetDateTime to, String interval, String sortBy, String sortOrder, FilterBy2 filterBy, Integer currentPage, Integer pageSize, ApiCallback<AnalyticsMetricsOverTimeResponse> _callback) throws ApiException {
        Call localVarCall = this.getMetricsOverTimeValidateBeforeCall(metric, from, to, interval, sortBy, sortOrder, filterBy, currentPage, pageSize, _callback);
        Type localVarReturnType = new TypeToken<AnalyticsMetricsOverTimeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetMetricsOverTimeRequest getMetricsOverTime(String metric) {
        return new APIgetMetricsOverTimeRequest(metric);
    }

    public class APIgetAggregatedMetricsRequest {
        private final String metric;
        private final String aggregation;
        private OffsetDateTime from;
        private OffsetDateTime to;
        private FilterBy2 filterBy;

        private APIgetAggregatedMetricsRequest(String metric, String aggregation) {
            this.metric = metric;
            this.aggregation = aggregation;
        }

        public APIgetAggregatedMetricsRequest from(OffsetDateTime from) {
            this.from = from;
            return this;
        }

        public APIgetAggregatedMetricsRequest to(OffsetDateTime to) {
            this.to = to;
            return this;
        }

        public APIgetAggregatedMetricsRequest filterBy(FilterBy2 filterBy) {
            this.filterBy = filterBy;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AnalyticsApi.this.getAggregatedMetricsCall(this.metric, this.aggregation, this.from, this.to, this.filterBy, _callback);
        }

        public AnalyticsAggregatedMetricsResponse execute() throws ApiException {
            ApiResponse localVarResp = AnalyticsApi.this.getAggregatedMetricsWithHttpInfo(this.metric, this.aggregation, this.from, this.to, this.filterBy);
            return (AnalyticsAggregatedMetricsResponse)localVarResp.getData();
        }

        private APIgetAggregatedMetricsRequest copy() {
            APIgetAggregatedMetricsRequest copy = new APIgetAggregatedMetricsRequest(this.metric, this.aggregation);
            copy.from(this.from);
            copy.to(this.to);
            copy.filterBy(this.filterBy);
            return copy;
        }

        public ApiResponse<AnalyticsAggregatedMetricsResponse> executeWithHttpInfo() throws ApiException {
            return AnalyticsApi.this.getAggregatedMetricsWithHttpInfo(this.metric, this.aggregation, this.from, this.to, this.filterBy);
        }

        public Call executeAsync(ApiCallback<AnalyticsAggregatedMetricsResponse> _callback) throws ApiException {
            return AnalyticsApi.this.getAggregatedMetricsAsync(this.metric, this.aggregation, this.from, this.to, this.filterBy, _callback);
        }
    }

    public class APIgetMetricsBreakdownRequest {
        private final String metric;
        private final String breakdown;
        private OffsetDateTime from;
        private OffsetDateTime to;
        private String sortBy;
        private String sortOrder;
        private FilterBy2 filterBy;
        private Integer currentPage;
        private Integer pageSize;

        private APIgetMetricsBreakdownRequest(String metric, String breakdown) {
            this.metric = metric;
            this.breakdown = breakdown;
        }

        public APIgetMetricsBreakdownRequest from(OffsetDateTime from) {
            this.from = from;
            return this;
        }

        public APIgetMetricsBreakdownRequest to(OffsetDateTime to) {
            this.to = to;
            return this;
        }

        public APIgetMetricsBreakdownRequest sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public APIgetMetricsBreakdownRequest sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public APIgetMetricsBreakdownRequest filterBy(FilterBy2 filterBy) {
            this.filterBy = filterBy;
            return this;
        }

        public APIgetMetricsBreakdownRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIgetMetricsBreakdownRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AnalyticsApi.this.getMetricsBreakdownCall(this.metric, this.breakdown, this.from, this.to, this.sortBy, this.sortOrder, this.filterBy, this.currentPage, this.pageSize, _callback);
        }

        public Page<AnalyticsMetricsBreakdownResponseData> execute() throws ApiException {
            ApiResponse localVarResp = AnalyticsApi.this.getMetricsBreakdownWithHttpInfo(this.metric, this.breakdown, this.from, this.to, this.sortBy, this.sortOrder, this.filterBy, this.currentPage, this.pageSize);
            return new Page<AnalyticsMetricsBreakdownResponseData>(((AnalyticsMetricsBreakdownResponse)localVarResp.getData()).getData(), ((AnalyticsMetricsBreakdownResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIgetMetricsBreakdownRequest copy() {
            APIgetMetricsBreakdownRequest copy = new APIgetMetricsBreakdownRequest(this.metric, this.breakdown);
            copy.from(this.from);
            copy.to(this.to);
            copy.sortBy(this.sortBy);
            copy.sortOrder(this.sortOrder);
            copy.filterBy(this.filterBy);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<AnalyticsMetricsBreakdownResponse> executeWithHttpInfo() throws ApiException {
            return AnalyticsApi.this.getMetricsBreakdownWithHttpInfo(this.metric, this.breakdown, this.from, this.to, this.sortBy, this.sortOrder, this.filterBy, this.currentPage, this.pageSize);
        }

        public Call executeAsync(final ApiCallback<Page<AnalyticsMetricsBreakdownResponseData>> _callback) throws ApiException {
            ApiCallback<AnalyticsMetricsBreakdownResponse> apiCallback = new ApiCallback<AnalyticsMetricsBreakdownResponse>(){

                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onFailure(e, statusCode, responseHeaders);
                }

                @Override
                public void onSuccess(AnalyticsMetricsBreakdownResponse result, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onSuccess(new Page<AnalyticsMetricsBreakdownResponseData>(result.getData(), result.getPagination(), () -> {
                        try {
                            return APIgetMetricsBreakdownRequest.this.copy().currentPage((APIgetMetricsBreakdownRequest.this.currentPage == null ? 1 : APIgetMetricsBreakdownRequest.this.currentPage) + 1).execute();
                        }
                        catch (ApiException e) {
                            throw new RuntimeException(e);
                        }
                    }), statusCode, responseHeaders);
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                    _callback.onUploadProgress(bytesWritten, contentLength, done);
                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                    _callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            return AnalyticsApi.this.getMetricsBreakdownAsync(this.metric, this.breakdown, this.from, this.to, this.sortBy, this.sortOrder, this.filterBy, this.currentPage, this.pageSize, apiCallback);
        }
    }

    public class APIgetMetricsOverTimeRequest {
        private final String metric;
        private OffsetDateTime from;
        private OffsetDateTime to;
        private String interval;
        private String sortBy;
        private String sortOrder;
        private FilterBy2 filterBy;
        private Integer currentPage;
        private Integer pageSize;

        private APIgetMetricsOverTimeRequest(String metric) {
            this.metric = metric;
        }

        public APIgetMetricsOverTimeRequest from(OffsetDateTime from) {
            this.from = from;
            return this;
        }

        public APIgetMetricsOverTimeRequest to(OffsetDateTime to) {
            this.to = to;
            return this;
        }

        public APIgetMetricsOverTimeRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public APIgetMetricsOverTimeRequest sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public APIgetMetricsOverTimeRequest sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public APIgetMetricsOverTimeRequest filterBy(FilterBy2 filterBy) {
            this.filterBy = filterBy;
            return this;
        }

        public APIgetMetricsOverTimeRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIgetMetricsOverTimeRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AnalyticsApi.this.getMetricsOverTimeCall(this.metric, this.from, this.to, this.interval, this.sortBy, this.sortOrder, this.filterBy, this.currentPage, this.pageSize, _callback);
        }

        public Page<AnalyticsMetricsOverTimeResponseData> execute() throws ApiException {
            ApiResponse localVarResp = AnalyticsApi.this.getMetricsOverTimeWithHttpInfo(this.metric, this.from, this.to, this.interval, this.sortBy, this.sortOrder, this.filterBy, this.currentPage, this.pageSize);
            return new Page<AnalyticsMetricsOverTimeResponseData>(((AnalyticsMetricsOverTimeResponse)localVarResp.getData()).getData(), ((AnalyticsMetricsOverTimeResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIgetMetricsOverTimeRequest copy() {
            APIgetMetricsOverTimeRequest copy = new APIgetMetricsOverTimeRequest(this.metric);
            copy.from(this.from);
            copy.to(this.to);
            copy.interval(this.interval);
            copy.sortBy(this.sortBy);
            copy.sortOrder(this.sortOrder);
            copy.filterBy(this.filterBy);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<AnalyticsMetricsOverTimeResponse> executeWithHttpInfo() throws ApiException {
            return AnalyticsApi.this.getMetricsOverTimeWithHttpInfo(this.metric, this.from, this.to, this.interval, this.sortBy, this.sortOrder, this.filterBy, this.currentPage, this.pageSize);
        }

        public Call executeAsync(final ApiCallback<Page<AnalyticsMetricsOverTimeResponseData>> _callback) throws ApiException {
            ApiCallback<AnalyticsMetricsOverTimeResponse> apiCallback = new ApiCallback<AnalyticsMetricsOverTimeResponse>(){

                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onFailure(e, statusCode, responseHeaders);
                }

                @Override
                public void onSuccess(AnalyticsMetricsOverTimeResponse result, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onSuccess(new Page<AnalyticsMetricsOverTimeResponseData>(result.getData(), result.getPagination(), () -> {
                        try {
                            return APIgetMetricsOverTimeRequest.this.copy().currentPage((APIgetMetricsOverTimeRequest.this.currentPage == null ? 1 : APIgetMetricsOverTimeRequest.this.currentPage) + 1).execute();
                        }
                        catch (ApiException e) {
                            throw new RuntimeException(e);
                        }
                    }), statusCode, responseHeaders);
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                    _callback.onUploadProgress(bytesWritten, contentLength, done);
                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                    _callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            return AnalyticsApi.this.getMetricsOverTimeAsync(this.metric, this.from, this.to, this.interval, this.sortBy, this.sortOrder, this.filterBy, this.currentPage, this.pageSize, apiCallback);
        }
    }
}

