/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import org.threeten.bp.LocalDate;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.ApiResponse;
import video.api.client.api.Pair;
import video.api.client.api.models.AnalyticsData;
import video.api.client.api.models.AnalyticsPlaysResponse;
import video.api.client.api.models.Environment;
import video.api.client.api.models.Page;

public class AnalyticsApi {
    private ApiClient localVarApiClient;

    public AnalyticsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public AnalyticsApi() {
        this.localVarApiClient = new ApiClient(Environment.PRODUCTION.basePath);
    }

    public AnalyticsApi(String basePath) {
        this.localVarApiClient = new ApiClient(basePath);
    }

    public AnalyticsApi(Environment environment) {
        this.localVarApiClient = new ApiClient(environment.basePath);
    }

    public AnalyticsApi(String apiKey, String basePath) {
        this.localVarApiClient = new ApiClient(apiKey, basePath);
    }

    public AnalyticsApi(String apiKey, Environment environment) {
        this.localVarApiClient = new ApiClient(apiKey, environment.basePath);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call getLiveStreamsPlaysCall(LocalDate from, String dimension, LocalDate to, String filter, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/analytics/live-streams/plays";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (dimension != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dimension", dimension));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call getLiveStreamsPlaysValidateBeforeCall(LocalDate from, String dimension, LocalDate to, String filter, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        if (from == null) {
            throw new ApiException("Missing the required parameter 'from' when calling getLiveStreamsPlays");
        }
        if (dimension == null) {
            throw new ApiException("Missing the required parameter 'dimension' when calling getLiveStreamsPlays");
        }
        Call localVarCall = this.getLiveStreamsPlaysCall(from, dimension, to, filter, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<AnalyticsPlaysResponse> getLiveStreamsPlaysWithHttpInfo(LocalDate from, String dimension, LocalDate to, String filter, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.getLiveStreamsPlaysValidateBeforeCall(from, dimension, to, filter, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<AnalyticsPlaysResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getLiveStreamsPlaysAsync(LocalDate from, String dimension, LocalDate to, String filter, Integer currentPage, Integer pageSize, ApiCallback<AnalyticsPlaysResponse> _callback) throws ApiException {
        Call localVarCall = this.getLiveStreamsPlaysValidateBeforeCall(from, dimension, to, filter, currentPage, pageSize, _callback);
        Type localVarReturnType = new TypeToken<AnalyticsPlaysResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetLiveStreamsPlaysRequest getLiveStreamsPlays(LocalDate from, String dimension) {
        return new APIgetLiveStreamsPlaysRequest(from, dimension);
    }

    private Call getVideosPlaysCall(LocalDate from, String dimension, LocalDate to, String filter, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/analytics/videos/plays";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (dimension != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dimension", dimension));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call getVideosPlaysValidateBeforeCall(LocalDate from, String dimension, LocalDate to, String filter, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        if (from == null) {
            throw new ApiException("Missing the required parameter 'from' when calling getVideosPlays");
        }
        if (dimension == null) {
            throw new ApiException("Missing the required parameter 'dimension' when calling getVideosPlays");
        }
        Call localVarCall = this.getVideosPlaysCall(from, dimension, to, filter, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<AnalyticsPlaysResponse> getVideosPlaysWithHttpInfo(LocalDate from, String dimension, LocalDate to, String filter, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.getVideosPlaysValidateBeforeCall(from, dimension, to, filter, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<AnalyticsPlaysResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getVideosPlaysAsync(LocalDate from, String dimension, LocalDate to, String filter, Integer currentPage, Integer pageSize, ApiCallback<AnalyticsPlaysResponse> _callback) throws ApiException {
        Call localVarCall = this.getVideosPlaysValidateBeforeCall(from, dimension, to, filter, currentPage, pageSize, _callback);
        Type localVarReturnType = new TypeToken<AnalyticsPlaysResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetVideosPlaysRequest getVideosPlays(LocalDate from, String dimension) {
        return new APIgetVideosPlaysRequest(from, dimension);
    }

    public class APIgetLiveStreamsPlaysRequest {
        private final LocalDate from;
        private final String dimension;
        private LocalDate to;
        private String filter;
        private Integer currentPage;
        private Integer pageSize;

        private APIgetLiveStreamsPlaysRequest(LocalDate from, String dimension) {
            this.from = from;
            this.dimension = dimension;
        }

        public APIgetLiveStreamsPlaysRequest to(LocalDate to) {
            this.to = to;
            return this;
        }

        public APIgetLiveStreamsPlaysRequest filter(String filter) {
            this.filter = filter;
            return this;
        }

        public APIgetLiveStreamsPlaysRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIgetLiveStreamsPlaysRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AnalyticsApi.this.getLiveStreamsPlaysCall(this.from, this.dimension, this.to, this.filter, this.currentPage, this.pageSize, _callback);
        }

        public Page<AnalyticsData> execute() throws ApiException {
            ApiResponse localVarResp = AnalyticsApi.this.getLiveStreamsPlaysWithHttpInfo(this.from, this.dimension, this.to, this.filter, this.currentPage, this.pageSize);
            return new Page<AnalyticsData>(((AnalyticsPlaysResponse)localVarResp.getData()).getData(), ((AnalyticsPlaysResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIgetLiveStreamsPlaysRequest copy() {
            APIgetLiveStreamsPlaysRequest copy = new APIgetLiveStreamsPlaysRequest(this.from, this.dimension);
            copy.to(this.to);
            copy.filter(this.filter);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<AnalyticsPlaysResponse> executeWithHttpInfo() throws ApiException {
            return AnalyticsApi.this.getLiveStreamsPlaysWithHttpInfo(this.from, this.dimension, this.to, this.filter, this.currentPage, this.pageSize);
        }

        public Call executeAsync(final ApiCallback<Page<AnalyticsData>> _callback) throws ApiException {
            ApiCallback<AnalyticsPlaysResponse> apiCallback = new ApiCallback<AnalyticsPlaysResponse>(){

                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onFailure(e, statusCode, responseHeaders);
                }

                @Override
                public void onSuccess(AnalyticsPlaysResponse result, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onSuccess(new Page<AnalyticsData>(result.getData(), result.getPagination(), () -> {
                        try {
                            return APIgetLiveStreamsPlaysRequest.this.copy().currentPage((APIgetLiveStreamsPlaysRequest.this.currentPage == null ? 1 : APIgetLiveStreamsPlaysRequest.this.currentPage) + 1).execute();
                        }
                        catch (ApiException e) {
                            throw new RuntimeException(e);
                        }
                    }), statusCode, responseHeaders);
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                    _callback.onUploadProgress(bytesWritten, contentLength, done);
                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                    _callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            return AnalyticsApi.this.getLiveStreamsPlaysAsync(this.from, this.dimension, this.to, this.filter, this.currentPage, this.pageSize, apiCallback);
        }
    }

    public class APIgetVideosPlaysRequest {
        private final LocalDate from;
        private final String dimension;
        private LocalDate to;
        private String filter;
        private Integer currentPage;
        private Integer pageSize;

        private APIgetVideosPlaysRequest(LocalDate from, String dimension) {
            this.from = from;
            this.dimension = dimension;
        }

        public APIgetVideosPlaysRequest to(LocalDate to) {
            this.to = to;
            return this;
        }

        public APIgetVideosPlaysRequest filter(String filter) {
            this.filter = filter;
            return this;
        }

        public APIgetVideosPlaysRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIgetVideosPlaysRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AnalyticsApi.this.getVideosPlaysCall(this.from, this.dimension, this.to, this.filter, this.currentPage, this.pageSize, _callback);
        }

        public Page<AnalyticsData> execute() throws ApiException {
            ApiResponse localVarResp = AnalyticsApi.this.getVideosPlaysWithHttpInfo(this.from, this.dimension, this.to, this.filter, this.currentPage, this.pageSize);
            return new Page<AnalyticsData>(((AnalyticsPlaysResponse)localVarResp.getData()).getData(), ((AnalyticsPlaysResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIgetVideosPlaysRequest copy() {
            APIgetVideosPlaysRequest copy = new APIgetVideosPlaysRequest(this.from, this.dimension);
            copy.to(this.to);
            copy.filter(this.filter);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<AnalyticsPlaysResponse> executeWithHttpInfo() throws ApiException {
            return AnalyticsApi.this.getVideosPlaysWithHttpInfo(this.from, this.dimension, this.to, this.filter, this.currentPage, this.pageSize);
        }

        public Call executeAsync(final ApiCallback<Page<AnalyticsData>> _callback) throws ApiException {
            ApiCallback<AnalyticsPlaysResponse> apiCallback = new ApiCallback<AnalyticsPlaysResponse>(){

                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onFailure(e, statusCode, responseHeaders);
                }

                @Override
                public void onSuccess(AnalyticsPlaysResponse result, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onSuccess(new Page<AnalyticsData>(result.getData(), result.getPagination(), () -> {
                        try {
                            return APIgetVideosPlaysRequest.this.copy().currentPage((APIgetVideosPlaysRequest.this.currentPage == null ? 1 : APIgetVideosPlaysRequest.this.currentPage) + 1).execute();
                        }
                        catch (ApiException e) {
                            throw new RuntimeException(e);
                        }
                    }), statusCode, responseHeaders);
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                    _callback.onUploadProgress(bytesWritten, contentLength, done);
                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                    _callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            return AnalyticsApi.this.getVideosPlaysAsync(this.from, this.dimension, this.to, this.filter, this.currentPage, this.pageSize, apiCallback);
        }
    }
}

