/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.auth;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AdvancedAuthenticationApi;
import video.api.client.api.models.AccessToken;
import video.api.client.api.models.AuthenticatePayload;

public class ApiVideoAuthInterceptor
implements Interceptor {
    private final String apiKey;
    private final AdvancedAuthenticationApi authenticationApi;
    private String cachedAccessToken;
    private Long tokenExpirationMs;

    public ApiVideoAuthInterceptor(ApiClient client, String apiKey) {
        this.apiKey = apiKey;
        this.authenticationApi = new AdvancedAuthenticationApi(client);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (request.url().toString().equals(this.authenticationApi.getApiClient().getBasePath() + "/auth/api-key")) {
            return chain.proceed(request);
        }
        try {
            return chain.proceed(request.newBuilder().addHeader("authorization", "Bearer " + this.getAccessToken()).build());
        }
        catch (ApiException e) {
            throw new IOException(e);
        }
    }

    public String getAccessToken() throws ApiException {
        if (!this.isTokenValid()) {
            this.retrieveAccessToken();
        }
        return this.cachedAccessToken;
    }

    private void retrieveAccessToken() throws ApiException {
        AccessToken accessToken = this.authenticationApi.authenticate(new AuthenticatePayload().apiKey(this.apiKey));
        Integer expires = accessToken.getExpiresIn();
        this.tokenExpirationMs = System.currentTimeMillis() + (long)((expires - 60) * 1000);
        this.cachedAccessToken = accessToken.getAccessToken();
    }

    private boolean isTokenValid() {
        return this.tokenExpirationMs != null && this.tokenExpirationMs > System.currentTimeMillis();
    }
}

