/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.client.api.models.RestreamsRequestObject;

public class LiveStreamCreationPayload
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PUBLIC = "public";
    @SerializedName(value="public")
    private Boolean _public;
    public static final String SERIALIZED_NAME_PLAYER_ID = "playerId";
    @SerializedName(value="playerId")
    private String playerId;
    public static final String SERIALIZED_NAME_RESTREAMS = "restreams";
    @SerializedName(value="restreams")
    private List<RestreamsRequestObject> restreams = null;

    public LiveStreamCreationPayload name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="My Live Stream Video", required=true, value="Add a name for your live stream here.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LiveStreamCreationPayload _public(Boolean _public) {
        this._public = _public;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether your video can be viewed by everyone, or requires authentication to see it. A setting of false will require a unique token for each view. Learn more about the Private Video feature [here](https://docs.api.video/docs/private-videos).")
    public Boolean getPublic() {
        return this._public;
    }

    public void setPublic(Boolean _public) {
        this._public = _public;
    }

    public LiveStreamCreationPayload playerId(String playerId) {
        this.playerId = playerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="pl4f4ferf5erfr5zed4fsdd", value="The unique identifier for the player.")
    public String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public LiveStreamCreationPayload restreams(List<RestreamsRequestObject> restreams) {
        this.restreams = restreams;
        return this;
    }

    public LiveStreamCreationPayload addRestreamsItem(RestreamsRequestObject restreamsItem) {
        if (this.restreams == null) {
            this.restreams = new ArrayList<RestreamsRequestObject>();
        }
        this.restreams.add(restreamsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use this parameter to add, edit, or remove RTMP services where you want to restream a live stream. The list can only contain up to 5 destinations.")
    public List<RestreamsRequestObject> getRestreams() {
        return this.restreams;
    }

    public void setRestreams(List<RestreamsRequestObject> restreams) {
        this.restreams = restreams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveStreamCreationPayload liveStreamCreationPayload = (LiveStreamCreationPayload)o;
        return Objects.equals(this.name, liveStreamCreationPayload.name) && Objects.equals(this._public, liveStreamCreationPayload._public) && Objects.equals(this.playerId, liveStreamCreationPayload.playerId) && Objects.equals(this.restreams, liveStreamCreationPayload.restreams);
    }

    public int hashCode() {
        return Objects.hash(this.name, this._public, this.playerId, this.restreams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LiveStreamCreationPayload {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    _public: ").append(this.toIndentedString(this._public)).append("\n");
        sb.append("    playerId: ").append(this.toIndentedString(this.playerId)).append("\n");
        sb.append("    restreams: ").append(this.toIndentedString(this.restreams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

