/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.tools.view.ServletUtils;
import org.apache.velocity.tools.view.VelocityView;

public class VelocityViewServlet
extends HttpServlet {
    public static final String SHARED_CONFIG_PARAM = "org.apache.velocity.tools.shared.config";
    private static final long serialVersionUID = -3329444102562079189L;
    private transient VelocityView view;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.getVelocityView();
    }

    protected String findInitParameter(ServletConfig config, String key) {
        String param = config.getInitParameter(key);
        if (param == null || param.length() == 0) {
            ServletContext servletContext = config.getServletContext();
            param = servletContext.getInitParameter(key);
        }
        return param;
    }

    protected VelocityView getVelocityView() {
        if (this.view == null) {
            ServletConfig config = this.getServletConfig();
            String shared = this.findInitParameter(config, SHARED_CONFIG_PARAM);
            if (shared == null || shared.equals("false")) {
                this.view = ServletUtils.getVelocityView(config);
                assert (this.view != null);
            } else {
                this.view = new VelocityView(config);
            }
        }
        return this.view;
    }

    protected String getVelocityProperty(String name, String alternate) {
        return this.getVelocityView().getProperty(name, alternate);
    }

    protected Log getLog() {
        return this.getVelocityView().getLog();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRequest(HttpServletRequest request, HttpServletResponse response) {
        Context context = null;
        try {
            context = this.createContext(request, response);
            this.fillContext(context, request);
            this.setContentType(request, response);
            Template template = this.handleRequest(request, response, context);
            this.mergeTemplate(template, context, response);
        }
        catch (Throwable e) {
            this.error(request, response, e);
        }
        finally {
            this.requestCleanup(request, response, context);
        }
    }

    protected Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context ctx) throws Exception {
        return this.getTemplate(request, response);
    }

    protected Context createContext(HttpServletRequest request, HttpServletResponse response) {
        return this.getVelocityView().getContext(request, response);
    }

    protected void fillContext(Context context, HttpServletRequest request) {
    }

    protected void setContentType(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(this.getVelocityView().getDefaultContentType());
    }

    protected Template getTemplate(HttpServletRequest request, HttpServletResponse response) {
        return this.getVelocityView().getTemplate(request, response);
    }

    protected Template getTemplate(String name) {
        return this.getVelocityView().getTemplate(name);
    }

    protected void mergeTemplate(Template template, Context context, HttpServletResponse response) throws IOException {
        this.getVelocityView().merge(template, context, response.getWriter());
    }

    protected void error(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        try {
            StringBuilder html = new StringBuilder();
            html.append("<html>\n");
            html.append("<head><title>Error</title></head>\n");
            html.append("<body>\n");
            html.append("<h2>VelocityView : Error processing a template for path '");
            html.append(ServletUtils.getPath(request));
            html.append("'</h2>\n");
            Throwable cause = e;
            String why = cause.getMessage();
            if (why != null && why.length() > 0) {
                html.append(StringEscapeUtils.escapeHtml((String)why));
                html.append("\n<br>\n");
            }
            if (cause instanceof MethodInvocationException) {
                cause = ((MethodInvocationException)cause).getWrappedThrowable();
            }
            StringWriter sw = new StringWriter();
            cause.printStackTrace(new PrintWriter(sw));
            html.append("<pre>\n");
            html.append(StringEscapeUtils.escapeHtml((String)sw.toString()));
            html.append("</pre>\n");
            html.append("</body>\n");
            html.append("</html>");
            response.getWriter().write(html.toString());
        }
        catch (Exception e2) {
            String msg = "Exception while printing error screen";
            this.getLog().error((Object)msg, (Throwable)e2);
            throw new RuntimeException(msg, e);
        }
    }

    protected void requestCleanup(HttpServletRequest request, HttpServletResponse response, Context context) {
    }
}

