/*
 * Decompiled with CFR 0.152.
 */
package uz.click.mobilesdk.core;

import android.os.Handler;
import android.os.Looper;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uz.click.mobilesdk.core.ClickMerchantManager;
import uz.click.mobilesdk.core.callbacks.ResponseListener;
import uz.click.mobilesdk.core.data.CardPaymentRequest;
import uz.click.mobilesdk.core.data.CardPaymentResponse;
import uz.click.mobilesdk.core.data.CheckPaymentResponse;
import uz.click.mobilesdk.core.data.CheckoutResponse;
import uz.click.mobilesdk.core.data.ConfirmPaymentByCardRequest;
import uz.click.mobilesdk.core.data.ConfirmPaymentByCardResponse;
import uz.click.mobilesdk.core.data.InitialRequest;
import uz.click.mobilesdk.core.data.InitialResponse;
import uz.click.mobilesdk.core.data.InvoiceRequest;
import uz.click.mobilesdk.core.data.InvoiceResponse;
import uz.click.mobilesdk.core.errors.ServerNotAvailableException;
import uz.click.mobilesdk.utils.ErrorUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 72\u00020\u0001:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001c\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014J\u001c\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001b2\u0006\u0010\u0017\u001a\u00020\u0011J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J$\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0014J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001b2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0011J\b\u0010!\u001a\u00020\"H\u0002J,\u0010#\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020&0\u0014J$\u0010'\u001a\b\u0012\u0004\u0012\u00020&0\u001b2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0011J$\u0010(\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020*0\u0014J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020*0\u001b2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0011JP\u0010,\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u00112\b\u00102\u001a\u0004\u0018\u00010\u00112\u0006\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002050\u0014JH\u00106\u001a\b\u0012\u0004\u0012\u0002050\u001b2\u0006\u0010\u0010\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u00112\b\u00102\u001a\u0004\u0018\u00010\u00112\u0006\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\u0011R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Luz/click/mobilesdk/core/ClickMerchantManager;", "", "()V", "invoiceCancelled", "", "getInvoiceCancelled", "()Z", "setInvoiceCancelled", "(Z)V", "moshi", "Lcom/squareup/moshi/Moshi;", "kotlin.jvm.PlatformType", "okClient", "Lokhttp3/OkHttpClient;", "checkPayment", "", "serviceId", "", "paymentId", "listener", "Luz/click/mobilesdk/core/callbacks/ResponseListener;", "Luz/click/mobilesdk/core/data/CheckPaymentResponse;", "checkPaymentByRequestId", "requestId", "Luz/click/mobilesdk/core/data/CheckoutResponse;", "checkPaymentByRequestIdContinuously", "checkPaymentByRequestIdRx", "Lio/reactivex/Single;", "checkPaymentRx", "confirmPaymentByCard", "confirmCode", "Luz/click/mobilesdk/core/data/ConfirmPaymentByCardResponse;", "confirmPaymentByCardRx", "loggingInterceptor", "Lokhttp3/Interceptor;", "paymentByCard", "cardNumber", "expireDate", "Luz/click/mobilesdk/core/data/CardPaymentResponse;", "paymentByCardRx", "paymentByUSSD", "phoneNumber", "Luz/click/mobilesdk/core/data/InvoiceResponse;", "paymentByUSSDRx", "sendInitialRequest", "", "merchantId", "amount", "", "transactionParam", "communalParam", "merchantUserId", "language", "Luz/click/mobilesdk/core/data/InitialResponse;", "sendInitialRequestRx", "Companion", "mobilesdk_release"})
public final class ClickMerchantManager {
    private OkHttpClient okClient;
    private Moshi moshi = new Moshi.Builder().build();
    private boolean invoiceCancelled;
    private static boolean logs;
    private static final long CONNECT_TIME_OUT = 10000L;
    private static final long READ_TIME_OUT = 10000L;
    private static final long WRITE_TIME_OUT = 10000L;
    private static final MediaType JSON;
    private static final String INIT_URL = "https://api.click.uz/v2/internal/checkout/prepare";
    private static final String CHECKOUT_URL = "https://api.click.uz/v2/internal/checkout/retrieve";
    private static final String INVOICE_URL = "https://api.click.uz/v2/internal/checkout/invoice";
    private static final String CARD_PAYMENT_URL = "https://api.click.uz/v2/internal/checkout/payment";
    private static final String CARD_PAYMENT_CONFIRM_URL = "https://api.click.uz/v2/internal/checkout/verify";
    public static final Companion Companion;

    public final boolean getInvoiceCancelled() {
        return this.invoiceCancelled;
    }

    public final void setInvoiceCancelled(boolean bl) {
        this.invoiceCancelled = bl;
    }

    private final Interceptor loggingInterceptor() {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        if (logs) {
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        } else {
            logging.setLevel(HttpLoggingInterceptor.Level.NONE);
        }
        return (Interceptor)logging;
    }

    public final void sendInitialRequest(long serviceId, long merchantId, double amount, @Nullable String transactionParam, @Nullable String communalParam, long merchantUserId, @NotNull String language, @NotNull ResponseListener<InitialResponse> listener) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        InitialRequest initRequest = new InitialRequest(serviceId, merchantId, amount, transactionParam, communalParam, "", merchantUserId, language, "");
        JsonAdapter adapter = this.moshi.adapter(InitialRequest.class);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)adapter.toJson((Object)initRequest));
        Request request = new Request.Builder().url(INIT_URL).addHeader("Accept", "application/json").addHeader("Content-type", "application/json").post(body).build();
        this.okClient.newCall(request).enqueue(new Callback(this, listener){
            final /* synthetic */ ClickMerchantManager this$0;
            final /* synthetic */ ResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                if (response.isSuccessful()) {
                    if (response.body() == null) {
                        this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                        return;
                    }
                    ResponseBody responseBody = response.body();
                    if (responseBody != null) {
                        Integer n;
                        InitialResponse initialResponse;
                        ResponseBody responseBody2;
                        ResponseBody it = responseBody2 = responseBody;
                        boolean bl = false;
                        InitialResponse initialResponse2 = initialResponse = (InitialResponse)ClickMerchantManager.access$getMoshi$p(this.this$0).adapter(InitialResponse.class).fromJson(it.string());
                        Integer n2 = n = initialResponse2 != null ? Integer.valueOf(initialResponse2.getErrorCode()) : null;
                        if (n2 != null && n2 == 0) {
                            this.$listener.onSuccess(initialResponse);
                        } else {
                            InitialResponse initialResponse3 = initialResponse;
                            InitialResponse initialResponse4 = initialResponse;
                            this.$listener.onFailure(ErrorUtils.INSTANCE.getException(initialResponse3 != null ? Integer.valueOf(initialResponse3.getErrorCode()) : null, initialResponse4 != null ? initialResponse4.getErrorNote() : null));
                        }
                    }
                } else {
                    this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                }
            }
            {
                this.this$0 = $outer;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    public final void checkPaymentByRequestIdContinuously(@NotNull String requestId, @NotNull ResponseListener<CheckoutResponse> listener) {
        Intrinsics.checkParameterIsNotNull((Object)requestId, (String)"requestId");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        Request request = new Request.Builder().url("https://api.click.uz/v2/internal/checkout/retrieve/" + requestId).addHeader("Accept", "application/json").addHeader("Content-type", "application/json").get().build();
        this.okClient.newCall(request).enqueue(new Callback(this, listener){
            final /* synthetic */ ClickMerchantManager this$0;
            final /* synthetic */ ResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                if (response.isSuccessful()) {
                    if (response.body() == null) {
                        this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                        return;
                    }
                    ResponseBody responseBody = response.body();
                    if (responseBody != null) {
                        CheckoutResponse checkoutResponse;
                        ResponseBody responseBody2;
                        ResponseBody it = responseBody2 = responseBody;
                        boolean bl = false;
                        CheckoutResponse checkoutResponse2 = checkoutResponse = (CheckoutResponse)ClickMerchantManager.access$getMoshi$p(this.this$0).adapter(CheckoutResponse.class).fromJson(it.string());
                        if ((checkoutResponse2 != null ? checkoutResponse2.getPayment() : null) != null) {
                            if (checkoutResponse.getPayment().getPaymentStatus() < 0) {
                                this.$listener.onSuccess(checkoutResponse);
                            } else if (checkoutResponse.getPayment().getPaymentStatus() == 0 || checkoutResponse.getPayment().getPaymentStatus() == 1) {
                                if (!this.this$0.getInvoiceCancelled()) {
                                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable(this, call){
                                        final /* synthetic */ checkPaymentByRequestIdContinuously.1 this$0;
                                        final /* synthetic */ Call $call$inlined;
                                        {
                                            this.this$0 = var1_1;
                                            this.$call$inlined = call;
                                        }

                                        public final void run() {
                                            this.$call$inlined.clone().enqueue((Callback)this.this$0);
                                        }
                                    }, 1000L);
                                } else {
                                    call.cancel();
                                    this.this$0.setInvoiceCancelled(false);
                                }
                            } else if (checkoutResponse.getPayment().getPaymentStatus() == 2) {
                                this.$listener.onSuccess(checkoutResponse);
                            }
                        }
                    }
                } else {
                    this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                }
            }
            {
                this.this$0 = $outer;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    public final void checkPaymentByRequestId(@NotNull String requestId, @NotNull ResponseListener<CheckoutResponse> listener) {
        Intrinsics.checkParameterIsNotNull((Object)requestId, (String)"requestId");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        Request request = new Request.Builder().url("https://api.click.uz/v2/internal/checkout/retrieve/" + requestId).addHeader("Accept", "application/json").addHeader("Content-type", "application/json").get().build();
        this.okClient.newCall(request).enqueue(new Callback(this, listener){
            final /* synthetic */ ClickMerchantManager this$0;
            final /* synthetic */ ResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                block1: {
                    block2: {
                        CheckoutResponse checkoutResponse;
                        CheckoutResponse checkoutResponse2;
                        ResponseBody responseBody;
                        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                        if (response.body() == null) {
                            this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                            return;
                        }
                        ResponseBody responseBody2 = response.body();
                        if (responseBody2 == null) break block1;
                        ResponseBody it = responseBody = responseBody2;
                        boolean bl = false;
                        if (!response.isSuccessful()) break block2;
                        CheckoutResponse checkoutResponse3 = checkoutResponse2 = (CheckoutResponse)ClickMerchantManager.access$getMoshi$p(this.this$0).adapter(CheckoutResponse.class).fromJson(it.string());
                        if (checkoutResponse3 == null) break block1;
                        CheckoutResponse it2 = checkoutResponse = checkoutResponse3;
                        boolean bl2 = false;
                        this.$listener.onSuccess(checkoutResponse2);
                        break block1;
                    }
                    this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                }
            }
            {
                this.this$0 = $outer;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    public final void paymentByUSSD(@NotNull String requestId, @NotNull String phoneNumber, @NotNull ResponseListener<InvoiceResponse> listener) {
        Intrinsics.checkParameterIsNotNull((Object)requestId, (String)"requestId");
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        InvoiceRequest invoice = new InvoiceRequest(requestId, phoneNumber);
        JsonAdapter adapter = this.moshi.adapter(InvoiceRequest.class);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)adapter.toJson((Object)invoice));
        Request request = new Request.Builder().url(INVOICE_URL).addHeader("Accept", "application/json").addHeader("Content-type", "application/json").post(body).build();
        this.okClient.newCall(request).enqueue(new Callback(this, listener){
            final /* synthetic */ ClickMerchantManager this$0;
            final /* synthetic */ ResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                if (response.isSuccessful()) {
                    if (response.body() == null) {
                        this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                        return;
                    }
                    ResponseBody responseBody = response.body();
                    if (responseBody != null) {
                        Integer n;
                        InvoiceResponse invoiceResponse;
                        ResponseBody responseBody2;
                        ResponseBody it = responseBody2 = responseBody;
                        boolean bl = false;
                        InvoiceResponse invoiceResponse2 = invoiceResponse = (InvoiceResponse)ClickMerchantManager.access$getMoshi$p(this.this$0).adapter(InvoiceResponse.class).fromJson(it.string());
                        Integer n2 = n = invoiceResponse2 != null ? Integer.valueOf(invoiceResponse2.getErrorCode()) : null;
                        if (n2 != null && n2 == 0) {
                            this.$listener.onSuccess(invoiceResponse);
                        } else {
                            InvoiceResponse invoiceResponse3 = invoiceResponse;
                            InvoiceResponse invoiceResponse4 = invoiceResponse;
                            this.$listener.onFailure(ErrorUtils.INSTANCE.getException(invoiceResponse3 != null ? Integer.valueOf(invoiceResponse3.getErrorCode()) : null, invoiceResponse4 != null ? invoiceResponse4.getErrorNote() : null));
                        }
                    }
                } else {
                    this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                }
            }
            {
                this.this$0 = $outer;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    public final void paymentByCard(@NotNull String requestId, @NotNull String cardNumber, @NotNull String expireDate, @NotNull ResponseListener<CardPaymentResponse> listener) {
        Intrinsics.checkParameterIsNotNull((Object)requestId, (String)"requestId");
        Intrinsics.checkParameterIsNotNull((Object)cardNumber, (String)"cardNumber");
        Intrinsics.checkParameterIsNotNull((Object)expireDate, (String)"expireDate");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        CardPaymentRequest payment = new CardPaymentRequest(requestId, cardNumber, expireDate);
        JsonAdapter adapter = this.moshi.adapter(CardPaymentRequest.class);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)adapter.toJson((Object)payment));
        Request request = new Request.Builder().url(CARD_PAYMENT_URL).addHeader("Accept", "application/json").addHeader("Content-type", "application/json").post(body).build();
        this.okClient.newCall(request).enqueue(new Callback(this, listener){
            final /* synthetic */ ClickMerchantManager this$0;
            final /* synthetic */ ResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                if (response.isSuccessful()) {
                    if (response.body() == null) {
                        this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                        return;
                    }
                    ResponseBody responseBody = response.body();
                    if (responseBody != null) {
                        Integer n;
                        CardPaymentResponse cardPaymentResponse;
                        ResponseBody responseBody2;
                        ResponseBody it = responseBody2 = responseBody;
                        boolean bl = false;
                        CardPaymentResponse cardPaymentResponse2 = cardPaymentResponse = (CardPaymentResponse)ClickMerchantManager.access$getMoshi$p(this.this$0).adapter(CardPaymentResponse.class).fromJson(it.string());
                        Integer n2 = n = cardPaymentResponse2 != null ? Integer.valueOf(cardPaymentResponse2.getErrorCode()) : null;
                        if (n2 != null && n2 == 0) {
                            this.$listener.onSuccess(cardPaymentResponse);
                        } else {
                            CardPaymentResponse cardPaymentResponse3 = cardPaymentResponse;
                            CardPaymentResponse cardPaymentResponse4 = cardPaymentResponse;
                            this.$listener.onFailure(ErrorUtils.INSTANCE.getException(cardPaymentResponse3 != null ? Integer.valueOf(cardPaymentResponse3.getErrorCode()) : null, cardPaymentResponse4 != null ? cardPaymentResponse4.getErrorNote() : null));
                        }
                    }
                } else {
                    this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                }
            }
            {
                this.this$0 = $outer;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    public final void confirmPaymentByCard(@NotNull String requestId, @NotNull String confirmCode, @NotNull ResponseListener<ConfirmPaymentByCardResponse> listener) {
        Intrinsics.checkParameterIsNotNull((Object)requestId, (String)"requestId");
        Intrinsics.checkParameterIsNotNull((Object)confirmCode, (String)"confirmCode");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        ConfirmPaymentByCardRequest confirm2 = new ConfirmPaymentByCardRequest(requestId, confirmCode);
        JsonAdapter adapter = this.moshi.adapter(ConfirmPaymentByCardRequest.class);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)adapter.toJson((Object)confirm2));
        Request request = new Request.Builder().url(CARD_PAYMENT_CONFIRM_URL).addHeader("Accept", "application/json").addHeader("Content-type", "application/json").post(body).build();
        this.okClient.newCall(request).enqueue(new Callback(this, listener){
            final /* synthetic */ ClickMerchantManager this$0;
            final /* synthetic */ ResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                if (response.isSuccessful()) {
                    if (response.body() == null) {
                        this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                        return;
                    }
                    ResponseBody responseBody = response.body();
                    if (responseBody != null) {
                        Integer n;
                        ConfirmPaymentByCardResponse confirmResponse;
                        ResponseBody responseBody2;
                        ResponseBody it = responseBody2 = responseBody;
                        boolean bl = false;
                        ConfirmPaymentByCardResponse confirmPaymentByCardResponse = confirmResponse = (ConfirmPaymentByCardResponse)ClickMerchantManager.access$getMoshi$p(this.this$0).adapter(ConfirmPaymentByCardResponse.class).fromJson(it.string());
                        Integer n2 = n = confirmPaymentByCardResponse != null ? Integer.valueOf(confirmPaymentByCardResponse.getErrorCode()) : null;
                        if (n2 != null && n2 == 0) {
                            this.$listener.onSuccess(confirmResponse);
                        } else {
                            ConfirmPaymentByCardResponse confirmPaymentByCardResponse2 = confirmResponse;
                            ConfirmPaymentByCardResponse confirmPaymentByCardResponse3 = confirmResponse;
                            this.$listener.onFailure(ErrorUtils.INSTANCE.getException(confirmPaymentByCardResponse2 != null ? Integer.valueOf(confirmPaymentByCardResponse2.getErrorCode()) : null, confirmPaymentByCardResponse3 != null ? confirmPaymentByCardResponse3.getErrorNote() : null));
                        }
                    }
                } else {
                    this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                }
            }
            {
                this.this$0 = $outer;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    public final void checkPayment(@NotNull String serviceId, @NotNull String paymentId, @NotNull ResponseListener<CheckPaymentResponse> listener) {
        Intrinsics.checkParameterIsNotNull((Object)serviceId, (String)"serviceId");
        Intrinsics.checkParameterIsNotNull((Object)paymentId, (String)"paymentId");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        Request request = new Request.Builder().url("https://api.click.uz/v2/merchant/payment/status/" + serviceId + '/' + paymentId).addHeader("Accept", "application/json").addHeader("Content-type", "application/json").get().build();
        this.okClient.newCall(request).enqueue(new Callback(this, listener){
            final /* synthetic */ ClickMerchantManager this$0;
            final /* synthetic */ ResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                if (response.isSuccessful()) {
                    if (response.body() == null) {
                        this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                        return;
                    }
                    ResponseBody responseBody = response.body();
                    if (responseBody != null) {
                        Integer n;
                        CheckPaymentResponse checkResponse;
                        ResponseBody responseBody2;
                        ResponseBody it = responseBody2 = responseBody;
                        boolean bl = false;
                        CheckPaymentResponse checkPaymentResponse = checkResponse = (CheckPaymentResponse)ClickMerchantManager.access$getMoshi$p(this.this$0).adapter(CheckPaymentResponse.class).fromJson(it.string());
                        Integer n2 = n = checkPaymentResponse != null ? Integer.valueOf(checkPaymentResponse.getErrorCode()) : null;
                        if (n2 != null && n2 == 0) {
                            this.$listener.onSuccess(checkResponse);
                        } else {
                            CheckPaymentResponse checkPaymentResponse2 = checkResponse;
                            CheckPaymentResponse checkPaymentResponse3 = checkResponse;
                            this.$listener.onFailure(ErrorUtils.INSTANCE.getException(checkPaymentResponse2 != null ? Integer.valueOf(checkPaymentResponse2.getErrorCode()) : null, checkPaymentResponse3 != null ? checkPaymentResponse3.getErrorNote() : null));
                        }
                    }
                } else {
                    this.$listener.onFailure(new ServerNotAvailableException(response.code(), response.message()));
                }
            }
            {
                this.this$0 = $outer;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    @NotNull
    public final Single<InitialResponse> sendInitialRequestRx(long serviceId, long merchantId, double amount, @Nullable String transactionParam, @Nullable String communalParam, long merchantUserId, @NotNull String language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        Single single = Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(this, serviceId, merchantId, amount, transactionParam, communalParam, merchantUserId, language){
            final /* synthetic */ ClickMerchantManager this$0;
            final /* synthetic */ long $serviceId;
            final /* synthetic */ long $merchantId;
            final /* synthetic */ double $amount;
            final /* synthetic */ String $transactionParam;
            final /* synthetic */ String $communalParam;
            final /* synthetic */ long $merchantUserId;
            final /* synthetic */ String $language;

            public final void subscribe(@NotNull SingleEmitter<InitialResponse> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.this$0.sendInitialRequest(this.$serviceId, this.$merchantId, this.$amount, this.$transactionParam, this.$communalParam, this.$merchantUserId, this.$language, new ResponseListener<InitialResponse>(it){
                    final /* synthetic */ SingleEmitter $it;

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        Throwable throwable = e.getCause();
                        if (throwable == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$it.onError(throwable);
                    }

                    public void onSuccess(@NotNull InitialResponse response) {
                        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                        this.$it.onSuccess((Object)response);
                    }
                    {
                        this.$it = $captured_local_variable$0;
                    }
                });
            }
            {
                this.this$0 = clickMerchantManager;
                this.$serviceId = l;
                this.$merchantId = l2;
                this.$amount = d;
                this.$transactionParam = string2;
                this.$communalParam = string3;
                this.$merchantUserId = l3;
                this.$language = string4;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.create<InitialRes\u2026}\n            )\n        }");
        return single;
    }

    @NotNull
    public final Single<CheckoutResponse> checkPaymentByRequestIdRx(@NotNull String requestId) {
        Intrinsics.checkParameterIsNotNull((Object)requestId, (String)"requestId");
        Single single = Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(this, requestId){
            final /* synthetic */ ClickMerchantManager this$0;
            final /* synthetic */ String $requestId;

            public final void subscribe(@NotNull SingleEmitter<CheckoutResponse> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.this$0.checkPaymentByRequestId(this.$requestId, new ResponseListener<CheckoutResponse>(it){
                    final /* synthetic */ SingleEmitter $it;

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        Throwable throwable = e.getCause();
                        if (throwable == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$it.onError(throwable);
                    }

                    public void onSuccess(@NotNull CheckoutResponse response) {
                        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                        this.$it.onSuccess((Object)response);
                    }
                    {
                        this.$it = $captured_local_variable$0;
                    }
                });
            }
            {
                this.this$0 = clickMerchantManager;
                this.$requestId = string2;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.create<CheckoutRe\u2026}\n            )\n        }");
        return single;
    }

    @NotNull
    public final Single<InvoiceResponse> paymentByUSSDRx(@NotNull String requestId, @NotNull String phoneNumber) {
        Intrinsics.checkParameterIsNotNull((Object)requestId, (String)"requestId");
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        Single single = Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(this, requestId, phoneNumber){
            final /* synthetic */ ClickMerchantManager this$0;
            final /* synthetic */ String $requestId;
            final /* synthetic */ String $phoneNumber;

            public final void subscribe(@NotNull SingleEmitter<InvoiceResponse> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.this$0.paymentByUSSD(this.$requestId, this.$phoneNumber, new ResponseListener<InvoiceResponse>(it){
                    final /* synthetic */ SingleEmitter $it;

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        Throwable throwable = e.getCause();
                        if (throwable == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$it.onError(throwable);
                    }

                    public void onSuccess(@NotNull InvoiceResponse response) {
                        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                        this.$it.onSuccess((Object)response);
                    }
                    {
                        this.$it = $captured_local_variable$0;
                    }
                });
            }
            {
                this.this$0 = clickMerchantManager;
                this.$requestId = string2;
                this.$phoneNumber = string3;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.create<InvoiceRes\u2026}\n            )\n        }");
        return single;
    }

    @NotNull
    public final Single<CardPaymentResponse> paymentByCardRx(@NotNull String requestId, @NotNull String cardNumber, @NotNull String expireDate) {
        Intrinsics.checkParameterIsNotNull((Object)requestId, (String)"requestId");
        Intrinsics.checkParameterIsNotNull((Object)cardNumber, (String)"cardNumber");
        Intrinsics.checkParameterIsNotNull((Object)expireDate, (String)"expireDate");
        Single single = Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(this, requestId, cardNumber, expireDate){
            final /* synthetic */ ClickMerchantManager this$0;
            final /* synthetic */ String $requestId;
            final /* synthetic */ String $cardNumber;
            final /* synthetic */ String $expireDate;

            public final void subscribe(@NotNull SingleEmitter<CardPaymentResponse> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.this$0.paymentByCard(this.$requestId, this.$cardNumber, this.$expireDate, new ResponseListener<CardPaymentResponse>(it){
                    final /* synthetic */ SingleEmitter $it;

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        Throwable throwable = e.getCause();
                        if (throwable == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$it.onError(throwable);
                    }

                    public void onSuccess(@NotNull CardPaymentResponse response) {
                        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                        this.$it.onSuccess((Object)response);
                    }
                    {
                        this.$it = $captured_local_variable$0;
                    }
                });
            }
            {
                this.this$0 = clickMerchantManager;
                this.$requestId = string2;
                this.$cardNumber = string3;
                this.$expireDate = string4;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.create<CardPaymen\u2026}\n            )\n        }");
        return single;
    }

    @NotNull
    public final Single<ConfirmPaymentByCardResponse> confirmPaymentByCardRx(@NotNull String requestId, @NotNull String confirmCode) {
        Intrinsics.checkParameterIsNotNull((Object)requestId, (String)"requestId");
        Intrinsics.checkParameterIsNotNull((Object)confirmCode, (String)"confirmCode");
        Single single = Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(this, requestId, confirmCode){
            final /* synthetic */ ClickMerchantManager this$0;
            final /* synthetic */ String $requestId;
            final /* synthetic */ String $confirmCode;

            public final void subscribe(@NotNull SingleEmitter<ConfirmPaymentByCardResponse> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.this$0.confirmPaymentByCard(this.$requestId, this.$confirmCode, new ResponseListener<ConfirmPaymentByCardResponse>(it){
                    final /* synthetic */ SingleEmitter $it;

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        Throwable throwable = e.getCause();
                        if (throwable == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$it.onError(throwable);
                    }

                    public void onSuccess(@NotNull ConfirmPaymentByCardResponse response) {
                        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                        this.$it.onSuccess((Object)response);
                    }
                    {
                        this.$it = $captured_local_variable$0;
                    }
                });
            }
            {
                this.this$0 = clickMerchantManager;
                this.$requestId = string2;
                this.$confirmCode = string3;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.create<ConfirmPay\u2026}\n            )\n        }");
        return single;
    }

    @NotNull
    public final Single<CheckPaymentResponse> checkPaymentRx(@NotNull String serviceId, @NotNull String paymentId) {
        Intrinsics.checkParameterIsNotNull((Object)serviceId, (String)"serviceId");
        Intrinsics.checkParameterIsNotNull((Object)paymentId, (String)"paymentId");
        Single single = Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(this, serviceId, paymentId){
            final /* synthetic */ ClickMerchantManager this$0;
            final /* synthetic */ String $serviceId;
            final /* synthetic */ String $paymentId;

            public final void subscribe(@NotNull SingleEmitter<CheckPaymentResponse> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.this$0.checkPayment(this.$serviceId, this.$paymentId, new ResponseListener<CheckPaymentResponse>(it){
                    final /* synthetic */ SingleEmitter $it;

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        Throwable throwable = e.getCause();
                        if (throwable == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$it.onError(throwable);
                    }

                    public void onSuccess(@NotNull CheckPaymentResponse response) {
                        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                        this.$it.onSuccess((Object)response);
                    }
                    {
                        this.$it = $captured_local_variable$0;
                    }
                });
            }
            {
                this.this$0 = clickMerchantManager;
                this.$serviceId = string2;
                this.$paymentId = string3;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.create<CheckPayme\u2026}\n            )\n        }");
        return single;
    }

    public ClickMerchantManager() {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(1);
        OkHttpClient.Builder okhttpClientBuilder = new OkHttpClient.Builder();
        okhttpClientBuilder.dispatcher(dispatcher);
        okhttpClientBuilder.addInterceptor(this.loggingInterceptor());
        okhttpClientBuilder.connectTimeout(10000L, TimeUnit.SECONDS).readTimeout(10000L, TimeUnit.SECONDS).writeTimeout(10000L, TimeUnit.SECONDS);
        OkHttpClient okHttpClient = okhttpClientBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"okhttpClientBuilder.build()");
        this.okClient = okHttpClient;
    }

    static {
        Companion = new Companion(null);
        JSON = MediaType.parse((String)"application/json; charset=utf-8");
    }

    public static final /* synthetic */ Moshi access$getMoshi$p(ClickMerchantManager $this) {
        return $this.moshi;
    }

    public static final /* synthetic */ void access$setMoshi$p(ClickMerchantManager $this, Moshi moshi) {
        $this.moshi = moshi;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Luz/click/mobilesdk/core/ClickMerchantManager$Companion;", "", "()V", "CARD_PAYMENT_CONFIRM_URL", "", "CARD_PAYMENT_URL", "CHECKOUT_URL", "CONNECT_TIME_OUT", "", "INIT_URL", "INVOICE_URL", "JSON", "Lokhttp3/MediaType;", "READ_TIME_OUT", "WRITE_TIME_OUT", "logs", "", "getLogs", "()Z", "setLogs", "(Z)V", "mobilesdk_release"})
    public static final class Companion {
        public final boolean getLogs() {
            return logs;
        }

        public final void setLogs(boolean bl) {
            logs = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

