/*
 * Decompiled with CFR 0.152.
 */
package uz.click.mobilesdk.impl.paymentoptions;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatDialogFragment;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uz.click.mobilesdk.R;
import uz.click.mobilesdk.core.errors.ArgumentEmptyException;
import uz.click.mobilesdk.impl.MainDialogFragment;
import uz.click.mobilesdk.impl.paymentoptions.PaymentOption;
import uz.click.mobilesdk.impl.paymentoptions.PaymentOptionAdapter;
import uz.click.mobilesdk.impl.paymentoptions.PaymentOptionEnum;
import uz.click.mobilesdk.impl.paymentoptions.PaymentOptionListFragment$WhenMappings;
import uz.click.mobilesdk.impl.paymentoptions.ThemeOptions;
import uz.click.mobilesdk.utils.LanguageUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J&\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Luz/click/mobilesdk/impl/paymentoptions/PaymentOptionListFragment;", "Landroidx/appcompat/app/AppCompatDialogFragment;", "()V", "themeMode", "Luz/click/mobilesdk/impl/paymentoptions/ThemeOptions;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onViewCreated", "view", "mobilesdk_release"})
public final class PaymentOptionListFragment
extends AppCompatDialogFragment {
    private ThemeOptions themeMode;
    private HashMap _$_findViewCache;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() == null) {
            throw (Throwable)new ArgumentEmptyException();
        }
        Bundle bundle = this.getArguments();
        if (bundle == null) {
            Intrinsics.throwNpe();
        }
        Serializable serializable = bundle.getSerializable("THEME_MODE");
        if (serializable == null) {
            throw new TypeCastException("null cannot be cast to non-null type uz.click.mobilesdk.impl.paymentoptions.ThemeOptions");
        }
        ThemeOptions themeOptions = this.themeMode = (ThemeOptions)((Object)serializable);
        if (themeOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeMode");
        }
        switch (PaymentOptionListFragment$WhenMappings.$EnumSwitchMapping$0[themeOptions.ordinal()]) {
            case 1: {
                this.setStyle(2, R.style.cl_FullscreenDialogTheme);
                break;
            }
            case 2: {
                this.setStyle(2, R.style.cl_FullscreenDialogThemeDark);
            }
        }
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view;
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        ThemeOptions themeOptions = this.themeMode;
        if (themeOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeMode");
        }
        switch (PaymentOptionListFragment$WhenMappings.$EnumSwitchMapping$1[themeOptions.ordinal()]) {
            case 1: {
                ContextThemeWrapper contextWrapper = new ContextThemeWrapper((Context)this.getActivity(), R.style.Theme_App_Light);
                view = inflater.cloneInContext((Context)contextWrapper).inflate(R.layout.fragment_payment_option, container, false);
                break;
            }
            case 2: {
                ContextThemeWrapper contextWrapper = new ContextThemeWrapper((Context)this.getActivity(), R.style.Theme_App_Dark);
                view = inflater.cloneInContext((Context)contextWrapper).inflate(R.layout.fragment_payment_option, container, false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return view;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        ThemeOptions themeOptions;
        Context context;
        ArrayList<PaymentOption> items;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        Fragment fragment = this.getParentFragment();
        if (fragment == null) {
            throw new TypeCastException("null cannot be cast to non-null type uz.click.mobilesdk.impl.MainDialogFragment");
        }
        MainDialogFragment parent = (MainDialogFragment)fragment;
        if (this.getArguments() != null) {
            Bundle bundle = this.getArguments();
            if (bundle == null) {
                Intrinsics.throwNpe();
            }
            Locale locale = new Locale(bundle.getString("LOCALE", "ru"));
            TextView textView = (TextView)this._$_findCachedViewById(R.id.tvTitle);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"tvTitle");
            Context context2 = this.getContext();
            if (context2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context!!");
            textView.setText((CharSequence)LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.payment_types, context2));
            items = new ArrayList<PaymentOption>();
            Context context3 = this.getContext();
            if (context3 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context!!");
            String string2 = LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.invoicing, context3);
            Context context4 = this.getContext();
            if (context4 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)context4, (String)"context!!");
            items.add(new PaymentOption(R.drawable.ic_880, string2, LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.sms_confirmation, context4), PaymentOptionEnum.USSD));
            Context context5 = this.getContext();
            if (context5 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)context5, (String)"context!!");
            String string3 = LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.bank_card, context5);
            Context context6 = this.getContext();
            if (context6 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)context6, (String)"context!!");
            items.add(new PaymentOption(R.drawable.ic_cards, string3, LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.card_props, context6), PaymentOptionEnum.BANK_CARD));
            context = this.getContext();
            if (context == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context!!");
            themeOptions = this.themeMode;
            if (themeOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"themeMode");
            }
        } else {
            throw (Throwable)new ArgumentEmptyException();
        }
        PaymentOptionAdapter adapter = new PaymentOptionAdapter(context, themeOptions, items);
        adapter.setCallback(new PaymentOptionAdapter.OnPaymentOptionSelected(parent){
            final /* synthetic */ MainDialogFragment $parent;

            public void selected(int position, @NotNull PaymentOption item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                this.$parent.paymentOptionSelected(item);
            }
            {
                this.$parent = $captured_local_variable$0;
            }
        });
        RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.rvPaymentTypes);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"rvPaymentTypes");
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        RecyclerView recyclerView2 = (RecyclerView)this._$_findCachedViewById(R.id.rvPaymentTypes);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView2, (String)"rvPaymentTypes");
        recyclerView2.setAdapter((RecyclerView.Adapter)adapter);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }
}

