/*
 * Decompiled with CFR 0.152.
 */
package uz.click.mobilesdk.utils;

import android.content.Context;
import java.io.IOException;
import java.net.HttpRetryException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uz.click.mobilesdk.R;
import uz.click.mobilesdk.core.errors.IncorrectCardNumberException;
import uz.click.mobilesdk.core.errors.InvalidConfirmationCodeException;
import uz.click.mobilesdk.core.errors.InvalidRequestIdException;
import uz.click.mobilesdk.core.errors.MaximalAmountRangeException;
import uz.click.mobilesdk.core.errors.MinimalAmountRangeException;
import uz.click.mobilesdk.core.errors.NumberOfAttemptsException;
import uz.click.mobilesdk.core.errors.ServerErrorException;
import uz.click.mobilesdk.core.errors.ServerNotAvailableException;
import uz.click.mobilesdk.core.errors.ServiceUnavailableForPaymentException;
import uz.click.mobilesdk.core.errors.UnknownErrorException;
import uz.click.mobilesdk.core.errors.WrongServiceIdException;
import uz.click.mobilesdk.utils.LanguageUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ#\u0010\f\u001a\u00060\u0006j\u0002`\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a8\u0006\u0013"}, d2={"Luz/click/mobilesdk/utils/ErrorUtils;", "", "()V", "getErrorMessage", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "locale", "Ljava/util/Locale;", "context", "Landroid/content/Context;", "getException", "code", "", "message", "(Ljava/lang/Integer;Ljava/lang/String;)Ljava/lang/Exception;", "isApiError", "", "mobilesdk_release"})
public final class ErrorUtils {
    public static final ErrorUtils INSTANCE;

    public final boolean isApiError(@NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Exception exception = e;
        return exception instanceof HttpRetryException ? false : (exception instanceof SocketTimeoutException ? false : (exception instanceof IOException ? false : (exception instanceof UnknownHostException ? false : (exception instanceof ServerNotAvailableException ? true : (exception instanceof ServerErrorException ? true : (exception instanceof WrongServiceIdException ? true : (exception instanceof MinimalAmountRangeException ? true : (exception instanceof MaximalAmountRangeException ? true : (exception instanceof IncorrectCardNumberException ? true : (exception instanceof InvalidRequestIdException ? true : (exception instanceof InvalidConfirmationCodeException ? true : (exception instanceof UnknownErrorException ? true : exception instanceof NumberOfAttemptsException))))))))))));
    }

    @NotNull
    public final String getErrorMessage(@NotNull Exception e, @NotNull Locale locale, @NotNull Context context) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Exception exception = e;
        if (exception instanceof WrongServiceIdException) {
            string2 = LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.service_id_error, context);
        } else if (exception instanceof MinimalAmountRangeException) {
            string2 = LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.amount_error, context);
        } else if (exception instanceof MaximalAmountRangeException) {
            string2 = LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.max_amount_error, context);
        } else if (exception instanceof IncorrectCardNumberException) {
            string2 = LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.card_number_error, context);
        } else if (exception instanceof InvalidRequestIdException) {
            string2 = LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.request_id_error, context);
        } else if (exception instanceof ServerErrorException) {
            string2 = LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.server_error, context);
        } else if (exception instanceof InvalidConfirmationCodeException) {
            string2 = LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.confirmation_code_error, context);
        } else if (exception instanceof NumberOfAttemptsException) {
            string2 = LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.number_of_attempts_error, context);
        } else if (exception instanceof ServiceUnavailableForPaymentException) {
            string2 = LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.service_unavailable_error, context);
        } else if (exception instanceof UnknownErrorException) {
            if (((UnknownErrorException)e).getMsg() != null) {
                string2 = ((UnknownErrorException)e).getMsg();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                string2 = LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.unknown_error, context);
            }
        } else {
            string2 = LanguageUtils.INSTANCE.getLocaleStringResource(locale, R.string.unknown_error, context);
        }
        return string2;
    }

    @NotNull
    public final Exception getException(@Nullable Integer code, @Nullable String message) {
        Exception exception;
        Integer n;
        Integer n2 = n = code;
        if (n2 != null && n2 == -1) {
            exception = new WrongServiceIdException(code, message);
        } else {
            Integer n3 = n;
            if (n3 != null && n3 == -6) {
                exception = new MinimalAmountRangeException(code, message);
            } else {
                Integer n4 = n;
                if (n4 != null && n4 == 7) {
                    exception = new MaximalAmountRangeException(code, message);
                } else {
                    Integer n5 = n;
                    if (n5 != null && n5 == -21) {
                        exception = new ServiceUnavailableForPaymentException(code, message);
                    } else {
                        Integer n6 = n;
                        if (n6 != null && n6 == -302) {
                            exception = new InvalidConfirmationCodeException(code, message);
                        } else {
                            Integer n7 = n;
                            if (n7 != null && n7 == -400) {
                                exception = new IncorrectCardNumberException(code, message);
                            } else {
                                Integer n8 = n;
                                if (n8 != null && n8 == -403) {
                                    exception = new InvalidRequestIdException(code, message);
                                } else {
                                    Integer n9 = n;
                                    if (n9 != null && n9 == -406) {
                                        exception = new NumberOfAttemptsException(code, message);
                                    } else {
                                        Integer n10 = n;
                                        exception = n10 != null && n10 == -500 ? (Exception)new ServerErrorException(code, message) : (Exception)new UnknownErrorException(code, message);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return exception;
    }

    private ErrorUtils() {
    }

    static {
        ErrorUtils errorUtils;
        INSTANCE = errorUtils = new ErrorUtils();
    }
}

