/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android.wallet;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.wallet.Cart;
import com.google.android.gms.wallet.FullWallet;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.LineItem;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.Wallet;
import com.google.android.gms.wallet.fragment.SupportWalletFragment;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;
import com.recurly.android.util.RecurlyLog;
import java.util.ArrayList;

public class GoogleWalletManager
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    public static final int WALLET_ENVIRONMENT = 0;
    public static final String ACCOUNT_NAME = "ayyoitsp@gmail.com";
    public static final String MERCHANT_NAME = "Recurly Fries";
    public static final String EXTRA_ITEM_ID = "EXTRA_ITEM_ID";
    public static final String EXTRA_MASKED_WALLET = "EXTRA_MASKED_WALLET";
    public static final String EXTRA_FULL_WALLET = "EXTRA_FULL_WALLET";
    public static final String CURRENCY_CODE_USD = "USD";
    public static final String DESCRIPTION_LINE_ITEM_SHIPPING = "Shipping";
    public static final String DESCRIPTION_LINE_ITEM_TAX = "Tax";
    public static final int REQUEST_CODE_WALLET_BUY = 66036;
    public static final int REQUEST_CODE_WALLET_SUBSCRIBE = 131572;
    public static final int REQUEST_CODE_WALLET_CONFIRMATION = 6334;
    public static final int REQUEST_CODE_RESOLVE_LOAD_FULL_WALLET = 6335;
    private GoogleApiClient mGoogleApiClient;

    public GoogleWalletManager(Context context) {
        this.mGoogleApiClient = new GoogleApiClient.Builder(context).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).setAccountName(ACCOUNT_NAME).addApi(Wallet.API, (Api.ApiOptions.HasOptions)new Wallet.WalletOptions.Builder().setEnvironment(0).setTheme(1).build()).build();
    }

    public void onStart() {
        this.mGoogleApiClient.connect();
    }

    public void onConnected(Bundle bundle) {
    }

    public void onConnectionSuspended(int i) {
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
    }

    public SupportWalletFragment getWalletPurchaseFragment(boolean shippingAddressRequired, boolean phoneNumberRequired) {
        MaskedWalletRequest maskedWalletRequest = MaskedWalletRequest.newBuilder().setMerchantName(MERCHANT_NAME).setPhoneNumberRequired(phoneNumberRequired).setShippingAddressRequired(shippingAddressRequired).setCurrencyCode(CURRENCY_CODE_USD).setIsBillingAgreement(false).setShouldRetrieveWalletObjects(true).setCart(Cart.newBuilder().setCurrencyCode(CURRENCY_CODE_USD).setTotalPrice("150.00").addLineItem(LineItem.newBuilder().setCurrencyCode(CURRENCY_CODE_USD).setDescription("recurly chili fries").setQuantity("1").setUnitPrice("23.45").setTotalPrice("23.45").build()).addLineItem(LineItem.newBuilder().setCurrencyCode(CURRENCY_CODE_USD).setDescription(DESCRIPTION_LINE_ITEM_TAX).setRole(1).setTotalPrice("7.00").build()).build()).setEstimatedTotalPrice("30.45").build();
        WalletFragmentStyle walletFragmentStyle = new WalletFragmentStyle().setBuyButtonText(1).setBuyButtonWidth(-1);
        WalletFragmentOptions walletFragmentOptions = WalletFragmentOptions.newBuilder().setEnvironment(0).setFragmentStyle(walletFragmentStyle).setTheme(1).setMode(1).build();
        SupportWalletFragment walletFragment = SupportWalletFragment.newInstance((WalletFragmentOptions)walletFragmentOptions);
        WalletFragmentInitParams.Builder startParamsBuilder = WalletFragmentInitParams.newBuilder().setMaskedWalletRequest(maskedWalletRequest).setMaskedWalletRequestCode(66036).setAccountName(ACCOUNT_NAME);
        walletFragment.initialize(startParamsBuilder.build());
        return walletFragment;
    }

    public SupportWalletFragment getWalletSubscriptionFragment(boolean shippingAddressRequired, boolean phoneNumberRequired) {
        MaskedWalletRequest maskedWalletRequest = MaskedWalletRequest.newBuilder().setMerchantName(MERCHANT_NAME).setPhoneNumberRequired(phoneNumberRequired).setShippingAddressRequired(shippingAddressRequired).setCurrencyCode(CURRENCY_CODE_USD).setIsBillingAgreement(true).setShouldRetrieveWalletObjects(true).build();
        WalletFragmentStyle walletFragmentStyle = new WalletFragmentStyle().setBuyButtonText(1).setBuyButtonWidth(-1);
        WalletFragmentOptions walletFragmentOptions = WalletFragmentOptions.newBuilder().setEnvironment(0).setFragmentStyle(walletFragmentStyle).setTheme(1).setMode(1).build();
        SupportWalletFragment walletFragment = SupportWalletFragment.newInstance((WalletFragmentOptions)walletFragmentOptions);
        WalletFragmentInitParams.Builder startParamsBuilder = WalletFragmentInitParams.newBuilder().setMaskedWalletRequest(maskedWalletRequest).setMaskedWalletRequestCode(66036).setAccountName(ACCOUNT_NAME);
        walletFragment.initialize(startParamsBuilder.build());
        return walletFragment;
    }

    public SupportWalletFragment getWalletConfirmationFragment(MaskedWallet maskedWallet) {
        WalletFragmentStyle walletFragmentStyle = new WalletFragmentStyle().setMaskedWalletDetailsBackgroundColor(-16776961);
        WalletFragmentOptions walletFragmentOptions = WalletFragmentOptions.newBuilder().setEnvironment(0).setFragmentStyle(walletFragmentStyle).setTheme(1).setMode(2).build();
        SupportWalletFragment walletFragment = SupportWalletFragment.newInstance((WalletFragmentOptions)walletFragmentOptions);
        WalletFragmentInitParams.Builder startParamsBuilder = WalletFragmentInitParams.newBuilder().setMaskedWallet(maskedWallet).setMaskedWalletRequestCode(6334).setAccountName(ACCOUNT_NAME);
        walletFragment.initialize(startParamsBuilder.build());
        return walletFragment;
    }

    public SupportWalletFragment handlePurchaseResult(int requestCode, int resultCode, Intent data) {
        int errorCode = -1;
        if (data != null) {
            errorCode = data.getIntExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", -1);
        }
        if (errorCode > 0) {
            this.handleError(errorCode);
        }
        RecurlyLog.d("handlePurchaseResult " + requestCode + " : " + resultCode + " : " + errorCode);
        if (requestCode == 131572) {
            switch (resultCode) {
                case -1: {
                    MaskedWallet maskedWallet = (MaskedWallet)data.getParcelableExtra("com.google.android.gms.wallet.EXTRA_MASKED_WALLET");
                    FullWalletRequest request = FullWalletRequest.newBuilder().setGoogleTransactionId(maskedWallet.getGoogleTransactionId()).build();
                    Wallet.Payments.loadFullWallet(this.mGoogleApiClient, request, 6335);
                    return this.getWalletConfirmationFragment(maskedWallet);
                }
                case 0: {
                    break;
                }
            }
        }
        if (requestCode == 66036) {
            switch (resultCode) {
                case -1: {
                    MaskedWallet maskedWallet = (MaskedWallet)data.getParcelableExtra("com.google.android.gms.wallet.EXTRA_MASKED_WALLET");
                    ArrayList<LineItem> items = new ArrayList<LineItem>();
                    LineItem item = LineItem.newBuilder().setCurrencyCode(CURRENCY_CODE_USD).setDescription("description").setQuantity("1").setTotalPrice("30.45").setUnitPrice("1.23").build();
                    items.add(item);
                    FullWalletRequest request = FullWalletRequest.newBuilder().setGoogleTransactionId(maskedWallet.getGoogleTransactionId()).setCart(Cart.newBuilder().setCurrencyCode(CURRENCY_CODE_USD).setTotalPrice("30.45").setLineItems(items).build()).build();
                    Wallet.Payments.loadFullWallet(this.mGoogleApiClient, request, 6335);
                    return this.getWalletConfirmationFragment(maskedWallet);
                }
                case 0: {
                    break;
                }
            }
        }
        return null;
    }

    public void handleConfirmationResult(int requestCode, int resultCode, Intent data) {
        int errorCode = -1;
        if (data != null) {
            errorCode = data.getIntExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", -1);
        }
        if (errorCode > 0) {
            this.handleError(errorCode);
        }
        RecurlyLog.d("handleConfirmationResult " + requestCode + " : " + resultCode + " : " + errorCode);
        if (requestCode == 6335) {
            switch (resultCode) {
                case -1: {
                    if (!data.hasExtra("com.google.android.gms.wallet.EXTRA_FULL_WALLET")) break;
                    FullWallet fullWallet = (FullWallet)data.getParcelableExtra("com.google.android.gms.wallet.EXTRA_FULL_WALLET");
                    RecurlyLog.d("handleConfirmationResult received full wallet");
                    break;
                }
                case 0: {
                    break;
                }
            }
        }
    }

    void handleError(int errorCode) {
        switch (errorCode) {
            case 406: {
                break;
            }
        }
    }
}

