/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android;

import android.content.Context;
import android.content.Intent;
import android.support.v4.app.FragmentManager;
import com.google.android.gms.wallet.fragment.SupportWalletFragment;
import com.recurly.android.model.Coupon;
import com.recurly.android.model.Plan;
import com.recurly.android.model.Pricing;
import com.recurly.android.model.Tax;
import com.recurly.android.network.RecurlyApiClient;
import com.recurly.android.network.RecurlyConfig;
import com.recurly.android.network.RecurlyError;
import com.recurly.android.network.ResponseHandler;
import com.recurly.android.network.request.CardPaymentRequest;
import com.recurly.android.network.request.CouponRequest;
import com.recurly.android.network.request.PlanRequest;
import com.recurly.android.network.request.PricingRequest;
import com.recurly.android.network.request.TaxRequest;
import com.recurly.android.network.response.TokenResponse;
import com.recurly.android.util.RecurlyLog;
import com.recurly.android.wallet.GoogleWalletManager;
import java.util.List;

public class RecurlyApi {
    public static final String VERSION = "0.1.0";
    private static final String LOG_TAG = "RecurlySDK";
    private static final boolean USE_GOOGLE_WALLET_API = true;
    private RecurlyApiClient mClient;
    private GoogleWalletManager mGoogleWalletManager;
    private FragmentManager mFragmentManager;
    private int mWalletFragmentId;

    private RecurlyApi(Context context, String apiKey) {
        RecurlyConfig recurlyConfig = RecurlyConfig.getDefaultConfiguration(apiKey);
        this.mClient = new RecurlyApiClient();
        this.mClient.init(context, recurlyConfig);
        RecurlyLog.i("RecurlyApi initialized");
        try {
            this.mGoogleWalletManager = new GoogleWalletManager(context);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public static RecurlyApi getInstance(Context context, String apiKey) {
        RecurlyApi api = new RecurlyApi(context, apiKey);
        return api;
    }

    public void onStart() {
        this.mGoogleWalletManager.onStart();
    }

    public SupportWalletFragment walletPurchaseTransaction() {
        SupportWalletFragment fragment = this.mGoogleWalletManager.getWalletPurchaseFragment(true, true);
        return fragment;
    }

    public SupportWalletFragment walletSubscriptionTransaction() {
        SupportWalletFragment fragment = this.mGoogleWalletManager.getWalletSubscriptionFragment(true, true);
        return fragment;
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        RecurlyLog.d("onActivityResult API");
        switch (requestCode) {
            case 66036: {
                SupportWalletFragment fragment = this.mGoogleWalletManager.handlePurchaseResult(requestCode, resultCode, data);
                RecurlyLog.d("on buy request " + fragment);
                return true;
            }
            case 131572: {
                SupportWalletFragment fragment = this.mGoogleWalletManager.handlePurchaseResult(requestCode, resultCode, data);
                RecurlyLog.d("on subscribe request " + fragment);
            }
            case 6335: {
                this.mGoogleWalletManager.handleConfirmationResult(requestCode, resultCode, data);
                return true;
            }
        }
        return false;
    }

    public void getPostalTax(TaxRequest request, final TaxResponseHandler handler) {
        RecurlyError error = request.validate();
        if (error != null) {
            request.setFinished(true);
            handler.onTaxFailure(error);
            return;
        }
        this.mClient.getTaxForPostalCode(request, new ResponseHandler<List<Tax>>(){

            @Override
            public void onSuccess(List<Tax> taxes) {
                if (taxes != null && taxes.size() > 0) {
                    handler.onTaxSuccess(taxes.get(0));
                } else {
                    handler.onTaxSuccess(Tax.NO_TAX);
                }
            }

            @Override
            public void onFailure(RecurlyError ex) {
                handler.onTaxFailure(ex);
            }
        });
    }

    public void getPaymentToken(CardPaymentRequest request, final TokenResponseHandler handler) {
        RecurlyError error = request.validate();
        if (error != null) {
            request.setFinished(true);
            handler.onTokenFailure(error);
            return;
        }
        this.mClient.getTokenForCardPayment(request, new ResponseHandler<TokenResponse>(){

            @Override
            public void onSuccess(TokenResponse tokenResponse) {
                handler.onTokenSuccess(tokenResponse.getId());
            }

            @Override
            public void onFailure(RecurlyError ex) {
                handler.onTokenFailure(ex);
            }
        });
    }

    public void getPlan(PlanRequest request, final PlanResponseHandler handler) {
        RecurlyError error = request.validate();
        if (error != null) {
            request.setFinished(true);
            handler.onPlanFailure(error);
            return;
        }
        this.mClient.getPlan(request, new ResponseHandler<Plan>(){

            @Override
            public void onSuccess(Plan plan) {
                handler.onPlanSuccess(plan);
            }

            @Override
            public void onFailure(RecurlyError ex) {
                handler.onPlanFailure(ex);
            }
        });
    }

    public void getCoupon(CouponRequest request, final CouponResponseHandler handler) {
        RecurlyError error = request.validate();
        if (error != null) {
            request.setFinished(true);
            handler.onCouponFailure(error);
            return;
        }
        this.mClient.getCoupon(request, new ResponseHandler<Coupon>(){

            @Override
            public void onSuccess(Coupon coupon) {
                handler.onCouponSuccess(coupon);
            }

            @Override
            public void onFailure(RecurlyError ex) {
                handler.onCouponFailure(ex);
            }
        });
    }

    public void getPricing(PricingRequest request, PricingResponseHandler handler) {
        RecurlyError error = request.validate();
        if (error != null) {
            request.setFinished(true);
            handler.onPricingFailure(error);
            return;
        }
        request.setHandler(handler);
        request.fetchRequiredData(this);
    }

    public static interface PricingResponseHandler {
        public void onPricingSuccess(Pricing var1);

        public void onPricingFailure(RecurlyError var1);
    }

    public static interface CouponResponseHandler {
        public void onCouponSuccess(Coupon var1);

        public void onCouponFailure(RecurlyError var1);
    }

    public static interface PlanResponseHandler {
        public void onPlanSuccess(Plan var1);

        public void onPlanFailure(RecurlyError var1);
    }

    public static interface TokenResponseHandler {
        public void onTokenSuccess(String var1);

        public void onTokenFailure(RecurlyError var1);
    }

    public static interface TaxResponseHandler {
        public void onTaxSuccess(Tax var1);

        public void onTaxFailure(RecurlyError var1);
    }
}

