/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android.network;

import com.android.volley.NoConnectionError;
import com.android.volley.VolleyError;
import com.recurly.android.network.NetworkResponseError;

public class RecurlyError
extends Exception {
    public static final int STATUS_CODE_VALIDATION = 401;
    private int mStatusCode;
    private String mErrorCode;
    private String mErrorMessage;

    public RecurlyError(NetworkResponseError error) {
        this.mStatusCode = 400;
        this.mErrorCode = error.getErrorCode();
        this.mErrorMessage = error.getErrorMessage();
    }

    public RecurlyError(int statusCode, String errorCode, String errorMessage) {
        this.mStatusCode = statusCode;
        this.mErrorCode = errorCode;
        this.mErrorMessage = errorMessage;
    }

    public RecurlyError() {
    }

    public static String getValidationError(String fieldName) {
        return "Input validation for '" + fieldName + "' failed";
    }

    public static RecurlyError validationError(String fieldName) {
        RecurlyError error = new RecurlyError();
        error.setStatusCode(400);
        error.setErrorCode("validation error");
        error.setErrorMessage(RecurlyError.getValidationError(fieldName));
        return error;
    }

    public static RecurlyError genericServerError(String errorString) {
        RecurlyError error = new RecurlyError();
        error.setStatusCode(500);
        error.setErrorCode("Unexpected error");
        error.setErrorMessage("Unexpected error: " + errorString);
        return error;
    }

    public static RecurlyError errorFromVolley(VolleyError volleyError) {
        if (volleyError instanceof NetworkResponseError) {
            return new RecurlyError((NetworkResponseError)volleyError);
        }
        RecurlyError error = new RecurlyError();
        String responseBody = null;
        if (volleyError.networkResponse != null && volleyError.networkResponse.data != null) {
            responseBody = new String(volleyError.networkResponse.data);
        }
        if (!(volleyError instanceof NoConnectionError)) {
            volleyError.printStackTrace();
        }
        if (volleyError.networkResponse != null) {
            error.mStatusCode = volleyError.networkResponse.statusCode;
        }
        error.mErrorMessage = volleyError.getLocalizedMessage();
        error.mErrorCode = volleyError.getMessage();
        return error;
    }

    public String getErrorCode() {
        return this.mErrorCode;
    }

    public void setErrorCode(String errorCode) {
        this.mErrorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage;
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public void setStatusCode(int statusCode) {
        this.mStatusCode = statusCode;
    }

    @Override
    public String toString() {
        return "RecurlyNetworkError{mStatusCode=" + this.mStatusCode + ", mErrorCode='" + this.mErrorCode + '\'' + ", mErrorMessage='" + this.mErrorMessage + '\'' + '}';
    }
}

