/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android.network;

public class RecurlyConfig {
    private String mBaseUrl;
    private String mApiPath;
    private String mPublicKey;
    private String mCurrency;
    private int mDefaultTimeout;
    private String mApiVersion;

    public RecurlyConfig(String baseUrl, String apiPath, String publicKey, String currency, int defaultTimeout, String apiVersion) {
        this.mBaseUrl = baseUrl;
        this.mApiPath = apiPath;
        this.mPublicKey = publicKey;
        this.mCurrency = currency;
        this.mDefaultTimeout = defaultTimeout;
        this.mApiVersion = apiVersion;
    }

    public String getBaseUrl() {
        return this.mBaseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.mBaseUrl = baseUrl;
    }

    public String getApiPath() {
        return this.mApiPath;
    }

    public void setApiPath(String apiPath) {
        this.mApiPath = apiPath;
    }

    public String getPublicKey() {
        return this.mPublicKey;
    }

    public void setPublicKey(String publicKey) {
        this.mPublicKey = publicKey;
    }

    public String getCurrency() {
        return this.mCurrency;
    }

    public void setCurrency(String currency) {
        this.mCurrency = currency;
    }

    public int getDefaultTimeout() {
        return this.mDefaultTimeout;
    }

    public void setDefaultTimeout(int defaultTimeout) {
        this.mDefaultTimeout = defaultTimeout;
    }

    public String getApiVersion() {
        return this.mApiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.mApiVersion = apiVersion;
    }

    public static RecurlyConfig getDefaultConfiguration(String publicKey) {
        return new Builder().setBaseUrl("https://api.recurly.com/").setApiPath("js/v1").setDefaultTimeout(10000).setPublicKey(publicKey).setCurrency("USD").setApiVersion("3.0.9").build();
    }

    public static class Builder {
        private String mBaseUrl;
        private String mApiPath;
        private String mPublicKey;
        private String mCurrency;
        private int mDefaultTimeout;
        private String mApiVersion;

        public Builder setBaseUrl(String baseUrl) {
            this.mBaseUrl = baseUrl;
            return this;
        }

        public Builder setApiPath(String apiPath) {
            this.mApiPath = apiPath;
            return this;
        }

        public Builder setPublicKey(String publicKey) {
            this.mPublicKey = publicKey;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.mCurrency = currency;
            return this;
        }

        public Builder setDefaultTimeout(int defaultTimeout) {
            this.mDefaultTimeout = defaultTimeout;
            return this;
        }

        public Builder setApiVersion(String apiVersion) {
            this.mApiVersion = apiVersion;
            return this;
        }

        public RecurlyConfig build() {
            return new RecurlyConfig(this.mBaseUrl, this.mApiPath, this.mPublicKey, this.mCurrency, this.mDefaultTimeout, this.mApiVersion);
        }
    }
}

