/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.route;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import us.racem.sea.body.Response;
import us.racem.sea.convert.AnyCodec;
import us.racem.sea.fish.Ocean;
import us.racem.sea.mark.body.Content;
import us.racem.sea.mark.body.HtmlContent;
import us.racem.sea.mark.body.JsonContent;
import us.racem.sea.mark.body.NoContent;
import us.racem.sea.mark.methods.DeleteMapping;
import us.racem.sea.mark.methods.GetMapping;
import us.racem.sea.mark.methods.PatchMapping;
import us.racem.sea.mark.methods.PostMapping;
import us.racem.sea.mark.methods.PutMapping;
import us.racem.sea.mark.methods.RequestMapping;
import us.racem.sea.mark.methods.RequestMethod;
import us.racem.sea.mark.request.body.Body;
import us.racem.sea.mark.request.header.NamedHeader;
import us.racem.sea.mark.request.param.NamedParam;
import us.racem.sea.route.RouteRegistry;
import us.racem.sea.route.RouteSegment;
import us.racem.sea.util.InterpolationLogger;
import us.racem.sea.util.MethodUtils;
import us.racem.sea.util.SetUtils;

public class RouteInvoker {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final InterpolationLogger logger = InterpolationLogger.getLogger(Ocean.class);
    private static final String logPrefix = "ROU";
    private Class<?> klass;
    private MethodHandle bound;
    private Object inst;
    private String path;
    private RequestMethod[] methods;
    private String mime;
    private List<RouteSegment> segments;

    public RouteInvoker(RouteSegment segment, Method receiver, Object instance) {
        this.segments = this.segments(segment);
        this.klass = receiver.getDeclaringClass();
        this.path = this.path(receiver);
        this.methods = this.methods(receiver);
        this.mime = this.mime(receiver);
        try {
            if (this.path == null || this.methods == null || this.mime == null) {
                throw new NoSuchMethodException("Invalid Route");
            }
            this.inst = instance;
            this.bound = this.bind(receiver);
        }
        catch (IllegalAccessException | NoSuchMethodException err) {
            logger.info("Failed to Initialise Route {}", receiver);
        }
    }

    public boolean handles(RequestMethod method) {
        return ArrayUtils.contains((Object[])this.methods, (Object)((Object)method));
    }

    private List<RouteSegment> segments(RouteSegment segment) {
        ArrayList<RouteSegment> patterns = new ArrayList<RouteSegment>();
        for (RouteSegment pivot = segment; pivot != null; pivot = pivot.prev()) {
            patterns.add(pivot);
        }
        return patterns;
    }

    private Pattern ptrn(String name) {
        for (RouteSegment seg : this.segments) {
            if (!seg.nameEquals(name)) continue;
            return seg.ptrn();
        }
        return null;
    }

    private AnyCodec<?> conv(Pattern ptrn) {
        for (AnyCodec<?> conv : RouteRegistry.converters.values()) {
            if (!conv.regex().equals(ptrn.toString())) continue;
            return conv;
        }
        return null;
    }

    private int pos(String name) {
        List segments = Lists.reverse(this.segments);
        for (int i = 0; i < segments.size(); ++i) {
            if (!((RouteSegment)segments.get(i)).nameEquals(name)) continue;
            return i;
        }
        return -1;
    }

    private String path(Method receiver) {
        RequestMapping request = receiver.getAnnotation(RequestMapping.class);
        GetMapping get = receiver.getAnnotation(GetMapping.class);
        PutMapping put = receiver.getAnnotation(PutMapping.class);
        PatchMapping patch = receiver.getAnnotation(PatchMapping.class);
        PostMapping post = receiver.getAnnotation(PostMapping.class);
        DeleteMapping delete = receiver.getAnnotation(DeleteMapping.class);
        if (!SetUtils.xor(request, get, put, patch, post, delete)) {
            return null;
        }
        if (request != null) {
            return request.path();
        }
        if (get != null) {
            return get.path();
        }
        if (put != null) {
            return put.path();
        }
        if (patch != null) {
            return patch.path();
        }
        if (post != null) {
            return post.path();
        }
        if (delete != null) {
            return delete.path();
        }
        throw new RuntimeException("Unreachable!");
    }

    private RequestMethod[] methods(Method receiver) {
        RequestMapping request = receiver.getAnnotation(RequestMapping.class);
        GetMapping get = receiver.getAnnotation(GetMapping.class);
        PutMapping put = receiver.getAnnotation(PutMapping.class);
        PatchMapping patch = receiver.getAnnotation(PatchMapping.class);
        PostMapping post = receiver.getAnnotation(PostMapping.class);
        DeleteMapping delete = receiver.getAnnotation(DeleteMapping.class);
        if (!SetUtils.xor(request, get, put, patch, post, delete)) {
            return null;
        }
        if (request != null) {
            return request.methods();
        }
        if (get != null) {
            return SetUtils.of(RequestMethod.GET);
        }
        if (put != null) {
            return SetUtils.of(RequestMethod.PUT);
        }
        if (patch != null) {
            return SetUtils.of(RequestMethod.PATCH);
        }
        if (post != null) {
            return SetUtils.of(RequestMethod.POST);
        }
        if (delete != null) {
            return SetUtils.of(RequestMethod.DELETE);
        }
        throw new RuntimeException("Unreachable!");
    }

    private String mime(Method receiver) {
        AnnotatedType type = receiver.getAnnotatedReturnType();
        if (type.getType() == Void.TYPE) {
            return "application/octet-stream";
        }
        Content content = type.getAnnotation(Content.class);
        HtmlContent html = type.getAnnotation(HtmlContent.class);
        JsonContent json = type.getAnnotation(JsonContent.class);
        NoContent none = type.getAnnotation(NoContent.class);
        if (!SetUtils.xor(content, html, json, none)) {
            return "text/plain";
        }
        if (content != null) {
            return content.mime();
        }
        if (html != null) {
            return "text/html";
        }
        if (json != null) {
            return "application/json";
        }
        if (none != null) {
            return "application/octet-stream";
        }
        return "text/plain";
    }

    private String nameOf(Parameter par) {
        AnnotatedType type = par.getAnnotatedType();
        NamedHeader header = type.getAnnotation(NamedHeader.class);
        NamedParam param = type.getAnnotation(NamedParam.class);
        if (!SetUtils.xor(header, param)) {
            return null;
        }
        if (header != null) {
            return header.value();
        }
        if (param != null) {
            return param.value();
        }
        return null;
    }

    private TargetParameterKind kindOf(Parameter par) {
        AnnotatedType type = par.getAnnotatedType();
        NamedHeader header = type.getAnnotation(NamedHeader.class);
        NamedParam param = type.getAnnotation(NamedParam.class);
        Body body = type.getAnnotation(Body.class);
        if (par.getType() == RequestMethod.class) {
            return TargetParameterKind.METHOD;
        }
        if (!SetUtils.xor(header, param, body)) {
            return TargetParameterKind.OTHER;
        }
        if (header != null) {
            return TargetParameterKind.HEADER;
        }
        if (param != null) {
            return TargetParameterKind.PARAM;
        }
        if (body != null) {
            return TargetParameterKind.BODY;
        }
        return TargetParameterKind.OTHER;
    }

    private static Response wrapper(ThunkInvoker invoker, String mime, String path, RequestMethod method, Map<String, List<String>> headers, byte[] body) throws Throwable {
        Object obj;
        Object object = obj = invoker.invoke(path, method, headers, body);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Response.class, String.class, byte[].class}, (Object)object, n)) {
            case 0 -> {
                Response rsp;
                yield rsp = (Response)object;
            }
            case 1 -> {
                String sng = (String)object;
                yield new Response(200, sng.getBytes(StandardCharsets.UTF_8), mime, new Map.Entry[0]);
            }
            case 2 -> {
                byte[] bytes = (byte[])object;
                yield new Response(200, bytes, mime, new Map.Entry[0]);
            }
            default -> RouteRegistry.errorOf(path, "Invalid Response from handler.", 500);
        };
    }

    private MethodHandle bind(Method receiver) throws NoSuchMethodException, IllegalAccessException {
        Parameter[] params = receiver.getParameters();
        MethodHandle fn = MethodUtils.unreflect(receiver, this.inst);
        ThunkInvoker invoker = new ThunkInvoker(fn);
        block7: for (Parameter param : params) {
            String name = this.nameOf(param);
            TargetParameterKind kind = this.kindOf(param);
            if ((kind == TargetParameterKind.PARAM || kind == TargetParameterKind.HEADER) && name == null) continue;
            switch (kind) {
                case HEADER: {
                    if (param.getType() != List.class && param.getType() != String.class) {
                        invoker.zero(param.getType());
                        continue block7;
                    }
                    invoker.header(name);
                    continue block7;
                }
                case PARAM: {
                    int pos = this.pos(name);
                    Pattern ptrn = this.ptrn(name);
                    if (ptrn == null) {
                        invoker.zero(param.getType());
                        continue block7;
                    }
                    AnyCodec<?> conv = this.conv(ptrn);
                    if (pos == -1 || conv == null) {
                        invoker.zero(param.getType());
                        continue block7;
                    }
                    invoker.param(ptrn, conv, pos);
                    continue block7;
                }
                case METHOD: {
                    if (param.getType() != RequestMethod.class) {
                        invoker.zero(param.getType());
                        continue block7;
                    }
                    invoker.method();
                    continue block7;
                }
                case BODY: {
                    if (param.getType() != byte[].class && param.getType() != String.class) {
                        invoker.zero(param.getType());
                        continue block7;
                    }
                    invoker.body(param.getType());
                    continue block7;
                }
                case OTHER: {
                    invoker.zero(param.getType());
                }
            }
        }
        return MethodUtils.unreflect(RouteInvoker.class.getDeclaredMethod("wrapper", ThunkInvoker.class, String.class, String.class, RequestMethod.class, Map.class, byte[].class), null).bindTo(invoker.build()).bindTo(this.mime);
    }

    public Response invoke(String path, RequestMethod method, Map<String, List<String>> headers, byte[] body) throws Throwable {
        return this.bound.invoke(path, method, headers, body);
    }

    private static enum TargetParameterKind {
        HEADER,
        PARAM,
        METHOD,
        BODY,
        OTHER;

    }

    private static class ThunkInvoker {
        private List<Thunk> thunks = new ArrayList<Thunk>();
        private MethodHandle target;
        private boolean built;

        public ThunkInvoker(MethodHandle target) {
            this.target = target;
            this.built = false;
        }

        public ThunkInvoker header(String name) {
            MethodHandle target = InternalThunks.HEADER_THUNK.bindTo(name);
            this.thunks.add(new Thunk(-1, target, ThunkKind.HEADER));
            return this;
        }

        public ThunkInvoker param(Pattern ptrn, AnyCodec<?> conv, int pos) {
            MethodHandle target = InternalThunks.PARAMETER_THUNK.bindTo(ptrn).bindTo(conv);
            this.thunks.add(new Thunk(pos, target, ThunkKind.PARAM));
            return this;
        }

        public ThunkInvoker method() {
            MethodHandle target = MethodHandles.identity(RequestMethod.class);
            this.thunks.add(new Thunk(-1, target, ThunkKind.METHOD));
            return this;
        }

        public ThunkInvoker body(Class<?> kind) {
            MethodHandle target = kind == String.class ? InternalThunks.BODY_THUNK : MethodHandles.identity(byte[].class);
            this.thunks.add(new Thunk(-1, target, ThunkKind.BODY));
            return this;
        }

        public ThunkInvoker zero(Class<?> kind) {
            Class wrappedKind = Primitives.wrap(kind);
            boolean isNumeric = Number.class.isAssignableFrom(wrappedKind);
            this.thunks.add(new Thunk(-1, MethodHandles.constant(kind, isNumeric ? Integer.valueOf(-1) : null), ThunkKind.ZERO));
            return this;
        }

        public Object invoke(String path, RequestMethod method, Map<String, List<String>> headers, byte[] body) throws Throwable {
            String[] parts = path.split("/{1,2}");
            ArrayList<Object> res = new ArrayList<Object>();
            for (Thunk thunk : this.thunks) {
                res.add(switch (thunk.kind) {
                    default -> throw new IncompatibleClassChangeError();
                    case ThunkKind.HEADER -> thunk.target.invoke(headers);
                    case ThunkKind.METHOD -> thunk.target.invoke(method);
                    case ThunkKind.PARAM -> thunk.target.invoke(parts[thunk.pos]);
                    case ThunkKind.BODY -> thunk.target.invoke(body);
                    case ThunkKind.ZERO -> thunk.target.invoke();
                });
            }
            return this.target.invoke(res.toArray());
        }

        public ThunkInvoker build() {
            if (this.built) {
                throw new RuntimeException("Thunk has been built!");
            }
            this.built = true;
            this.target = this.target.asSpreader(0, Object[].class, this.target.type().parameterCount());
            return this;
        }

        private static class InternalThunks {
            public static final MethodHandle PARAMETER_THUNK;
            public static final MethodHandle HEADER_THUNK;
            public static final MethodHandle BODY_THUNK;

            private InternalThunks() {
            }

            private static Object paramThunk(Pattern ptrn, AnyCodec<?> conv, String seg) {
                Matcher regex = ptrn.matcher(seg);
                if (!regex.matches()) {
                    return null;
                }
                return conv.decode(regex.group());
            }

            private static Object headerThunk(String name, Map<String, List<String>> headers) {
                if (headers == null) {
                    return null;
                }
                List<String> res = headers.get(name);
                if (res.size() == 1) {
                    return res.get(0);
                }
                return res;
            }

            private static String bodyThunk(byte[] body) {
                return new String(body, StandardCharsets.UTF_8);
            }

            static {
                try {
                    PARAMETER_THUNK = MethodUtils.unreflect(InternalThunks.class.getDeclaredMethod("paramThunk", Pattern.class, AnyCodec.class, String.class), null);
                    HEADER_THUNK = MethodUtils.unreflect(InternalThunks.class.getDeclaredMethod("headerThunk", String.class, Map.class), null);
                    BODY_THUNK = MethodUtils.unreflect(InternalThunks.class.getDeclaredMethod("bodyThunk", byte[].class), null);
                }
                catch (IllegalAccessException | NoSuchMethodException err) {
                    throw new RuntimeException(err);
                }
            }
        }

        private record Thunk(int pos, MethodHandle target, ThunkKind kind) {
        }

        private static enum ThunkKind {
            PARAM,
            METHOD,
            HEADER,
            BODY,
            ZERO;

        }
    }
}

