/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class ColoredPatternLayout
extends PatternLayout {
    private static final Map<Character, Integer> colorMap = Map.of(Character.valueOf('l'), 30, Character.valueOf('r'), 31, Character.valueOf('g'), 32, Character.valueOf('y'), 33, Character.valueOf('b'), 34, Character.valueOf('m'), 35, Character.valueOf('p'), 35, Character.valueOf('c'), 36, Character.valueOf('w'), 37, Character.valueOf('d'), 39);
    private static final Map<Character, Integer> optMap = Map.of(Character.valueOf('b'), 1, Character.valueOf('i'), 3, Character.valueOf('u'), 4, Character.valueOf('t'), 9);
    private static final String FMT_PREFIX = "\u001b[";
    private static final String FMT_SUFFIX = "m";
    private static final int FMT_RST = 0;
    private static final char FMT_SEP = ';';
    private static final String RST_SEQ = "\u001b[0m";
    private final String regexStr = "((?<color>%[a-z])(?<opt>\\{[a-z]+})?(?<txt>[^%]*)%)";
    private final Pattern regexPtrn = Pattern.compile("((?<color>%[a-z])(?<opt>\\{[a-z]+})?(?<txt>[^%]*)%)");

    private String fmt(LoggingEvent src) {
        String srcStr = super.format(src);
        Matcher regex = this.regexPtrn.matcher(srcStr);
        StringBuilder finalStr = new StringBuilder();
        while (regex.find()) {
            if (regex.start() == -1) continue;
            String txt = srcStr.substring(regex.start("txt"), regex.end("txt"));
            char color = srcStr.charAt(regex.start("color") + 1);
            if (color == 'n') {
                regex.appendReplacement(finalStr, RST_SEQ + txt);
                continue;
            }
            if (!colorMap.containsKey(Character.valueOf(color))) {
                src.getLogger().warn((Object)("Format String malformed; color: " + color + " does not exist"));
                regex.appendReplacement(finalStr, RST_SEQ + txt);
                continue;
            }
            int optPos = regex.start("opt");
            if (optPos == -1) {
                regex.appendReplacement(finalStr, FMT_PREFIX + String.valueOf(colorMap.get(Character.valueOf(color))) + FMT_SUFFIX + txt + RST_SEQ);
                continue;
            }
            StringBuilder fmtStr = new StringBuilder(txt).insert(0, FMT_SUFFIX).insert(0, colorMap.get(Character.valueOf(color)));
            int optEnd = regex.end("opt") - 1;
            String opts = srcStr.substring(optPos + 1, optEnd);
            for (char opt : opts.toCharArray()) {
                if (!optMap.containsKey(Character.valueOf(opt))) continue;
                fmtStr.insert(0, ';');
                fmtStr.insert(0, optMap.get(Character.valueOf(opt)));
            }
            fmtStr.insert(0, FMT_PREFIX);
            fmtStr.append(RST_SEQ);
            String finalFmtStr = Matcher.quoteReplacement(fmtStr.toString());
            regex.appendReplacement(finalStr, finalFmtStr);
        }
        regex.appendTail(finalStr);
        return finalStr.toString();
    }

    public String format(LoggingEvent src) {
        return this.fmt(src);
    }
}

