/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.route;

import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.racem.sea.body.Response;
import us.racem.sea.convert.AnyCodec;
import us.racem.sea.fish.Ocean;
import us.racem.sea.mark.methods.RequestMethod;
import us.racem.sea.route.RouteInvoker;
import us.racem.sea.route.RouteParser;
import us.racem.sea.route.RouteSegment;
import us.racem.sea.util.InterpolationLogger;
import us.racem.sea.util.SetUtils;

public class RouteRegistry {
    private static final InterpolationLogger logger = InterpolationLogger.getLogger(Ocean.class);
    private static final String logPrefix = "ROT";
    static final List<Route> tries = new ArrayList<Route>();
    static final Map<String, AnyCodec<?>> converters = new HashMap();
    private static final String delimRegexStr = "(?<!^)/{1,2}";
    private static final Pattern delimRegexPtrn = Pattern.compile("(?<!^)/{1,2}", 8);

    public static void register(String name, AnyCodec<?> conv) {
        converters.put(name, conv);
    }

    public static void register(String route, Method receiver, Object instance) {
        RouteSegment matcher = RouteParser.segmentsOf(route, receiver, instance);
        Pattern prefix = RouteParser.prefixOf(route);
        if (matcher == null) {
            logger.warn("%rFailed to parse route {}%", route);
            return;
        }
        tries.add(new Route(matcher, prefix));
    }

    private static RouteSegment lookupSegment(RouteSegment pivot, String part) {
        if (pivot == null) {
            return null;
        }
        for (RouteSegment next : pivot.succ()) {
            Matcher regex = next.ptrn().matcher(part);
            if (!regex.matches()) continue;
            return next;
        }
        return null;
    }

    private static RouteInvoker lookup(String path) {
        if (path.isBlank() || Objects.equals(path, "/") || Objects.equals(path, "//")) {
            if (!SetUtils.in("/", tries)) {
                return null;
            }
            RouteSegment pivot = SetUtils.take("/", tries).root();
            return pivot.bound();
        }
        String[] parts = delimRegexPtrn.split(path);
        if (parts.length == 0) {
            return null;
        }
        if (!SetUtils.in(parts[0], tries, (e, w) -> e.prefix.matcher((CharSequence)w).matches())) {
            return null;
        }
        RouteSegment pivot = SetUtils.take(parts[0], tries).root();
        for (int i = 1; i < parts.length; ++i) {
            if (pivot == null) {
                return null;
            }
            String part = parts[i];
            pivot = RouteRegistry.lookupSegment(pivot, part);
        }
        if (pivot == null) {
            return null;
        }
        return pivot.bound();
    }

    public static Response errorOf(String path, String message, int status) {
        return new Response(500, "{err: \"" + message + "\", route: \"" + path + "\", rayId: \"" + String.valueOf(UUID.randomUUID()) + "\"}", "application/json", new Map.Entry[0]);
    }

    public static Response requestOf(RequestMethod method, String path, Map<String, List<String>> headers, byte[] body) {
        RouteInvoker endpoint = RouteRegistry.lookup(path);
        if (endpoint == null) {
            logger.warn("%yRoute not found {}%", "/" + path);
            return RouteRegistry.errorOf(path, "No handler for route.", 500);
        }
        if (!endpoint.handles(method)) {
            logger.warn("%yInvalid Method {} on route {}%", new Object[]{method, "/" + path});
            return RouteRegistry.errorOf(path, "Unsupported method.", 405);
        }
        try {
            return endpoint.invoke(path, headers, body);
        }
        catch (Throwable err) {
            logger.error("%rRoute {} had error {}%", "/" + path, err);
            err.printStackTrace();
            return RouteRegistry.errorOf(path, "Internal application error", 500);
        }
    }

    public record Route(RouteSegment root, Pattern prefix) {
        @Override
        public boolean equals(Object obj) {
            Object object = obj;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Pattern.class}, (Object)object2, n)) {
                case 0 -> {
                    String ptrn = (String)object2;
                    yield ptrn.equals(this.prefix.toString());
                }
                case 1 -> {
                    Pattern ptrn = (Pattern)object2;
                    yield ptrn.equals(this.prefix);
                }
                default -> false;
            };
        }
    }
}

