/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import rawhttp.core.RawHttp;
import rawhttp.core.RawHttpRequest;
import rawhttp.core.RawHttpResponse;
import rawhttp.core.body.BodyReader;
import rawhttp.core.body.BytesBody;
import rawhttp.core.body.HttpMessageBody;
import us.racem.sea.body.Response;
import us.racem.sea.fish.Ocean;
import us.racem.sea.fish.OceanExecutable;
import us.racem.sea.mark.methods.RequestMethod;
import us.racem.sea.route.RouteRegistry;
import us.racem.sea.util.InterpolationLogger;

public class SeaServer
extends OceanExecutable {
    private static final ExecutorService executor = Executors.newFixedThreadPool(2);
    private static final InterpolationLogger logger = InterpolationLogger.getLogger(Ocean.class);
    private static final String logPrefix = "SRV";
    private static final String headerSeperator = "\r\n";
    private int port;
    private int max_header_size;
    private int max_body_size;
    private RawHttp parser;
    private ServerSocket srv;

    public SeaServer(int port, int max_body_size, int max_header_size) {
        try {
            this.port = port;
            this.max_body_size = max_body_size;
            this.max_header_size = max_header_size;
            this.srv = new ServerSocket(port);
            this.parser = new RawHttp();
        }
        catch (IOException err) {
            logger.warn("%rFailed to initialize HTTP Server: {}%", err);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket cs = this.srv.accept();
                    executor.submit(() -> this.read(cs));
                }
            }
            catch (IOException err) {
                logger.warn("%rError in HTTP Server: {}%", err);
                continue;
            }
            break;
        }
    }

    private void read(Socket cs) {
        try (InputStream is = cs.getInputStream();
             OutputStream os = cs.getOutputStream();){
            int reqSize = is.available();
            if (reqSize > this.max_body_size + this.max_header_size) {
                throw new IOException("Request too large!");
            }
            RawHttpRequest req = this.parser.parseRequest(is);
            String path = req.getUri().getPath().strip().replaceFirst("^/{1,2}", "");
            RequestMethod method = RequestMethod.of(req.getMethod());
            Map headers = req.getHeaders().asMap();
            logger.info("%bRequest {}%", "/" + path);
            byte[] body = null;
            if (req.getBody().isPresent()) {
                BodyReader bodyReader = (BodyReader)req.getBody().get();
                if (bodyReader.getLengthIfKnown().isPresent() && bodyReader.getLengthIfKnown().getAsLong() > (long)this.max_body_size) {
                    throw new IOException("Body too large!");
                }
                if (is.available() > this.max_body_size) {
                    throw new IOException("Body too large!");
                }
                body = ((BodyReader)req.getBody().get()).decodeBody();
            }
            Response res = RouteRegistry.requestOf(method, path, headers, body);
            RawHttpResponse<Void> rsp = this.encodeResponse(res);
            rsp.writeTo(os);
            cs.close();
        }
        catch (Exception err) {
            logger.warn("%rUnable to Serve: {}%", err);
        }
    }

    private RawHttpResponse<Void> encodeResponse(Response rsp) {
        String headers = this.encodeResponseHeaders(rsp);
        if (rsp.body != null) {
            return this.parser.parseResponse(headers).withBody((HttpMessageBody)new BytesBody(rsp.body));
        }
        return this.parser.parseResponse(headers);
    }

    private String encodeResponseHeaders(Response rsp) {
        String date = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneOffset.UTC));
        StringBuilder sb = new StringBuilder();
        byte[] body = rsp.body;
        sb.append("HTTP/1.1 ").append(rsp.op).append(headerSeperator);
        sb.append("Content-Type: ").append(rsp.mime).append(headerSeperator);
        sb.append("Content-Length: ").append(body == null ? 0 : body.length).append(headerSeperator);
        sb.append("Date: ").append(date).append(headerSeperator);
        return sb.toString();
    }
}

