/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SetUtils {
    public static <T> T[] of(T ... elem) {
        return elem;
    }

    @SafeVarargs
    public static <T> Set<T> union(Set<T> ... sets) {
        return Stream.of(sets).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @SafeVarargs
    public static <T> T[] union(T[] first, T[] ... rest) {
        int len = first.length;
        for (T[] array : rest) {
            len += array.length;
        }
        T[] res = Arrays.copyOf(first, len);
        int off = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, res, off, array.length);
            off += array.length;
        }
        return res;
    }

    public static <E, T> boolean in(E what, List<T> list) {
        for (T elem : list) {
            if (!elem.equals(what)) continue;
            return true;
        }
        return false;
    }

    public static <E, T> boolean in(E what, List<T> list, BiFunction<T, E, Boolean> condition) {
        for (T elem : list) {
            if (!condition.apply(elem, what).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static <E, T> T take(E what, List<T> list) {
        for (T elem : list) {
            if (!elem.equals(what)) continue;
            return elem;
        }
        return null;
    }

    public static <T> List<T> slice(List<T> original, int startPos, int endPos) {
        ArrayList<T> res = new ArrayList<T>();
        if (startPos == -1 || endPos == -1 || startPos > original.size() || endPos > original.size() || startPos > endPos) {
            return res;
        }
        res.addAll(original.subList(startPos, endPos));
        return res;
    }

    public static <T> List<T> slice(List<T> original, int startPos, Function<T, Boolean> condition) {
        int endPos = SetUtils.posOf(original, condition);
        if (endPos == -1) {
            return SetUtils.slice(original, startPos, original.size());
        }
        return SetUtils.slice(original, startPos, endPos);
    }

    public static <T> List<T> slice(List<T> original, Function<T, Boolean> condition) {
        return SetUtils.slice(original, SetUtils.posOf(original, condition), original.size());
    }

    public static <T> int posOf(List<T> original, Function<T, Boolean> condition) {
        for (int i = 0; i < original.size(); ++i) {
            T elem = original.get(i);
            if (!condition.apply(elem).booleanValue()) continue;
            return i;
        }
        return -1;
    }

    public static boolean xor(Object ... terms) {
        return Arrays.stream(terms).filter(Objects::nonNull).count() == 1L;
    }
}

