/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.fish;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import us.racem.sea.fish.OceanInjector;
import us.racem.sea.inject.RouteCodecInjector;
import us.racem.sea.inject.RouteMappingInjector;
import us.racem.sea.net.SeaServer;

public class Ocean {
    private final ExecutorService executor = Executors.newFixedThreadPool(4);

    public static void fill() {
        Ocean.fill(ConfigFactory.load());
    }

    public static void fill(Config config) {
        config.checkValid(ConfigFactory.defaultReference(), new String[]{"sea"});
        String prefix = config.getString("sea.prefix");
        int port = config.getInt("sea.port");
        int max_header_size = config.getInt("sea.max_header_size");
        int max_body_size = config.getInt("sea.max_body_size");
        SeaServer server = new SeaServer(port, max_body_size, max_header_size);
        OceanInjector injector = new OceanInjector(prefix, RouteCodecInjector.class, RouteMappingInjector.class);
        injector.run();
        server.run();
    }
}

