/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;

public class InterpolationLogger
extends Logger {
    public static String FQCN = InterpolationLogger.class.getName() + ".";
    private static final InterpolationLoggerFactory factory = new InterpolationLoggerFactory();
    private final String regexStr = "(\\{(?<idx>\\d|[a-f])?})";
    private final Pattern regexPtrn = Pattern.compile("(\\{(?<idx>\\d|[a-f])?})");
    private final StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

    public InterpolationLogger(String name) {
        super(name);
    }

    public static InterpolationLogger getLogger(Class clazz) {
        return (InterpolationLogger)LogManager.getLogger((String)clazz.getName(), (LoggerFactory)factory);
    }

    private String getLogPrefix() throws IllegalAccessException {
        Class source = this.walker.walk(frames -> frames.map(StackWalker.StackFrame::getDeclaringClass).skip(3L).findFirst()).orElse(null);
        if (source == null) {
            return "";
        }
        Field prefix = Arrays.stream(source.getDeclaredFields()).filter(f -> f.getName().equals("logPrefix")).findFirst().orElse(null);
        if (prefix == null) {
            return "";
        }
        if (!Modifier.isStatic(prefix.getModifiers())) {
            return "";
        }
        if (!prefix.getType().isAssignableFrom(String.class)) {
            return "";
        }
        if (Modifier.isPrivate(prefix.getModifiers())) {
            prefix.setAccessible(true);
        }
        return String.format("[%s] ", prefix.get(null));
    }

    private String fmt(String message, Object ... fmt) throws IllegalAccessException {
        Matcher regex = this.regexPtrn.matcher(message);
        StringBuilder finalStr = new StringBuilder(this.getLogPrefix());
        int curIdx = 0;
        while (regex.find()) {
            int fmtPos;
            int fmtIdx;
            if (regex.start() == -1 || (fmtIdx = (fmtPos = regex.start("idx") > 0 ? (int)regex.group("idx").charAt(0) : -1) > 0 ? Character.digit(fmtPos, 16) : -1) >= fmt.length || curIdx >= fmt.length) continue;
            String fmtStr = fmtIdx >= 0 ? String.valueOf(fmt[fmtIdx]) : String.valueOf(fmt[curIdx]);
            String finalFmtStr = Matcher.quoteReplacement(fmtStr);
            regex.appendReplacement(finalStr, finalFmtStr);
            ++curIdx;
        }
        regex.appendTail(finalStr);
        return finalStr.toString();
    }

    public void warn(String message, Object ... objs) {
        try {
            String fmtMessage = this.fmt(message, objs);
            super.log(FQCN, (Priority)Level.WARN, (Object)fmtMessage, null);
        }
        catch (Exception e) {
            super.error((Object)"[Meta]: Normal Logger had error: ", (Throwable)e);
        }
    }

    public void info(String message, Object ... objs) {
        try {
            String fmtMessage = this.fmt(message, objs);
            super.log(FQCN, (Priority)Level.INFO, (Object)fmtMessage, null);
        }
        catch (Exception e) {
            super.error((Object)"[Meta]: Normal Logger had error: ", (Throwable)e);
        }
    }

    public void error(String message, Object ... objs) {
        try {
            String fmtMessage = this.fmt(message, objs);
            super.log(FQCN, (Priority)Level.ERROR, (Object)fmtMessage, null);
        }
        catch (Exception e) {
            super.error((Object)"[Meta]: Normal Logger had error: ", (Throwable)e);
        }
    }

    public void warn(Object message) {
        try {
            String fmtMessage = this.fmt(String.valueOf(message), new Object[0]);
            super.log(FQCN, (Priority)Level.WARN, (Object)fmtMessage, null);
        }
        catch (Exception e) {
            super.error((Object)"[Meta]: Normal Logger had error: ", (Throwable)e);
        }
    }

    public void info(Object message) {
        try {
            String fmtMessage = this.fmt(String.valueOf(message), new Object[0]);
            super.log(FQCN, (Priority)Level.INFO, (Object)fmtMessage, null);
        }
        catch (Exception e) {
            super.error((Object)"[Meta]: Normal Logger had error: ", (Throwable)e);
        }
    }

    public void error(Object message) {
        try {
            String fmtMessage = this.fmt(String.valueOf(message), new Object[0]);
            super.log(FQCN, (Priority)Level.ERROR, (Object)fmtMessage, null);
        }
        catch (Exception e) {
            super.error((Object)"[Meta]: Normal Logger had error: ", (Throwable)e);
        }
    }

    public static class InterpolationLoggerFactory
    implements LoggerFactory {
        public Logger makeNewLoggerInstance(String name) {
            return new InterpolationLogger(name);
        }
    }
}

