/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.body;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Response {
    private static final Map<Integer, String> opcodes = new HashMap<Integer, String>(){
        {
            this.put(100, "Continue");
            this.put(101, "Switching Protocols");
            this.put(102, "Processing");
            this.put(103, "Early Hints");
            this.put(200, "OK");
            this.put(201, "Created");
            this.put(202, "Accepted");
            this.put(203, "Non-Authoritative Information");
            this.put(204, "No Content");
            this.put(205, "Reset Content");
            this.put(206, "Partial Content");
            this.put(207, "Multi-Status (WebDAV)");
            this.put(208, "Already Reported (WebDAV)");
            this.put(226, "IM Used");
            this.put(300, "Multiple Choices");
            this.put(301, "Moved Permanently");
            this.put(302, "Found");
            this.put(303, "See Other");
            this.put(304, "Not Modified");
            this.put(305, "Use Proxy");
            this.put(306, "(Unused)");
            this.put(307, "Temporary Redirect");
            this.put(308, "Permanent Redirect (experimental)");
            this.put(400, "Bad Request");
            this.put(401, "Unauthorized");
            this.put(402, "Payment Required");
            this.put(403, "Forbidden");
            this.put(404, "Not Found");
            this.put(405, "Method Not Allowed");
            this.put(406, "Not Acceptable");
            this.put(407, "Proxy Authentication Required");
            this.put(408, "Request Timeout");
            this.put(409, "Conflict");
            this.put(410, "Gone");
            this.put(411, "Length Required");
            this.put(412, "Precondition Failed");
            this.put(413, "Request Entity Too Large");
            this.put(414, "Request-URI Too Long");
            this.put(415, "Unsupported Media Type");
            this.put(416, "Requested Range Not Satisfiable");
            this.put(417, "Expectation Failed");
            this.put(418, "I'm a teapot (RFC 2324)");
            this.put(420, "Enhance Your Calm (Twitter)");
            this.put(422, "Unprocessable Entity (WebDAV)");
            this.put(423, "Locked (WebDAV)");
            this.put(424, "Failed Dependency (WebDAV)");
            this.put(425, "Reserved for WebDAV");
            this.put(426, "Upgrade Required");
            this.put(428, "Precondition Required");
            this.put(429, "Too Many Requests");
            this.put(431, "Request Header Fields Too Large");
            this.put(444, "No Response (Nginx)");
            this.put(449, "Retry With (Microsoft)");
            this.put(450, "Blocked by Windows Parental Controls (Microsoft)");
            this.put(451, "Unavailable For Legal Reasons");
            this.put(499, "Client Closed Request (Nginx)");
            this.put(500, "Internal Server Error");
            this.put(501, "Not Implemented");
            this.put(502, "Bad Gateway");
            this.put(503, "Service Unavailable");
            this.put(504, "Gateway Timeout");
            this.put(505, "HTTP Version Not Supported");
            this.put(506, "Variant Also Negotiates (Experimental)");
            this.put(507, "Insufficient Storage (WebDAV)");
            this.put(508, "Loop Detected (WebDAV)");
            this.put(509, "Bandwidth Limit Exceeded (Apache)");
            this.put(510, "Not Extended");
            this.put(511, "Network Authentication Required");
            this.put(598, "Network read timeout error");
            this.put(599, "Network connect timeout error");
        }
    };
    public final String op;
    public final byte[] body;
    public final String mime;
    public final Map<String, List<String>> headers;

    private static String encodeOp(int status) {
        if (!opcodes.containsKey(status)) {
            return "500: Internal Server Error";
        }
        String message = opcodes.get(status);
        return status + ": " + message;
    }

    @SafeVarargs
    public Response(int op, byte[] body, String mime, Map.Entry<String, List<String>> ... headers) {
        this.op = Response.encodeOp(op);
        this.body = body;
        this.mime = mime;
        this.headers = Map.ofEntries(headers);
    }

    @SafeVarargs
    public Response(int op, String body, String mime, Map.Entry<String, List<String>> ... headers) {
        this(op, body.getBytes(StandardCharsets.UTF_8), mime, headers);
    }
}

