/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.util;

import com.google.common.net.InetAddresses;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class ArgumentParser {
    private static final String regexStr = "(?<DSH>[-]+)(?:\\s*)(?<ARG>[A-Za-z_.]+)(?:\\s*)(?<VAL>[A-Za-z0-9_+/=.]+)";
    private static final Pattern regexPtrn = Pattern.compile("(?<DSH>[-]+)(?:\\s*)(?<ARG>[A-Za-z_.]+)(?:\\s*)(?<VAL>[A-Za-z0-9_+/=.]+)");

    public static Map<String, String> parse(String[] arr) {
        HashMap<String, String> args = new HashMap<String, String>();
        String chrs = String.join((CharSequence)" ", arr);
        Matcher regex = regexPtrn.matcher(chrs);
        while (regex.find()) {
            if (regex.start() == -1) continue;
            int dashes = regex.group("DSH").length();
            String arg = regex.group("ARG");
            String val = regex.group("VAL");
            args.put(arg, val);
        }
        return args;
    }

    public static String uuidToBase64(UUID uuid) {
        String id = uuid.toString();
        return Base64.encodeBase64String((byte[])id.getBytes(StandardCharsets.UTF_8));
    }

    public static UUID uuidFromBase64(String id) {
        byte[] bytes = Base64.decodeBase64((String)id);
        String base64 = new String(bytes, StandardCharsets.UTF_8);
        return UUID.fromString(base64);
    }

    public static UUID parseUUID(String id) {
        try {
            return ArgumentParser.uuidFromBase64(id);
        }
        catch (Exception ex) {
            return UUID.randomUUID();
        }
    }

    public static String parseIP(String rem) {
        try {
            if (!InetAddresses.isInetAddress((String)rem)) {
                return null;
            }
        }
        catch (Exception err) {
            return null;
        }
        return rem;
    }

    public static int parseInt(String port) {
        if (port == null) {
            return -1;
        }
        return Integer.parseInt(port);
    }
}

