/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.route;

import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import us.racem.sea.fish.Ocean;
import us.racem.sea.route.RouteInvoker;
import us.racem.sea.util.InterpolationLogger;
import us.racem.sea.util.SetUtils;

public class RouteSegment {
    private static final InterpolationLogger logger = InterpolationLogger.getLogger(Ocean.class);
    private static final String logPrefix = "SEG";
    private final String name;
    private final String segment;
    private final Pattern segmentPtrn;
    private final RouteSegment prev;
    private final List<RouteSegment> next;
    private RouteInvoker endpoint;

    public RouteSegment(String name, String segment, RouteSegment prev, Method receiver, Object instance) {
        this.name = name;
        this.segment = segment;
        this.segmentPtrn = Pattern.compile(segment);
        this.prev = prev;
        this.endpoint = receiver != null ? new RouteInvoker(this, receiver, instance) : null;
        this.next = new ArrayList<RouteSegment>();
    }

    public RouteSegment prev() {
        return this.prev;
    }

    public List<RouteSegment> succ() {
        return this.next;
    }

    public Pattern ptrn() {
        return this.segmentPtrn;
    }

    public RouteSegment fork(String name, String segment) {
        if (!SetUtils.in(segment, this.next)) {
            RouteSegment node = new RouteSegment(name, segment, this, null, null);
            this.next.add(node);
            return node;
        }
        return SetUtils.take(segment, this.next);
    }

    public RouteInvoker bound() {
        return this.endpoint;
    }

    public void bind(Method receiver, Object instance) {
        this.endpoint = new RouteInvoker(this, receiver, instance);
    }

    public boolean equals(Object other) {
        Object object = other;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, RouteSegment.class}, (Object)object2, n)) {
            case 0 -> {
                String seg = (String)object2;
                yield seg.equals(this.segment);
            }
            case 1 -> {
                RouteSegment node = (RouteSegment)object2;
                yield node.segment.equals(this.segment);
            }
            default -> false;
        };
    }

    public boolean nameEquals(String name) {
        return this.name.equals(name);
    }

    private String stringify(RouteSegment node) {
        if (node.next == null || node.next.size() == 0) {
            return node.segment;
        }
        String spacer = " -> ";
        StringBuilder treeBuilder = new StringBuilder();
        treeBuilder.append(node.segment).append(spacer);
        for (RouteSegment succ : node.succ()) {
            treeBuilder.append(this.stringify(succ));
        }
        return treeBuilder.toString();
    }

    public String toString() {
        return this.stringify(this);
    }
}

